/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.webbrowser;

import com.mathworks.mde.webbrowser.WebBrowserAction;
import com.mathworks.mlwidgets.html.HTMLBrowserPanel;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class WebBrowserActionQueue {
    private final List<WebBrowserAction> fQueue = new LinkedList<WebBrowserAction>();
    private HTMLBrowserPanel fBrowserPanel;

    public synchronized void handleAction(WebBrowserAction webBrowserAction) {
        if (this.fBrowserPanel == null || !this.fQueue.isEmpty()) {
            this.fQueue.add(webBrowserAction);
        } else {
            webBrowserAction.whenReady(this.fBrowserPanel);
        }
    }

    public synchronized void setBrowserPanel(HTMLBrowserPanel hTMLBrowserPanel) {
        this.fBrowserPanel = hTMLBrowserPanel;
        if (!this.fQueue.isEmpty()) {
            this.doNextAction(hTMLBrowserPanel);
        }
    }

    private void doNextAction(final HTMLBrowserPanel hTMLBrowserPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebBrowserAction webBrowserAction = (WebBrowserAction)WebBrowserActionQueue.this.fQueue.get(0);
                webBrowserAction.whenReady(hTMLBrowserPanel);
                WebBrowserActionQueue.this.afterExecution();
            }
        });
    }

    private synchronized void afterExecution() {
        this.fQueue.remove(0);
        if (!this.fQueue.isEmpty()) {
            this.doNextAction(this.fBrowserPanel);
        }
    }
}

