/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.webbrowser;

import com.mathworks.mde.webbrowser.WebBrowserUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.net.transport.ProxyTestThread;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.MaskFormatter;

public class WebPrefsPanel
extends MJPanel {
    private static final String RESDIR = "com.mathworks.mde.webbrowser.resources.";
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.webbrowser.resources.RES_WebBrowser");
    private static WebPrefsPanel sPrefsPanel = null;
    private MJTextField fProxyHostField;
    private MJFormattedTextField fProxyPortField;
    private MJCheckBox fUseProxyCheckbox;
    private MJLabel fProxyHostLabel;
    private MJLabel fProxyPortLabel;
    private MJTextField fProxyUsernameField;
    private JPasswordField fProxyPasswordField;
    private MJCheckBox fUseProxyAuthenticationCheckbox;
    private MJLabel fProxyUsernameLabel;
    private MJLabel fProxyPasswordLabel;
    private MJButton fTestConnectionButton;
    private MJLabel fTestConnectionResult;
    private MJTextField fSystemBrowserTextField;
    private MJTextField fSystemBrowserOptions;
    private MJTextField fPdfInputField;
    private MJCheckBox fConnectorAutoStartCheckbox = null;

    private WebPrefsPanel(Dimension dimension) {
        MaskFormatter maskFormatter;
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 4, 6, 196608, (Object)0, null));
        mJPanel.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
        this.fUseProxyCheckbox = new MJCheckBox(sRes.getString("prefs.proxyoption"));
        this.fUseProxyCheckbox.setName("ProxyCheckbox");
        this.fUseProxyCheckbox.setSelected(HTMLPrefs.getUseProxy());
        this.fUseProxyCheckbox.addItemListener((ItemListener)new ProxyItemListener());
        mJPanel.add((Component)this.fUseProxyCheckbox);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 3, 196608, (Object)0, null));
        mJPanel2.setBorder((Border)new EmptyBorder(0, 20, 4, 4));
        String string = HTMLPrefs.getProxyHost();
        this.fProxyHostField = new MJTextField();
        this.fProxyHostField.setName("ProxyHostFieldTextField");
        this.fProxyHostField.setColumns(20);
        this.fProxyHostField.setText(string);
        this.fProxyHostLabel = new MJLabel(sRes.getString("prefs.proxyhost"));
        mJPanel2.add((Component)this.fProxyHostLabel);
        mJPanel2.add((Component)this.fProxyHostField);
        String string2 = HTMLPrefs.getProxyPort();
        try {
            maskFormatter = new MaskFormatter("#######");
            maskFormatter.setValidCharacters("0123456789");
            this.fProxyPortField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)maskFormatter);
        }
        catch (ParseException parseException) {
            this.fProxyPortField = new MJFormattedTextField();
        }
        this.fProxyPortField.setFocusLostBehavior(0);
        this.fProxyPortField.setName("ProxyPortTextField");
        this.fProxyPortField.setColumns(7);
        this.fProxyPortField.setText(string2);
        this.fProxyPortLabel = new MJLabel(sRes.getString("prefs.proxyport"));
        mJPanel2.add((Component)this.fProxyPortLabel);
        mJPanel2.add((Component)this.fProxyPortField);
        maskFormatter = new MJPanel((LayoutManager)new MGridLayout(5, 1, 4, 6, 196608, (Object)0, null));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(sRes.getString("prefs.proxy"));
        maskFormatter.setBorder(titledBorder);
        maskFormatter.add((Component)mJPanel);
        maskFormatter.add((Component)mJPanel2);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new MGridLayout(0, 1, 4, 6, 196608, (Object)0, null));
        mJPanel3.setBorder((Border)new EmptyBorder(4, 24, 4, 4));
        this.fUseProxyAuthenticationCheckbox = new MJCheckBox(sRes.getString("prefs.proxyauthenticationoption"));
        this.fUseProxyAuthenticationCheckbox.setName("ProxyAuthenticationCheckbox");
        this.fUseProxyAuthenticationCheckbox.setSelected(HTMLPrefs.getUseProxyAuthentication());
        this.fUseProxyAuthenticationCheckbox.addItemListener((ItemListener)new ProxyItemListener());
        mJPanel3.add((Component)this.fUseProxyAuthenticationCheckbox);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 3, 196608, (Object)0, null));
        mJPanel4.setBorder((Border)new EmptyBorder(0, 40, 4, 4));
        String string3 = HTMLPrefs.getProxyUsername();
        this.fProxyUsernameField = new MJTextField();
        this.fProxyUsernameField.setName("ProxyUsernameFieldTextField");
        this.fProxyUsernameField.setColumns(20);
        this.fProxyUsernameField.setText(string3);
        this.fProxyUsernameLabel = new MJLabel(sRes.getString("prefs.proxyusername"));
        mJPanel4.add((Component)this.fProxyUsernameLabel);
        mJPanel4.add((Component)this.fProxyUsernameField);
        String string4 = HTMLPrefs.getProxyPassword();
        this.fProxyPasswordField = new JPasswordField();
        this.fProxyPasswordField.setName("ProxyPasswordTextField");
        this.fProxyPasswordField.setColumns(20);
        this.fProxyPasswordField.setText(string4);
        this.fProxyPasswordLabel = new MJLabel(sRes.getString("prefs.proxypassword"));
        mJPanel4.add((Component)this.fProxyPasswordLabel);
        mJPanel4.add((Component)this.fProxyPasswordField);
        maskFormatter.add((Component)mJPanel3);
        maskFormatter.add((Component)mJPanel4);
        maskFormatter.add((Component)this.createTestConnectionPanel());
        this.enableDisableOptions();
        int n = 1;
        ++n;
        MJPanel mJPanel5 = this.createConnectorPanel(dimension);
        if (PlatformInfo.isXWindows()) {
            n += 2;
        }
        this.setLayout((LayoutManager)new MGridLayout(n, 1, 8, 8, 131072));
        this.add((Component)((Object)maskFormatter));
        if (mJPanel5 != null) {
            this.add((Component)mJPanel5);
        }
        if (PlatformInfo.isXWindows()) {
            MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel6.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
            TitledBorder titledBorder2 = BorderFactory.createTitledBorder(sRes.getString("prefs.system_browser_group"));
            mJPanel6.setBorder((Border)titledBorder2);
            MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(sRes.getString("prefs.system_browser"), true);
            mJMultilineLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
            mJMultilineLabel.setMaxWidth(dimension.width - 12);
            mJPanel6.add((Component)mJMultilineLabel, (Object)"North");
            this.fSystemBrowserTextField = new MJTextField(HTMLPrefs.getSystemBrowser(), 10);
            this.fSystemBrowserOptions = new MJTextField(HTMLPrefs.getSystemBrowserOptions(), 10);
            MJPanel mJPanel7 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel7.add((Component)new MJLabel(sRes.getString("prefs.command")), (Object)"West");
            mJPanel7.add((Component)this.fSystemBrowserTextField, (Object)"Center");
            MJPanel mJPanel8 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel8.add((Component)new MJLabel(sRes.getString("prefs.options")), (Object)"West");
            mJPanel8.add((Component)this.fSystemBrowserOptions, (Object)"Center");
            MJPanel mJPanel9 = new MJPanel((LayoutManager)new GridLayout(1, 2, 10, 10));
            mJPanel9.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
            mJPanel9.add((Component)mJPanel7);
            mJPanel9.add((Component)mJPanel8);
            mJPanel6.add((Component)mJPanel9, (Object)"Center");
            this.add((Component)mJPanel6);
            MJPanel mJPanel10 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel10.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
            TitledBorder titledBorder3 = BorderFactory.createTitledBorder(sRes.getString("prefs.pdf_reader"));
            mJPanel10.setBorder((Border)titledBorder3);
            String string5 = WebPrefsPanel.getPdfReader();
            this.fPdfInputField = new MJTextField(string5, 20);
            MJButton mJButton = new MJButton("...");
            mJButton.setMargin(new Insets(0, 0, 0, 0));
            mJButton.addActionListener(new PDFBrowseActionListener());
            MJPanel mJPanel11 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
            mJPanel11.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
            mJPanel11.add((Component)this.fPdfInputField, (Object)"Center");
            mJPanel11.add((Component)mJButton, (Object)"East");
            mJPanel10.add((Component)mJPanel11);
            this.add((Component)mJPanel10);
        }
    }

    private MJPanel createConnectorPanel(Dimension dimension) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(sRes.getString("prefs.connector_title"));
        mJPanel.setBorder((Border)titledBorder);
        this.fConnectorAutoStartCheckbox = new MJCheckBox(sRes.getString("prefs.connector_enable_autostart"));
        this.fConnectorAutoStartCheckbox.setName("EnableAutoStartCheckBox");
        this.fConnectorAutoStartCheckbox.setSelected(HTMLPrefs.getAutoStartEnabled());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
        mJPanel2.add((Component)this.fConnectorAutoStartCheckbox, (Object)"West");
        mJPanel.add((Component)mJPanel2);
        return mJPanel;
    }

    private MJPanel createTestConnectionPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
        this.fTestConnectionButton = new MJButton(sRes.getString("prefs.test_connection"));
        this.fTestConnectionButton.setName("TestConnectionButton");
        this.fTestConnectionButton.addActionListener((ActionListener)new ProxyTestListener());
        this.fTestConnectionResult = new MJLabel();
        mJPanel.add((Component)this.fTestConnectionButton);
        mJPanel.add((Component)this.fTestConnectionResult);
        return mJPanel;
    }

    private void enableDisableOptions() {
        boolean bl = this.fUseProxyCheckbox.isSelected();
        this.fProxyHostField.setEnabled(bl);
        this.fProxyPortField.setEnabled(bl);
        this.fProxyHostLabel.setEnabled(bl);
        this.fProxyPortLabel.setEnabled(bl);
        this.fUseProxyAuthenticationCheckbox.setEnabled(bl);
        boolean bl2 = bl && this.fUseProxyAuthenticationCheckbox.isSelected();
        this.fProxyUsernameField.setEnabled(bl2);
        this.fProxyPasswordField.setEnabled(bl2);
        this.fProxyUsernameLabel.setEnabled(bl2);
        this.fProxyPasswordLabel.setEnabled(bl2);
        this.fTestConnectionButton.setEnabled(bl);
        this.fTestConnectionResult.setEnabled(bl);
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new WebPrefsPanel(dimension);
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    private void savePrefs() {
        if (!(HTMLPrefs.getUseProxy() == this.fUseProxyCheckbox.isSelected() && HTMLPrefs.getProxyHost().equals(this.fProxyHostField.getText()) && HTMLPrefs.getProxyPort().equals(this.fProxyPortField.getText().trim()) && HTMLPrefs.getUseProxyAuthentication() == this.fUseProxyAuthenticationCheckbox.isSelected() && HTMLPrefs.getProxyUsername().equals(this.fProxyUsernameField.getText()) && HTMLPrefs.getProxyPassword().equals(new String(this.fProxyPasswordField.getPassword())))) {
            HTMLPrefs.setUseProxy((boolean)this.fUseProxyCheckbox.isSelected());
            HTMLPrefs.setProxyHost((String)this.fProxyHostField.getText());
            HTMLPrefs.setProxyPort((String)this.fProxyPortField.getText().trim());
            HTMLPrefs.setUseProxyAuthentication((boolean)this.fUseProxyAuthenticationCheckbox.isSelected());
            HTMLPrefs.setProxyUsername((String)this.fProxyUsernameField.getText());
            HTMLPrefs.setProxyPassword((String)new String(this.fProxyPasswordField.getPassword()));
            HTMLPrefs.setProxySettings();
        }
        if (PlatformInfo.isXWindows()) {
            HTMLPrefs.setSystemBrowser((String)this.fSystemBrowserTextField.getText());
            HTMLPrefs.setSystemBrowserOptions((String)this.fSystemBrowserOptions.getText());
            String string = this.fPdfInputField.getText();
            if (string != null) {
                WebBrowserUtils.setPdfReader(string);
            }
        }
        HTMLPrefs.setAutoStartEnabled((boolean)this.fConnectorAutoStartCheckbox.isSelected());
    }

    public static boolean validatePrefsPanel() {
        return sPrefsPanel == null || sPrefsPanel.validateOptions();
    }

    private boolean validateOptions() {
        boolean bl = true;
        int n = 0;
        if (this.fUseProxyCheckbox.isSelected()) {
            if (this.fProxyHostField.getText().equals("")) {
                ++n;
                bl = false;
            }
            try {
                int n2 = Integer.parseInt(this.fProxyPortField.getText().trim());
                if (n2 > 65535 || n2 < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                n += 2;
                bl = false;
            }
        }
        switch (n) {
            case 1: {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)sRes.getString("prefs.empty_string"), (String)sRes.getString("prefs.error_title"), (int)2);
                break;
            }
            case 2: {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)sRes.getString("prefs.integer_required"), (String)sRes.getString("prefs.error_title"), (int)2);
                break;
            }
            case 3: {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)sRes.getString("prefs.no_input"), (String)sRes.getString("prefs.error_title"), (int)2);
            }
        }
        return bl;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_web_prefs"};
    }

    private static String getPdfReader() {
        if (PlatformInfo.isWindows()) {
            return NativeJava.getAcrobatPath();
        }
        return WebBrowserUtils.getPdfReader();
    }

    private class PDFBrowseActionListener
    implements ActionListener {
        private PDFBrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog((Frame)SwingUtilities.windowForComponent((Component)((Object)sPrefsPanel)), sRes.getString("prefs.pdf_browse_title"), 0);
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            if (string != null) {
                File file = new File(fileDialog.getDirectory(), string);
                WebPrefsPanel.this.fPdfInputField.setText(file.getAbsolutePath());
            }
        }
    }

    private class ProxyItemListener
    implements ItemListener {
        private ProxyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            WebPrefsPanel.this.enableDisableOptions();
        }
    }

    private class ProxyTestListener
    implements ActionListener {
        private ProxyTestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (WebPrefsPanel.validatePrefsPanel()) {
                boolean bl;
                WebPrefsPanel.this.savePrefs();
                ProxyTestThread proxyTestThread = new ProxyTestThread();
                try {
                    Logger logger = Logger.getLogger("SilentLogger");
                    logger.setLevel(Level.OFF);
                    proxyTestThread.setLogger(logger);
                    proxyTestThread.run();
                    bl = proxyTestThread.isSuccess();
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    WebPrefsPanel.this.fTestConnectionResult.setText(sRes.getString("prefs.success"));
                } else {
                    WebPrefsPanel.this.fTestConnectionResult.setText(sRes.getString("prefs.failure"));
                }
            }
        }
    }
}

