/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class IC2
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("IC2");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("IC2", 2, 3);
    private long native_cookie;
    private Object native_lock;
    private static final int[] S_BOX = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    private int[] sKey = new int[64];
    public static final int BLOCK_SIZE = 8;

    private static void debug(String s) {
        err.println("IC2: " + s);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(IC2.getLibMajorVersion(), IC2.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    linkStatus.fail(e);
                    if (debuglevel <= 2) break block8;
                    IC2.debug(e.getMessage());
                }
            }
            if (debuglevel > 2) {
                IC2.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    public IC2() {
        super(false, false, "Cryptix");
        this.link();
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String error = this.native_finalize();
                if (error != null) {
                    IC2.debug(error + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        Object newin;
        boolean doEncrypt;
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int blockCount = inLen / 8;
        inLen = blockCount * 8;
        boolean bl = doEncrypt = this.getState() == 1;
        if (in == out && (outOffset >= inOffset && (long)outOffset < (long)inOffset + (long)inLen || inOffset >= outOffset && (long)inOffset < (long)outOffset + (long)inLen)) {
            newin = new byte[inLen];
            System.arraycopy(in, inOffset, newin, 0, inLen);
            in = newin;
            inOffset = 0;
        }
        if (this.native_lock != null) {
            newin = this.native_lock;
            synchronized (newin) {
                if (inOffset < 0 || (long)inOffset + (long)inLen > (long)((byte[])in).length || outOffset < 0 || (long)outOffset + (long)inLen > (long)out.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int i = 0;
                while (i < blockCount) {
                    if (0 == this.native_crypt(this.native_cookie, (byte[])in, inOffset, out, outOffset, doEncrypt)) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    inOffset += 8;
                    outOffset += 8;
                    ++i;
                }
            }
        } else if (doEncrypt) {
            int i = 0;
            while (i < blockCount) {
                this.blockEncrypt((byte[])in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
                ++i;
            }
        } else {
            int i = 0;
            while (i < blockCount) {
                this.blockDecrypt((byte[])in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
                ++i;
            }
        }
        return inLen;
    }

    private void makeKey(Key key) throws KeyException {
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new KeyException("Null IC2 user key");
        }
        int len = userkey.length;
        if (len > 128) {
            throw new KeyException("Invalid IC2 user key size");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, userkey));
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        IC2.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        int[] sk = new int[128];
        int i = 0;
        while (i < len) {
            sk[i] = userkey[i] & 0xFF;
            ++i;
        }
        int i2 = len;
        while (i2 < 128) {
            sk[i2] = S_BOX[sk[i2 - len] + sk[i2 - 1] & 0xFF];
            ++i2;
        }
        sk[128 - len] = S_BOX[sk[128 - len] & 0xFF];
        int i3 = 127 - len;
        while (i3 >= 0) {
            sk[i3] = S_BOX[sk[i3 + len] ^ sk[i3 + 1]];
            --i3;
        }
        int i4 = 63;
        while (i4 >= 0) {
            this.sKey[i4] = (sk[i4 * 2 + 1] << 8 | sk[i4 * 2]) & 0xFFFF;
            --i4;
        }
    }

    private void blockEncrypt(byte[] in, int inOff, byte[] out, int outOff) {
        int w0 = in[inOff++] & 0xFF | (in[inOff++] & 0xFF) << 8;
        int w1 = in[inOff++] & 0xFF | (in[inOff++] & 0xFF) << 8;
        int w2 = in[inOff++] & 0xFF | (in[inOff++] & 0xFF) << 8;
        int w3 = in[inOff++] & 0xFF | (in[inOff] & 0xFF) << 8;
        int j = 0;
        int i = 0;
        while (i < 16) {
            w0 = w0 + (w1 & ~w3) + (w2 & w3) + this.sKey[j++] & 0xFFFF;
            w0 = w0 << 1 | w0 >>> 15;
            w1 = w1 + (w2 & ~w0) + (w3 & w0) + this.sKey[j++] & 0xFFFF;
            w1 = w1 << 2 | w1 >>> 14;
            w2 = w2 + (w3 & ~w1) + (w0 & w1) + this.sKey[j++] & 0xFFFF;
            w2 = w2 << 3 | w2 >>> 13;
            w3 = w3 + (w0 & ~w2) + (w1 & w2) + this.sKey[j++] & 0xFFFF;
            w3 = w3 << 5 | w3 >>> 11;
            if (i == 4 || i == 10) {
                w2 += this.sKey[(w1 += this.sKey[(w0 += this.sKey[w3 & 0x3F]) & 0x3F]) & 0x3F];
                w3 += this.sKey[w2 & 0x3F];
            }
            ++i;
        }
        out[outOff++] = (byte)w0;
        out[outOff++] = (byte)(w0 >>> 8);
        out[outOff++] = (byte)w1;
        out[outOff++] = (byte)(w1 >>> 8);
        out[outOff++] = (byte)w2;
        out[outOff++] = (byte)(w2 >>> 8);
        out[outOff++] = (byte)w3;
        out[outOff] = (byte)(w3 >>> 8);
    }

    private void blockDecrypt(byte[] in, int inOff, byte[] out, int outOff) {
        int w0 = in[inOff + 0] & 0xFF | (in[inOff + 1] & 0xFF) << 8;
        int w1 = in[inOff + 2] & 0xFF | (in[inOff + 3] & 0xFF) << 8;
        int w2 = in[inOff + 4] & 0xFF | (in[inOff + 5] & 0xFF) << 8;
        int w3 = in[inOff + 6] & 0xFF | (in[inOff + 7] & 0xFF) << 8;
        int j = 63;
        int i = 15;
        while (i >= 0) {
            w3 = (w3 >>> 5 | w3 << 11) & 0xFFFF;
            w3 = w3 - (w0 & ~w2) - (w1 & w2) - this.sKey[j--] & 0xFFFF;
            w2 = (w2 >>> 3 | w2 << 13) & 0xFFFF;
            w2 = w2 - (w3 & ~w1) - (w0 & w1) - this.sKey[j--] & 0xFFFF;
            w1 = (w1 >>> 2 | w1 << 14) & 0xFFFF;
            w1 = w1 - (w2 & ~w0) - (w3 & w0) - this.sKey[j--] & 0xFFFF;
            w0 = (w0 >>> 1 | w0 << 15) & 0xFFFF;
            w0 = w0 - (w1 & ~w3) - (w2 & w3) - this.sKey[j--] & 0xFFFF;
            if (i == 11 || i == 5) {
                w3 = w3 - this.sKey[w2 & 0x3F] & 0xFFFF;
                w2 = w2 - this.sKey[w1 & 0x3F] & 0xFFFF;
                w1 = w1 - this.sKey[w0 & 0x3F] & 0xFFFF;
                w0 = w0 - this.sKey[w3 & 0x3F] & 0xFFFF;
            }
            --i;
        }
        out[outOff++] = (byte)w0;
        out[outOff++] = (byte)(w0 >>> 8);
        out[outOff++] = (byte)w1;
        out[outOff++] = (byte)(w1 >>> 8);
        out[outOff++] = (byte)w2;
        out[outOff++] = (byte)(w2 >>> 8);
        out[outOff++] = (byte)w3;
        out[outOff] = (byte)(w3 >>> 8);
    }
}

