/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.CertificateException;
import ice.cert.X509Certificate;
import ice.cert.X509CertificateFactory;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.ServerHandshake;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;

final class ServerCertificate
extends ServerHandshake {
    private static final int[] I = new int[]{14, 13, 12};

    ServerCertificate(SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) throws IOException {
        super(sSLSocket, sessionState, connectionState, handshakeState);
        byte[] byArray = new byte[this.length - 10];
        System.arraycopy(handshakeState.data, handshakeState.offset + 6, byArray, 0, this.length - 10);
        handshakeState.next = I;
        handshakeState.offset += this.length - 4;
        Util.treatCert(byArray, sSLSocket, sessionState, connectionState, handshakeState);
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        try {
            X509Certificate x509Certificate = x509CertificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            handshakeState.serverCerts = new X509Certificate[1];
            handshakeState.serverCerts[0] = x509Certificate;
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

