/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel;

import com.mathworks.peermodel.ManagerInfo;
import com.mathworks.peermodel.PeerModelBuilder;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerSynchronizer;
import com.mathworks.peermodel.PeerSynchronizerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class PeerModelManagers {
    private static volatile PeerModelBuilder builderImpl = null;
    private static final Map<String, ManagerInfo> peerModelManagers = new HashMap<String, ManagerInfo>();

    public static synchronized PeerModelManager getInstance(String namespace) {
        return PeerModelManagers.getInstance(namespace, false);
    }

    public static synchronized PeerModelManager getInstance(String namespace, boolean isClient) {
        if (!PeerModelManagers.isNamespaceValid(namespace)) {
            throw new IllegalArgumentException("Namespaces must start with /, contain no spaces or *, and not end with /");
        }
        if (!peerModelManagers.containsKey(namespace)) {
            PeerModelManager peerModelManager = PeerModelManagers.getPeerModelBuilder().newPeerModelManagerInstance();
            PeerSynchronizer peerSynchronizer = PeerSynchronizerFactory.getSynchronizer(namespace, peerModelManager, isClient);
            peerModelManagers.put(namespace, new ManagerInfo(peerModelManager, peerSynchronizer));
        }
        return peerModelManagers.get(namespace).getManager();
    }

    public static synchronized PeerModelManager getClientInstance(String namespace) {
        return PeerModelManagers.getInstance(namespace, true);
    }

    public static synchronized PeerModelManager getServerInstance(String namespace) {
        return PeerModelManagers.getInstance(namespace, false);
    }

    public static synchronized void setPeerModelBuilder(PeerModelBuilder builder) {
        builderImpl = builder;
        if (builder == null) {
            for (String key : new HashSet<String>(peerModelManagers.keySet())) {
                PeerModelManagers.cleanup(key);
            }
            peerModelManagers.clear();
        }
    }

    private static synchronized PeerModelBuilder getPeerModelBuilder() {
        if (builderImpl == null) {
            throw new NotImplementedException("Missing peer model builder, please set it first");
        }
        return builderImpl;
    }

    public static synchronized void setSynchronizer(Class<? extends PeerSynchronizer> clazz) {
        PeerSynchronizerFactory.setSynchronizer(clazz);
    }

    public static synchronized void cleanup(String namespace) {
        if (peerModelManagers.containsKey(namespace)) {
            peerModelManagers.remove(namespace).destroy();
        }
    }

    private static boolean isNamespaceValid(String namespace) {
        return namespace.charAt(0) == '/' && namespace.charAt(namespace.length() - 1) != '/' && !namespace.contains(" ") && !namespace.contains("*");
    }

    private PeerModelManagers() {
    }
}

