/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.run;

import com.vladium.emma.AppLoggers;
import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppConstants;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTSettings;
import com.vladium.emma.run.ClassPathProcessorST;
import com.vladium.emma.run.InstrClassLoadHook;
import com.vladium.emma.run.InstrClassLoader;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.SoftValueMap;
import com.vladium.util.Strings;
import com.vladium.util.exception.Exceptions;
import com.vladium.util.exit.ExitHookManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RunProcessor
extends Processor
implements IAppErrorCodes {
    private final ClassLoader m_delegate;
    private String m_appClassName;
    private String[] m_appArgs;
    private File[] m_coveragePath;
    private boolean m_canonical;
    private boolean m_scanCoveragePath;
    private IInclExclFilter m_coverageFilter;
    private boolean m_dumpSessionData;
    private File m_sdataOutFile;
    private Boolean m_sdataOutMerge;
    private IReportGenerator[] m_reportGenerators;
    private File[] m_sourcePath;
    private static final boolean INIT_AT_LOAD_TIME = false;
    private static final boolean SET_CURRENT_CONTEXT_LOADER = false;
    private static final boolean USE_SOFT_CACHE = true;
    private static final int INIT_CACHE_CAPACITY = 2003;
    private static final int SOFT_CACHE_READ_CHK_FREQUENCY = 100;
    private static final int SOFT_CACHE_WRITE_CHK_FREQUENCY = 100;
    private static final String[] FORCED_DELEGATION_FILTER_SPECS;
    private static final Class[] MAIN_TYPE;
    private static final Class[] EXPECTED_FAILURES;
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$vladium$emma$EMMARuntimeException;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    public static RunProcessor create(ClassLoader delegate) {
        return new RunProcessor(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void run() {
        Logger current;
        IProperties toolProperties;
        Logger log;
        this.validateState();
        RTSettings.setStandaloneMode(false);
        RT.reset(new RTSettings.SetActions(1, 1, 2, 0));
        IProperties appProperties = RT.getAppProperties();
        if (appProperties == null) {
            appProperties = EMMAProperties.getAppProperties();
        }
        if ((log = AppLoggers.create(this.m_appName, toolProperties = IProperties.Factory.combine(this.m_propertyOverrides, appProperties), current = Logger.getLogger())).atTRACE1()) {
            log.trace1("run", "complete tool properties:");
            toolProperties.list(log.getWriter());
        }
        try {
            Logger.push(log);
            this.m_log = log;
            this._run(toolProperties);
            Object var5_4 = null;
            if (this.m_log == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.m_log == null) throw throwable;
            Logger.pop(this.m_log);
            this.m_log = null;
            throw throwable;
        }
        Logger.pop(this.m_log);
        this.m_log = null;
    }

    public synchronized void setCoveragePath(String[] path, boolean canonical) {
        this.m_coveragePath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, canonical);
        this.m_canonical = canonical;
    }

    public synchronized void setScanCoveragePath(boolean scan) {
        this.m_scanCoveragePath = scan;
    }

    public synchronized void setSourcePath(String[] path) {
        this.m_sourcePath = path == null ? null : Files.pathToFiles(path, true);
    }

    public final synchronized void setInclExclFilter(String[] specs) {
        this.m_coverageFilter = specs == null ? null : IInclExclFilter.Factory.create(specs);
    }

    public synchronized void setAppClass(String className, String[] args) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("null/empty input: className");
        }
        if (args != null) {
            String[] _args = (String[])args.clone();
            for (int a = 0; a < _args.length; ++a) {
                if (_args[a] != null) continue;
                throw new IllegalArgumentException("null input: args[" + a + "]");
            }
            this.m_appArgs = _args;
        } else {
            this.m_appArgs = IConstants.EMPTY_STRING_ARRAY;
        }
        this.m_appClassName = className;
    }

    public synchronized void setDumpSessionData(boolean dump) {
        this.m_dumpSessionData = dump;
    }

    public final synchronized void setSessionOutFile(String fileName) {
        if (fileName == null) {
            this.m_sdataOutFile = null;
        } else {
            File _file = new File(fileName);
            if (_file.exists() && !_file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + _file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = _file;
        }
    }

    public final synchronized void setSessionOutMerge(Boolean merge) {
        this.m_sdataOutMerge = merge;
    }

    public synchronized void setReportTypes(String[] types) {
        if (types == null) {
            throw new IllegalArgumentException("null input: types");
        }
        String[] reportTypes = Strings.removeDuplicates(types, true);
        if (reportTypes.length == 0) {
            throw new IllegalArgumentException("empty input: types");
        }
        IReportGenerator[] reportGenerators = new IReportGenerator[reportTypes.length];
        for (int t = 0; t < reportTypes.length; ++t) {
            reportGenerators[t] = AbstractReportGenerator.create(reportTypes[t]);
        }
        this.m_reportGenerators = reportGenerators;
    }

    protected void validateState() {
        super.validateState();
        if (this.m_appClassName == null || this.m_appClassName.length() == 0) {
            throw new IllegalStateException("application class name not set");
        }
        if (this.m_appArgs == null) {
            throw new IllegalStateException("application arguments not set");
        }
        if (this.m_coveragePath == null) {
            throw new IllegalStateException("coverage path not set");
        }
        if (this.m_reportGenerators == null || this.m_reportGenerators.length == 0) {
            throw new IllegalStateException("report types not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _run(IProperties toolProperties) {
        RuntimeException failure;
        AppRunnerExitHook runnerExitHook;
        ExitHookManager runnerExitHookManager;
        Logger log;
        block51: {
            log = this.m_log;
            boolean verbose = log.atVERBOSE();
            if (verbose) {
                String nonexistent;
                File f;
                int p;
                log.verbose("[EMMA v2.1, build 13730 (unsupported private build) (2012/05/30 15:21:47)]");
                log.verbose("coverage path:");
                log.verbose("{");
                for (p = 0; p < this.m_coveragePath.length; ++p) {
                    f = this.m_coveragePath[p];
                    nonexistent = f.exists() ? "" : "{nonexistent} ";
                    log.verbose("  " + nonexistent + f.getAbsolutePath());
                }
                log.verbose("}");
                if (this.m_sourcePath == null || this.m_sourcePath.length == 0) {
                    log.verbose("source path not set");
                } else {
                    log.verbose("source path:");
                    log.verbose("{");
                    for (p = 0; p < this.m_sourcePath.length; ++p) {
                        f = this.m_sourcePath[p];
                        nonexistent = f.exists() ? "" : "{nonexistent} ";
                        log.verbose("  " + nonexistent + f.getAbsolutePath());
                    }
                    log.verbose("}");
                }
            }
            File sdataOutFile = this.m_sdataOutFile;
            Boolean sdataOutMerge = this.m_sdataOutMerge;
            if (sdataOutFile == null) {
                sdataOutFile = new File(toolProperties.getProperty("session.out.file", "coverage.es"));
            }
            if (sdataOutMerge == null) {
                String _dataOutMerge = toolProperties.getProperty("session.out.merge", EMMAProperties.DEFAULT_SESSION_DATA_OUT_MERGE.toString());
                Boolean bl = sdataOutMerge = Property.toBoolean(_dataOutMerge) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (verbose && this.m_dumpSessionData) {
                log.verbose("session data output file: " + sdataOutFile.getAbsolutePath());
                log.verbose("session data output merge mode: " + sdataOutMerge);
            }
            IInclExclFilter forcedDelegationFilter = IInclExclFilter.Factory.create(toolProperties.getProperty("clsload.forced_delegation_filter"), COMMA_DELIMITERS, FORCED_DELEGATION_FILTER_SPECS);
            IInclExclFilter throughDelegationFilter = IInclExclFilter.Factory.create(toolProperties.getProperty("clsload.through_delegation_filter"), COMMA_DELIMITERS, null);
            runnerExitHookManager = null;
            try {
                runnerExitHookManager = ExitHookManager.getSingleton();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            runnerExitHook = null;
            failure = null;
            try {
                InstrClassLoader appLoader;
                SourcePathCache srcpathCache = null;
                if (this.m_sourcePath != null) {
                    srcpathCache = new SourcePathCache(this.m_sourcePath, true);
                }
                ICoverageData cdata = RT.getCoverageData();
                IMetaData mdata = DataFactory.newMetaData(CoverageOptionsFactory.create(toolProperties));
                runnerExitHook = new AppRunnerExitHook(log, this.m_dumpSessionData, sdataOutFile, sdataOutMerge, mdata, cdata, this.m_reportGenerators, srcpathCache, toolProperties);
                if (runnerExitHookManager != null) {
                    runnerExitHookManager.addExitHook(runnerExitHook);
                }
                SoftValueMap classIOCache = null;
                if (this.m_scanCoveragePath) {
                    classIOCache = new SoftValueMap(2003, 0.75f, 100, 100);
                    ClassPathProcessorST processor = new ClassPathProcessorST(this.m_coveragePath, this.m_canonical, mdata, this.m_coverageFilter, classIOCache);
                    processor.run();
                    if (log.atTRACE1()) {
                        log.trace1("run", "class cache size after cp scan: " + classIOCache.size());
                        log.trace1("run", "metadata size after cp scan: " + mdata.size());
                    }
                }
                srcpathCache = null;
                cdata = null;
                InstrClassLoadHook loadHook = new InstrClassLoadHook(this.m_coverageFilter, mdata);
                try {
                    appLoader = new InstrClassLoader(this.m_delegate, this.m_coveragePath, forcedDelegationFilter, throughDelegationFilter, loadHook, classIOCache);
                }
                catch (SecurityException se) {
                    throw new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
                }
                catch (MalformedURLException mue) {
                    throw new EMMARuntimeException(mue);
                }
                mdata = null;
                classIOCache = null;
                boolean contextLoaderSet = false;
                ThreadGroup appThreadGroup = null;
                try {
                    try {
                        Method appMain;
                        Class<?> appClass;
                        try {
                            appClass = Class.forName(this.m_appClassName, false, appLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new EMMARuntimeException("MAIN_CLASS_NOT_FOUND", new String[]{this.m_appClassName}, cnfe);
                        }
                        catch (ExceptionInInitializerError eiie) {
                            Throwable cause = eiie.getException();
                            throw new EMMARuntimeException("MAIN_CLASS_LOAD_FAILURE", new String[]{this.m_appClassName, cause.toString()}, cause);
                        }
                        catch (Throwable t) {
                            throw new EMMARuntimeException("MAIN_CLASS_NOT_FOUND", new String[]{this.m_appClassName}, t);
                        }
                        ClassLoader actualLoader = appClass.getClassLoader();
                        if (actualLoader != appLoader) {
                            String loaderName = actualLoader != null ? actualLoader.getClass().getName() : "<PRIMORDIAL>";
                            throw new EMMARuntimeException("MAIN_CLASS_BAD_DELEGATION", new String[]{"EMMA", this.m_appClassName, loaderName});
                        }
                        try {
                            appMain = appClass.getMethod("main", MAIN_TYPE);
                        }
                        catch (Throwable t) {
                            throw new EMMARuntimeException("MAIN_METHOD_NOT_FOUND", new String[]{this.m_appClassName}, t);
                        }
                        Invoker invoker = new Invoker(appMain, null, new Object[]{this.m_appArgs});
                        appThreadGroup = new ThreadGroup("EMMA thread group [" + this.m_appClassName + "]");
                        appThreadGroup.setDaemon(true);
                        Thread appThread = new Thread(appThreadGroup, invoker, "EMMA main() thread");
                        appThread.setContextClassLoader(appLoader);
                        appThread.start();
                        try {
                            appThread.join();
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        appThread = null;
                        RunProcessor.joinNonDeamonThreads(appThreadGroup);
                        if (log.atTRACE1() && appLoader instanceof InstrClassLoader) {
                            appLoader.debugDump(log.getWriter());
                        }
                        Throwable mainFailure = invoker.getFailure();
                        invoker = null;
                        if (mainFailure != null) {
                            if (mainFailure instanceof InvocationTargetException) {
                                Throwable cause = ((InvocationTargetException)mainFailure).getTargetException();
                                throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, cause.toString()}, cause);
                            }
                            if (mainFailure instanceof ExceptionInInitializerError) {
                                Throwable cause = ((ExceptionInInitializerError)mainFailure).getException();
                                throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, cause.toString()}, cause);
                            }
                            if (!(mainFailure instanceof IllegalAccessException || mainFailure instanceof IllegalArgumentException || mainFailure instanceof NullPointerException)) {
                                throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, mainFailure.toString()}, mainFailure);
                            }
                            throw new EMMARuntimeException("MAIN_METHOD_NOT_FOUND", new String[]{this.m_appClassName}, mainFailure);
                        }
                        Object var26_39 = null;
                        if (appThreadGroup == null) break block51;
                    }
                    catch (SecurityException se) {
                        throw new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
                    }
                    if (appThreadGroup.isDestroyed()) break block51;
                }
                catch (Throwable throwable) {
                    Object var26_40 = null;
                    if (appThreadGroup == null) throw throwable;
                    if (appThreadGroup.isDestroyed()) throw throwable;
                    try {
                        appThreadGroup.destroy();
                        appThreadGroup = null;
                        throw throwable;
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable ignore) {}
                appThreadGroup.destroy();
                appThreadGroup = null;
            }
            catch (RuntimeException re) {
                failure = re;
            }
            finally {
                RT.reset(new RTSettings.SetActions(2, 2, 2, 0));
            }
        }
        runnerExitHook.run();
        if (runnerExitHookManager != null) {
            runnerExitHookManager.removeExitHook(runnerExitHook);
            runnerExitHookManager = null;
        }
        Throwable exitHookDataDumpFailure = runnerExitHook.getDataDumpFailure();
        List exitHookReportFailures = runnerExitHook.getReportFailures();
        runnerExitHook = null;
        if (failure != null) {
            throw RunProcessor.wrapFailure(failure);
        }
        if (exitHookDataDumpFailure == null) {
            if (exitHookReportFailures == null) return;
        }
        if (exitHookDataDumpFailure != null) {
            log.log(0, "exception while persisting raw session data:", exitHookDataDumpFailure);
        }
        Throwable firstReportFailure = null;
        if (exitHookReportFailures != null) {
            Iterator i = exitHookReportFailures.iterator();
            while (i.hasNext()) {
                Throwable reportFailure = (Throwable)i.next();
                if (firstReportFailure == null) {
                    firstReportFailure = reportFailure;
                }
                log.log(0, "exception while creating a report:", reportFailure);
            }
        }
        if (exitHookDataDumpFailure != null) {
            throw RunProcessor.wrapFailure(exitHookDataDumpFailure);
        }
        if (firstReportFailure == null) return;
        throw RunProcessor.wrapFailure(firstReportFailure);
    }

    private RunProcessor(ClassLoader delegate) {
        this.m_delegate = delegate;
        this.m_coveragePath = IConstants.EMPTY_FILE_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void joinNonDeamonThreads(ThreadGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("null input: group");
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        block5: while (true) {
            int aliveCount;
            Thread[] aliveThreads;
            threads.clear();
            ThreadGroup threadGroup = group;
            synchronized (threadGroup) {
                aliveThreads = new Thread[group.activeCount() << 1];
                aliveCount = group.enumerate(aliveThreads, true);
            }
            for (int t = 0; t < aliveCount; ++t) {
                if (aliveThreads[t].isDaemon()) continue;
                threads.add(aliveThreads[t]);
            }
            aliveThreads = null;
            if (threads.isEmpty()) break;
            Iterator i = threads.iterator();
            while (true) {
                if (!i.hasNext()) continue block5;
                try {
                    ((Thread)i.next()).join();
                }
                catch (InterruptedException ignore) {}
            }
            break;
        }
    }

    private static RuntimeException wrapFailure(Throwable t) {
        if (Exceptions.unexpectedFailure(t, EXPECTED_FAILURES)) {
            return new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{t.toString(), "http://sourceforge.net/projects/emma"}, t);
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new EMMARuntimeException(t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAIN_TYPE = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = RunProcessor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        PATH_DELIMITERS = ",".concat(File.pathSeparator);
        EXPECTED_FAILURES = new Class[]{class$com$vladium$emma$EMMARuntimeException == null ? (class$com$vladium$emma$EMMARuntimeException = RunProcessor.class$("com.vladium.emma.EMMARuntimeException")) : class$com$vladium$emma$EMMARuntimeException, class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = RunProcessor.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = RunProcessor.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException};
        FORCED_DELEGATION_FILTER_SPECS = new String[]{"+" + IAppConstants.APP_PACKAGE + ".*"};
    }

    private static final class AppRunnerExitHook
    implements Runnable {
        private final Logger m_log;
        private final boolean m_dumpRawData;
        private final File m_sdataOutFile;
        private final boolean m_sdataOutMerge;
        private IReportGenerator[] m_generators;
        private IMetaData m_mdata;
        private ICoverageData m_cdata;
        private SourcePathCache m_cache;
        private IProperties m_properties;
        private boolean m_done;
        private Throwable m_dataDumpFailure;
        private List m_reportFailures;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public synchronized void run() {
            block18: {
                try {
                    if (this.m_done) break block18;
                    IMetaData mdataSnashot = this.m_mdata.shallowCopy();
                    this.m_mdata = null;
                    ICoverageData cdataSnapshot = this.m_cdata.shallowCopy();
                    this.m_cdata = null;
                    if (mdataSnashot.isEmpty()) {
                        this.m_log.warning("no metadata collected at runtime [no reports generated]");
                        Object var13_3 = null;
                        this.m_generators = null;
                        this.m_mdata = null;
                        this.m_cdata = null;
                        this.m_properties = null;
                        this.m_cache = null;
                        this.m_done = true;
                        return;
                    }
                    if (cdataSnapshot.isEmpty()) {
                        this.m_log.warning("no coverage data collected at runtime [all reports will be empty]");
                    }
                    SessionData sdata = new SessionData(mdataSnashot, cdataSnapshot);
                    if (this.m_dumpRawData && this.m_sdataOutFile != null) {
                        try {
                            boolean info = this.m_log.atINFO();
                            long start = info ? System.currentTimeMillis() : 0L;
                            DataFactory.persist(sdata, this.m_sdataOutFile, this.m_sdataOutMerge);
                            if (info) {
                                long end = System.currentTimeMillis();
                                this.m_log.info("raw session data " + (this.m_sdataOutMerge ? "merged into" : "written to") + " [" + this.m_sdataOutFile.getAbsolutePath() + "] {in " + (end - start) + " ms}");
                            }
                        }
                        catch (Throwable t) {
                            this.m_dataDumpFailure = t;
                        }
                    }
                    for (int g = 0; g < this.m_generators.length; ++g) {
                        IReportGenerator generator = this.m_generators[g];
                        if (generator == null) continue;
                        generator.process(mdataSnashot, cdataSnapshot, this.m_cache, this.m_properties);
                        Object var10_13 = null;
                        try {
                            generator.cleanup();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        this.m_generators[g] = null;
                        {
                            continue;
                            catch (Throwable t) {
                                if (this.m_reportFailures == null) {
                                    this.m_reportFailures = new ArrayList();
                                }
                                this.m_reportFailures.add(t);
                                var10_13 = null;
                                try {
                                    generator.cleanup();
                                }
                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                                this.m_generators[g] = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            var10_13 = null;
                            try {
                                generator.cleanup();
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            this.m_generators[g] = null;
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_5 = null;
                    this.m_generators = null;
                    this.m_mdata = null;
                    this.m_cdata = null;
                    this.m_properties = null;
                    this.m_cache = null;
                    this.m_done = true;
                    throw throwable;
                }
            }
            Object var13_4 = null;
            this.m_generators = null;
            this.m_mdata = null;
            this.m_cdata = null;
            this.m_properties = null;
            this.m_cache = null;
            this.m_done = true;
        }

        AppRunnerExitHook(Logger log, boolean dumpRawData, File sdataOutFile, boolean sdataOutMerge, IMetaData mdata, ICoverageData cdata, IReportGenerator[] generators, SourcePathCache cache, IProperties properties) {
            if (log == null) {
                throw new IllegalArgumentException("null input: log");
            }
            if (generators == null || generators.length == 0) {
                throw new IllegalArgumentException("null/empty input: generators");
            }
            if (mdata == null) {
                throw new IllegalArgumentException("null input: mdata");
            }
            if (cdata == null) {
                throw new IllegalArgumentException("null input: cdata");
            }
            if (properties == null) {
                throw new IllegalArgumentException("null input: properties");
            }
            this.m_log = log;
            this.m_dumpRawData = dumpRawData;
            this.m_sdataOutFile = sdataOutFile;
            this.m_sdataOutMerge = sdataOutMerge;
            this.m_generators = (IReportGenerator[])generators.clone();
            this.m_mdata = mdata;
            this.m_cdata = cdata;
            this.m_cache = cache;
            this.m_properties = properties;
        }

        synchronized Throwable getDataDumpFailure() {
            return this.m_dataDumpFailure;
        }

        synchronized List getReportFailures() {
            return this.m_reportFailures;
        }
    }

    private static final class Invoker
    implements Runnable {
        private final Method m_method;
        private final Object m_target;
        private final Object[] m_args;
        private Throwable m_failure;

        Invoker(Method method, Object target, Object[] args) {
            if (method == null) {
                throw new IllegalArgumentException("null input: method");
            }
            if (args == null) {
                throw new IllegalArgumentException("null input: args");
            }
            this.m_method = method;
            this.m_target = target;
            this.m_args = args;
        }

        public void run() {
            try {
                this.m_method.invoke(this.m_target, this.m_args);
            }
            catch (Throwable t) {
                this.m_failure = t;
            }
        }

        Throwable getFailure() {
            return this.m_failure;
        }
    }
}

