/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.dialogs;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.shared.computils.widgets.HTMLMessagePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HTMLMessageDialog<V>
extends MJDialog {
    private static final Dimension MINIMUM_WINDOW_SIZE = new Dimension(200, 120);
    private static final int MINIMUM_BUTTON_SIZE = 75;
    private final HTMLMessagePane fTextComponent;
    private final JScrollPane fScrollPane;
    private final List<Component> fButtons;
    private final Component fParentComponent;
    private V fResult;

    public HTMLMessageDialog(String string, String string2, Type type, Map<String, V> map, V v, Component component) {
        this(string, string2, type.getIcon(), map, v, component);
    }

    public HTMLMessageDialog(String string, String string2, Icon icon, Map<String, V> map, V v, Component component) {
        super(JOptionPane.getFrameForComponent(component), string, true);
        this.fResult = v;
        this.fParentComponent = component;
        this.fTextComponent = HTMLMessageDialog.createMessagePane(string2);
        this.fScrollPane = HTMLMessageDialog.createScrollPane((JComponent)((Object)this.fTextComponent));
        final LinkedHashMap<String, V> linkedHashMap = new LinkedHashMap<String, V>(map);
        this.fButtons = new ArrayList<Component>();
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            final String string4 = string3 = (String)iterator.next();
            MJButton mJButton = new MJButton(string4);
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HTMLMessageDialog.this.fResult = linkedHashMap.get(string4);
                    HTMLMessageDialog.this.hide();
                }
            });
            this.fButtons.add((Component)mJButton);
        }
        this.layoutUI(icon);
        this.setMinimumSize(MINIMUM_WINDOW_SIZE);
        this.setFocusTraversalPolicy(new MessageDialogFocusTraversalPolicy());
    }

    public static <V> V showDialog(String string, String string2, Type type, Map<String, V> map, V v, Component component) {
        return HTMLMessageDialog.showDialog(string, string2, type.getIcon(), map, v, component);
    }

    public static <V> V showDialog(final String string, final String string2, final Icon icon, final Map<String, V> map, final V v, final Component component) {
        final AtomicReference<V> atomicReference = new AtomicReference<V>(v);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HTMLMessageDialog<Object> hTMLMessageDialog = new HTMLMessageDialog<Object>(string, string2, icon, map, v, component);
                    hTMLMessageDialog.show();
                    atomicReference.set(hTMLMessageDialog.getResult());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        return atomicReference.get();
    }

    public void setWrapping(boolean bl) {
        this.fTextComponent.setWrapping(bl);
    }

    public V getResult() {
        return this.fResult;
    }

    public void show() {
        this.pack();
        this.setDefaultSize();
        this.setLocationRelativeTo(this.fParentComponent);
        super.show();
        this.dispose();
    }

    private void setDefaultSize() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = graphicsEnvironment.getDefaultScreenDevice().getDisplayMode();
        int n = this.getPreferredSize().width;
        int n2 = 2 * displayMode.getWidth() / 3;
        int n3 = Math.min(n, n2);
        this.setSize(n3, displayMode.getHeight());
        this.validate();
        this.fScrollPane.setSize(-1, this.fScrollPane.getPreferredSize().height);
        int n4 = this.getPreferredSize().height;
        JScrollBar jScrollBar = this.fScrollPane.getHorizontalScrollBar();
        if (jScrollBar.isVisible()) {
            n4 += jScrollBar.getHeight();
        }
        int n5 = 2 * displayMode.getHeight() / 3;
        int n6 = Math.min(n4, n5);
        this.setSize(n3, n6);
    }

    private void layoutUI(Icon icon) {
        MJLabel mJLabel = new MJLabel(icon);
        mJLabel.setName("messageDialog.iconLabel");
        Container container = this.getContentPane();
        GroupLayout groupLayout = new GroupLayout(container);
        container.setLayout(groupLayout);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        for (Component component : this.fButtons) {
            sequentialGroup.addComponent(component, 75, -2, -2);
            parallelGroup.addComponent(component, -2, -2, -2);
        }
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent((Component)mJLabel, GroupLayout.Alignment.LEADING).addComponent(this.fScrollPane)).addGroup(parallelGroup));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent((Component)mJLabel, -2, -2, -2).addComponent(this.fScrollPane)).addGroup(sequentialGroup)));
    }

    private static HTMLMessagePane createMessagePane(String string) {
        HTMLMessagePane hTMLMessagePane = new HTMLMessagePane();
        hTMLMessagePane.setWrapping(false);
        hTMLMessagePane.setText(string);
        hTMLMessagePane.setName("messageDialog.editorPane");
        return hTMLMessagePane;
    }

    private static JScrollPane createScrollPane(JComponent jComponent) {
        MJScrollPane mJScrollPane = new MJScrollPane((Component)jComponent);
        mJScrollPane.setOpaque(false);
        mJScrollPane.getViewport().setOpaque(false);
        mJScrollPane.setBorder(null);
        mJScrollPane.setName("messageDialog.scrollPane");
        return mJScrollPane;
    }

    public static enum Type {
        INFO(DialogIcon.INFO_32x32.getIcon()),
        QUESTION(DialogIcon.QUESTION_32x32.getIcon()),
        WARNING(DialogIcon.WARNING_32x32.getIcon()),
        ERROR(DialogIcon.ERROR_32x32.getIcon());

        private Icon fIcon;

        private Type(Icon icon) {
            this.fIcon = icon;
        }

        public Icon getIcon() {
            return this.fIcon;
        }
    }

    private class MessageDialogFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MessageDialogFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = HTMLMessageDialog.this.fButtons.indexOf(component);
            int n2 = n + 1;
            if (n2 >= HTMLMessageDialog.this.fButtons.size()) {
                n2 = 0;
            }
            return (Component)HTMLMessageDialog.this.fButtons.get(n2);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = HTMLMessageDialog.this.fButtons.indexOf(component);
            int n2 = n - 1;
            if (n2 < 0) {
                n2 = HTMLMessageDialog.this.fButtons.size() - 1;
            }
            return (Component)HTMLMessageDialog.this.fButtons.get(n2);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return (Component)HTMLMessageDialog.this.fButtons.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return (Component)HTMLMessageDialog.this.fButtons.get(HTMLMessageDialog.this.fButtons.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return (Component)HTMLMessageDialog.this.fButtons.get(0);
        }
    }
}

