/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FileTree {
    private final Map<File, Collection<File>> fChildFileMap = new HashMap<File, Collection<File>>();
    private final File fRootLimit;

    public FileTree(Iterable<File> iterable, File file) {
        this.fRootLimit = file;
        for (File file2 : iterable) {
            this.addFile(file2);
        }
    }

    public Collection<File> getFolders() {
        return this.fChildFileMap.keySet();
    }

    public Collection<File> getChildren(File file) {
        Collection<File> collection = this.fChildFileMap.get(file);
        if (collection == null) {
            collection = new ArrayList<File>();
        }
        return collection;
    }

    private void addFile(File file) {
        File file2 = this.getParent(file);
        if (file2 == null) {
            return;
        }
        Collection<File> collection = this.fChildFileMap.get(file2);
        if (collection == null) {
            collection = new HashSet<File>();
        }
        collection.add(file);
        this.fChildFileMap.put(file2, collection);
        this.addFile(file2);
    }

    private File getParent(File file) {
        if (file.equals(this.fRootLimit)) {
            return null;
        }
        return file.getParentFile();
    }
}

