/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ui.UserDefinedConflictExtractionParameters;
import com.mathworks.toolbox.shared.computils.file.resources.FileResources;
import com.mathworks.toolbox.shared.computils.file.widgets.FileSelector;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

class TargetFilesWidget
implements ComponentBuilder {
    private final JPanel fRoot;
    private static final int INDENT = 25;
    private final FileSelector fMineFileSelector = new MineFileSelector();
    private final FileSelector fTheirsFileSelector = new TheirsFileSelector();
    private final UserDefinedConflictExtractionParameters fUserDefinedConflictExtractionParameters;

    TargetFilesWidget(UserDefinedConflictExtractionParameters userDefinedConflictExtractionParameters) {
        this.fRoot = new MJPanel();
        this.fUserDefinedConflictExtractionParameters = userDefinedConflictExtractionParameters;
        this.buildUI();
        this.updateUI();
        this.handleConfigUpdates();
        this.handleUserInteraction();
    }

    private void buildUI() {
        GroupLayout groupLayout = new GroupLayout(this.fRoot);
        this.fRoot.setLayout(groupLayout);
        MJLabel mJLabel = new MJLabel(FileResources.getString("ui.extractConflictMarkers.config.mineLocation", new String[0]));
        MJLabel mJLabel2 = new MJLabel(FileResources.getString("ui.extractConflictMarkers.config.theirsLocation", new String[0]));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent((Component)mJLabel).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent((Component)((Object)this.fMineFileSelector))).addComponent((Component)mJLabel2).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent((Component)((Object)this.fTheirsFileSelector))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)mJLabel, -2, -2, -2).addComponent((Component)((Object)this.fMineFileSelector), -2, -2, -2).addComponent((Component)mJLabel2, -2, -2, -2).addComponent((Component)((Object)this.fTheirsFileSelector), -2, -2, -2));
    }

    private void updateUI() {
        this.fMineFileSelector.setFile(this.fUserDefinedConflictExtractionParameters.getMineFile());
        this.fMineFileSelector.setEnabled(!this.fUserDefinedConflictExtractionParameters.isMineFileFixed());
        this.fTheirsFileSelector.setFile(this.fUserDefinedConflictExtractionParameters.getTheirsFile());
        this.fTheirsFileSelector.setEnabled(!this.fUserDefinedConflictExtractionParameters.isTheirsFileFixed());
    }

    private void handleUserInteraction() {
        this.fMineFileSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetFilesWidget.this.fUserDefinedConflictExtractionParameters.setMineFile(TargetFilesWidget.this.fMineFileSelector.getFile());
            }
        });
        this.fTheirsFileSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetFilesWidget.this.fUserDefinedConflictExtractionParameters.setTheirsFile(TargetFilesWidget.this.fTheirsFileSelector.getFile());
            }
        });
    }

    private void handleConfigUpdates() {
        this.fUserDefinedConflictExtractionParameters.add(new UserDefinedConflictExtractionParameters.Listener(){

            @Override
            public void configChange() {
                TargetFilesWidget.this.updateUI();
            }
        });
    }

    public JComponent getComponent() {
        return this.fRoot;
    }

    private static final class TheirsFileSelector
    extends FileSelector {
        private TheirsFileSelector() {
            this.setBrowseButtonName("theirsFileSelectorBrowse");
            this.setTextFieldName("theirsFileSelectorText");
        }
    }

    private static final class MineFileSelector
    extends FileSelector {
        private MineFileSelector() {
            this.setBrowseButtonName("mineFileSelectorBrowse");
            this.setTextFieldName("mineFileSelectorText");
        }
    }
}

