/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.reflection;

import com.mathworks.toolbox.shared.computils.reflection.Caller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DepthAwareCaller
implements Caller {
    private final int fStackDepth;

    public DepthAwareCaller(int n) {
        this.fStackDepth = n;
    }

    @Override
    public Object callOnDelegate(Object object, Object ... objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = this.getMethod(object, objectArray);
        return method.invoke(object, objectArray);
    }

    @Override
    public void runOnDelegate(Object object, Object ... objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = this.getMethod(object, objectArray);
        method.invoke(object, objectArray);
    }

    private String getCallingMethodName(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2 + n + this.fStackDepth];
        return stackTraceElement.getMethodName();
    }

    private Method getMethod(Object object, Object ... objectArray) throws NoSuchMethodException {
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        for (Object object2 : objectArray) {
            classArray[n] = DepthAwareCaller.deriveFrom(object2);
            ++n;
        }
        return this.getCallingMethod(2, object, classArray);
    }

    private Method getCallingMethod(int n, Object object, Class<?> ... classArray) throws NoSuchMethodException {
        String string = this.getCallingMethodName(n + 1);
        return DepthAwareCaller.getSpecifiedMethod(string, object, classArray);
    }

    private static Method getSpecifiedMethod(String string, Object object, Class<?> ... classArray) throws NoSuchMethodException {
        for (Method method : object.getClass().getMethods()) {
            if (!DepthAwareCaller.matchMethod(method, string, classArray)) continue;
            return method;
        }
        throw new NoSuchMethodException(string);
    }

    private static boolean matchMethod(Method method, String string, Class<?> ... classArray) {
        int n;
        if (!method.getName().equals(string)) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        int n2 = classArray == null ? 0 : classArray.length;
        int n3 = n = classArray2 == null ? 0 : classArray2.length;
        if (n2 != n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = classArray2[i];
            Class<?> clazz2 = classArray[i];
            if (clazz.isAssignableFrom(clazz2)) continue;
            return false;
        }
        return true;
    }

    private static Class<?> deriveFrom(Object object) {
        Class<?> clazz = object.getClass();
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return clazz;
    }
}

