/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;

public class ThreadUtils {
    private ThreadUtils() {
    }

    public static String generateStackTrace(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder(0);
        boolean bl = false;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!bl && !stackTraceElement.toString().startsWith("com.mathworks.toolbox.shared.computils.threads.WrappingExecutorService.")) continue;
            bl = true;
            stringBuilder.append("    ");
            stringBuilder.append(stackTraceElement);
            stringBuilder.append("\\n");
        }
        return stringBuilder.toString();
    }

    public static String getEDTThreadNamePrefix() {
        return "AWT-EventQueue-";
    }

    public static <T> T callOnEDT(Callable<T> callable) throws InterruptedException, ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        if (SwingUtilities.isEventDispatchThread()) {
            futureTask.run();
        } else {
            SwingUtilities.invokeLater(futureTask);
        }
        return (T)futureTask.get();
    }
}

