/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.threads;

import com.mathworks.toolbox.shared.computils.threads.CountingThreadFactory;
import com.mathworks.toolbox.shared.computils.threads.ExecutionWrapperFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class WrappingExecutorService
implements ExecutorService {
    private final ExecutorService fExecutorService;
    private final AtomicReference<ExecutionWrapperFactory> fExecutionWrapperFactory = new AtomicReference();

    public WrappingExecutorService(String string) {
        this(Executors.newCachedThreadPool(new CountingThreadFactory(string)));
    }

    public WrappingExecutorService(ExecutorService executorService) {
        this.fExecutorService = executorService;
    }

    public void set(ExecutionWrapperFactory executionWrapperFactory) {
        this.fExecutionWrapperFactory.set(executionWrapperFactory);
    }

    @Override
    public void execute(Runnable runnable) {
        this.fExecutorService.execute(new WrappedRunnable(runnable));
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.fExecutorService.submit(new WrappedCallable<T>(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.fExecutorService.submit(new WrappedRunnable(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.fExecutorService.submit(new WrappedRunnable(runnable));
    }

    @Override
    public void shutdown() {
        this.fExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.fExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.fExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.fExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fExecutorService.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> fDelegateCallable;

        WrappedCallable(Callable<T> callable) {
            ExecutionWrapperFactory executionWrapperFactory = (ExecutionWrapperFactory)WrappingExecutorService.this.fExecutionWrapperFactory.get();
            this.fDelegateCallable = executionWrapperFactory == null ? callable : executionWrapperFactory.wrap(callable, Thread.currentThread());
        }

        @Override
        public T call() throws Exception {
            return this.fDelegateCallable.call();
        }
    }

    private class WrappedRunnable
    implements Runnable {
        private final Runnable fDelegateRunnable;

        WrappedRunnable(Runnable runnable) {
            ExecutionWrapperFactory executionWrapperFactory = (ExecutionWrapperFactory)WrappingExecutorService.this.fExecutionWrapperFactory.get();
            this.fDelegateRunnable = executionWrapperFactory == null ? runnable : executionWrapperFactory.wrap(runnable, Thread.currentThread());
        }

        @Override
        public void run() {
            this.fDelegateRunnable.run();
        }
    }
}

