/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.xml.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter,
AutoCloseable {
    private static final String INDENTATION = "    ";
    private static final String NEW_LINE = "\n";
    private final XMLStreamWriter fWriter;
    private int fCurrentIndent = 0;
    private boolean fRequireNewLine = true;

    public IndentingXMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        this.fWriter = xMLStreamWriter;
    }

    private void writeIndent() throws XMLStreamException {
        this.writeCharacters(NEW_LINE);
        for (int i = 0; i < this.fCurrentIndent; ++i) {
            this.writeCharacters(INDENTATION);
        }
    }

    private void writeStartElementIndent() throws XMLStreamException {
        this.writeIndent();
        ++this.fCurrentIndent;
        this.fRequireNewLine = false;
    }

    private void writeEndElementIndent() throws XMLStreamException {
        --this.fCurrentIndent;
        if (this.fRequireNewLine) {
            this.writeIndent();
        }
        this.fRequireNewLine = true;
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElementIndent();
        this.fWriter.writeStartElement(string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartElementIndent();
        this.fWriter.writeStartElement(string, string2);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElementIndent();
        this.fWriter.writeStartElement(string, string2, string3);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writeEndElementIndent();
        this.fWriter.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.fWriter.writeEmptyElement(string);
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.fWriter.writeEmptyElement(string, string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.fWriter.writeEmptyElement(string, string2, string3);
    }

    @Override
    public void close() throws XMLStreamException {
        this.fWriter.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.fWriter.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.fWriter.getPrefix(string);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fWriter.getProperty(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.fWriter.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fWriter.setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.fWriter.setPrefix(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.fWriter.writeAttribute(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.fWriter.writeAttribute(string, string2, string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.fWriter.writeAttribute(string, string2, string3, string4);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.fWriter.writeCData(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.fWriter.writeCharacters(cArray, n, n2);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.fWriter.writeCharacters(string);
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.fWriter.writeComment(string);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.fWriter.writeDefaultNamespace(string);
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.fWriter.writeDTD(string);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.fWriter.writeEndDocument();
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.fWriter.writeEntityRef(string);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.fWriter.writeNamespace(string, string2);
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.fWriter.writeProcessingInstruction(string);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.fWriter.writeProcessingInstruction(string, string2);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.fWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.fWriter.writeStartDocument(string, string2);
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.fWriter.writeStartDocument(string);
    }
}

