/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.timer;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class CallbackEditor
extends MWPropertyEditorSupport
implements Runnable,
KeyListener,
EnhancedPropertyEditor,
ApplyPropertyEditor {
    private static String LINESEP = new Character('\r').toString() + new Character('\n').toString();
    private Image icon;
    private MJTextField textfield = null;
    private JPanel outerPanel = null;
    private int action = 0;
    private boolean setValue = false;

    public Component getCustomEditor() {
        Object object;
        if (this.outerPanel == null) {
            this.outerPanel = new JPanel(new BorderLayout(5, 5));
            this.outerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            object = new JPanel(new BorderLayout());
            this.textfield = new MJTextField();
            this.textfield.setName("TimerCallbackValue");
            this.textfield.addKeyListener((KeyListener)this);
            this.textfield.requestFocus();
            ((Container)object).add((Component)new JLabel("Enter the callback value:"), "North");
            ((Container)object).add((Component)this.textfield, "Center");
            this.outerPanel.add((Component)this.createInstructions(), "Center");
            this.outerPanel.add((Component)object, "South");
        }
        this.setValue = false;
        this.outerPanel.setPreferredSize(new Dimension(350, 240));
        object = (MLArrayRef)this.getValue();
        this.action = object.getType();
        Matlab.whenMatlabReady((Runnable)this);
        return this.outerPanel;
    }

    private JPanel createInstructions() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Configuring Callbacks"), BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        JTextArea jTextArea = new JTextArea();
        jPanel.add((Component)jTextArea, "Center");
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setText("A callback can be configured to a:" + LINESEP + LINESEP + "1. string, e.g. plot(1:10) " + LINESEP + "2. cell array, e.g {'myfun', 1, 2}" + LINESEP + "3. function handle, e.g @instrcallback " + LINESEP + LINESEP + "When the callback is set to a cell array or a function handle, the object " + "that caused the event to occur and an event structure are passed to the " + "evaluated function.");
        jTextArea.setFont(new Font("Dialog", 0, 12));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        return jPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean supportsInPlaceEditing() {
        return false;
    }

    public void apply() {
        if (this.setValue) {
            this.action = 0;
            Matlab.whenMatlabReady((Runnable)this);
        }
    }

    @Override
    public void run() {
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        switch (this.action) {
            case 4: {
                this.textfield.setText((String)mLArrayRef.getData());
                return;
            }
            case 1: {
                this.textfield.setText(this.convertCell2String(mLArrayRef));
                return;
            }
            case 16: {
                this.textfield.setText(this.convertFunctionHandle2String(mLArrayRef));
                return;
            }
        }
        Object object = this.textfield.getText();
        Object[] objectArray = new Object[]{object};
        String string = (String)objectArray[0];
        if (string.startsWith("{") || string.startsWith("@")) {
            try {
                object = Matlab.mtFeval((String)"eval", (Object[])objectArray, (int)1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] objectArray2 = new Object[]{new Integer(45), object};
        MLArrayRef mLArrayRef2 = null;
        try {
            mLArrayRef2 = (MLArrayRef)Matlab.mtFeval((String)"system_dependent", (Object[])objectArray2, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValue(mLArrayRef2);
    }

    private boolean okToConvertCell2String(MLArrayRef mLArrayRef) {
        for (int i = 0; i < mLArrayRef.getN(); ++i) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellAt(i);
            if (mLArrayRef2.getType() == 6 || mLArrayRef2.getType() == 4 || mLArrayRef2.getType() == 16) continue;
            return false;
        }
        return true;
    }

    private String convertCell2String(MLArrayRef mLArrayRef) {
        if (!this.okToConvertCell2String(mLArrayRef)) {
            return mLArrayRef.toString();
        }
        String string = "{";
        block5: for (int i = 0; i < mLArrayRef.getN(); ++i) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellAt(i);
            switch (mLArrayRef2.getType()) {
                case 6: {
                    double[] dArray = (double[])mLArrayRef2.getData();
                    if ((double)((int)dArray[0]) != dArray[0]) {
                        return mLArrayRef.toString();
                    }
                    string = string + this.double2String(dArray[0]) + ",";
                    continue block5;
                }
                case 4: {
                    string = string + "'" + (String)mLArrayRef2.getData() + "',";
                    continue block5;
                }
                case 16: {
                    string = string + this.convertFunctionHandle2String(mLArrayRef2) + ",";
                }
            }
        }
        string = string.substring(0, string.length() - 1);
        string = string + "}";
        return string;
    }

    private String convertFunctionHandle2String(MLArrayRef mLArrayRef) {
        try {
            Object[] objectArray = new Object[]{mLArrayRef};
            String string = (String)Matlab.mtFeval((String)"func2str", (Object[])objectArray, (int)1);
            if (string.startsWith("@")) {
                return string;
            }
            return "@" + string;
        }
        catch (Exception exception) {
            return mLArrayRef.toString();
        }
    }

    private String double2String(double d) {
        String string = Double.toString(d);
        int n = string.indexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    public void setFrame(Frame frame) {
    }

    public Image getIcon() {
        if (this.icon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            this.icon = resLoader.loadImage("resources/CallbackIcon.gif");
        }
        return this.icon;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.setValue = true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

