/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.clients.cloudcenter;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.clients.cloudcenter.AddSnapshotRequest;
import com.mathworks.webservices.clients.cloudcenter.AddSnapshotResponse;
import com.mathworks.webservices.clients.cloudcenter.CloudCenter;
import com.mathworks.webservices.clients.cloudcenter.CloudCenterErrorCode;
import com.mathworks.webservices.clients.cloudcenter.ClusterDetailsRequest;
import com.mathworks.webservices.clients.cloudcenter.ClusterDetailsResponse;
import com.mathworks.webservices.clients.cloudcenter.ClusterInfoResponse;
import com.mathworks.webservices.clients.cloudcenter.CreateClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.CreateClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.DeleteClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.DeleteClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.DiscoverClustersRequest;
import com.mathworks.webservices.clients.cloudcenter.DiscoverClustersResponse;
import com.mathworks.webservices.clients.cloudcenter.GetMWHostedClusterInfoRequest;
import com.mathworks.webservices.clients.cloudcenter.HeartbeatClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.HeartbeatFailedException;
import com.mathworks.webservices.clients.cloudcenter.StartClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.StartClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.StopClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.StopClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.TerminationPolicy;
import com.mathworks.webservices.clients.cloudcenter.UpdateClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.UpdateMWHostedClusterRequest;

public class CloudCenterClient
extends MathWorksWebServiceClient
implements CloudCenter {
    private static final String SERIALIZE_PACKAGE = "com.mathworks.webservices.clients.cloudcenter";

    CloudCenterClient() {
        super(new ClientConfiguration());
    }

    public CloudCenterClient(String endpoint) {
        this(endpoint, new MathWorksHttpClient());
    }

    public CloudCenterClient(String endpoint, ClientConfiguration config) {
        this(endpoint, new MathWorksHttpClient(config));
    }

    public CloudCenterClient(String endpoint, MathWorksHttpClient client) {
        super(client, (ResponseHandler)new JaxbResponseHandler(SERIALIZE_PACKAGE));
        this.setEndpoint(endpoint);
    }

    protected CloudCenterClient(MathWorksHttpClient httpClient) {
        super(httpClient, (ResponseHandler)new JaxbResponseHandler(SERIALIZE_PACKAGE));
    }

    @Override
    public DiscoverClustersResponse discoverMyCloudClusters(DiscoverClustersRequest request) {
        request.validate();
        String pathToService = "/cluster/list";
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, this.endpoint, "/cluster/list");
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        DiscoverClustersResponse response = null;
        try {
            response = (DiscoverClustersResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public ClusterDetailsResponse getClusterDetails(ClusterDetailsRequest request) {
        request.validate();
        String pathToService = "/cluster/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        ClusterDetailsResponse response = null;
        try {
            response = (ClusterDetailsResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public StopClusterResponse stopCluster(StopClusterRequest request) {
        request.validate();
        String pathToService = "/cluster/stop/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        StopClusterResponse response = null;
        try {
            response = (StopClusterResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public StartClusterResponse startCluster(StartClusterRequest request) {
        request.validate();
        String pathToService = "/cluster/start/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        if (request.getEntitlementId() != null) {
            httpRequest.addParameter("entitlementId", request.getEntitlementId());
        }
        StartClusterResponse response = null;
        try {
            response = (StartClusterResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest request) {
        request.validate();
        String pathToService = "/cluster/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.DELETE, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        DeleteClusterResponse response = null;
        try {
            response = (DeleteClusterResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public AddSnapshotResponse addSnapshot(AddSnapshotRequest request) {
        request.validate();
        String pathToService = "/snapshots/${request.getSnapshotId()}";
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.PUT, this.endpoint, "/snapshots/${request.getSnapshotId()}");
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        httpRequest.addParameter("releaseName", request.getReleaseName());
        httpRequest.addParameter("releaseFamily", request.getReleaseFamily());
        httpRequest.addParameter("sourceRegionId", request.getSourceRegion());
        httpRequest.addParameter("destinationRegionId", request.getDestinationRegion());
        AddSnapshotResponse response = null;
        try {
            response = (AddSnapshotResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        request.validate();
        String pathToService = "/cluster/new";
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, "/cluster/new");
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        httpRequest.addParameter("name", request.getName());
        httpRequest.addParameter("serverAmi", request.getServerAmi());
        httpRequest.addParameter("numWorkers", Integer.toString(request.getNumWorkers()));
        httpRequest.addParameter("numNodes", Integer.toString(request.getNumNodes()));
        httpRequest.addParameter("totalNumWorkers", Integer.toString(request.getNumNodes() * request.getNumWorkers()));
        httpRequest.addParameter("serverKey", request.getServerKey());
        httpRequest.addParameter("matlabRelease", request.getMatlabRelease());
        httpRequest.addParameter("serverSize", request.getServerSize());
        httpRequest.addParameter("regionName", request.getRegionName());
        httpRequest.addParameter("persistedSize", Integer.toString(request.getPersistedSize()));
        httpRequest.addParameter("shouldStartCluster", Boolean.toString(request.isShouldStartCluster()));
        if (request.isAutoTerminate()) {
            httpRequest.addParameter("terminationPolicy", TerminationPolicy.FIXED_DURATION.toString());
            httpRequest.addParameter("durationInSeconds", Integer.toString(request.getTimeoutInHours() * 3600));
        } else {
            httpRequest.addParameter("terminationPolicy", TerminationPolicy.NEVER.toString());
        }
        CreateClusterResponse response = null;
        try {
            response = (CreateClusterResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public ClusterInfoResponse getMWHostedClusterInfo(GetMWHostedClusterInfoRequest request) {
        request.validate();
        String pathToService = "/hosted/cluster";
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.PUT, this.endpoint, "/hosted/cluster");
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        httpRequest.addParameter("matlabRelease", request.getRelease());
        httpRequest.addParameter("name", request.getName());
        httpRequest.addParameter("qname", request.getQname());
        httpRequest.addParameter("entitlementId", request.getEntitlementId());
        httpRequest.addParameter("shouldProvision", Boolean.toString(request.isShouldProvision()));
        ClusterInfoResponse response = null;
        try {
            response = (ClusterInfoResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    private static final void handleServiceException(MathWorksServiceException e) {
        MathWorksServiceException ex = e;
        for (CloudCenterErrorCode code : CloudCenterErrorCode.values()) {
            if (!code.getValue().equals(e.getErrorCode())) continue;
            try {
                ex = code.getExceptionClass().getDeclaredConstructor(((Object)((Object)e)).getClass()).newInstance(new Object[]{e});
            }
            catch (Throwable ignore) {}
            break;
        }
        throw ex;
    }

    @Override
    public ClusterInfoResponse updateCluster(UpdateClusterRequest request) {
        request.validate();
        String pathToService = "/cluster/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        if (request.getTotalNumWorkers() != null) {
            httpRequest.addParameter("totalNumWorkers", Integer.toString(request.getTotalNumWorkers()));
        }
        if (request.getTerminationPolicy() != null) {
            httpRequest.addParameter("terminationPolicy", request.getTerminationPolicy().toString());
        }
        if (request.getDurationInSeconds() != null) {
            httpRequest.addParameter("durationInSeconds", Long.toString(request.getDurationInSeconds()));
        }
        ClusterInfoResponse response = null;
        try {
            response = (ClusterInfoResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public ClusterInfoResponse updateMWHostedCluster(UpdateMWHostedClusterRequest request) {
        request.validate();
        String pathToService = "/hosted/cluster/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        httpRequest.addParameter("terminationPolicy", request.getTerminationPolicy().toString());
        if (request.getDurationInSeconds() != null) {
            httpRequest.addParameter("durationInSeconds", Long.toString(request.getDurationInSeconds()));
        }
        ClusterInfoResponse response = null;
        try {
            response = (ClusterInfoResponse)this.executeRequest(httpRequest);
        }
        catch (MathWorksServiceException e) {
            CloudCenterClient.handleServiceException(e);
        }
        catch (MathWorksClientException e) {
            throw e;
        }
        return response;
    }

    @Override
    public void heartbeatCluster(HeartbeatClusterRequest request) throws HeartbeatFailedException {
        String clusterId = request.getClusterId();
        if (null == clusterId || clusterId.length() == 0) {
            throw new IllegalArgumentException("Heartbeat requires a clusterId");
        }
        String pathToService = "/cluster/heartbeat/" + clusterId;
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.POST, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        try {
            this.executeRequest(httpRequest);
        }
        catch (Throwable ignore) {
            throw new HeartbeatFailedException("Failed to heartbeat " + request.getClusterId());
        }
    }
}

