/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;

public final class Erasable {
    private final byte[] fPlainBytes;

    public Erasable() {
        this.fPlainBytes = new byte[0];
    }

    public Erasable(byte[] byArray) {
        assert (byArray != null);
        int n = byArray.length;
        this.fPlainBytes = new byte[n];
        System.arraycopy(byArray, 0, this.fPlainBytes, 0, n);
        Erasable.erase(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Erasable(char[] cArray) {
        assert (cArray != null);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 * cArray.length);
        for (char c : cArray) {
            byteBuffer.putChar(c);
        }
        Erasable.erase(cArray);
        try {
            this.fPlainBytes = new byte[byteBuffer.capacity()];
            byteBuffer.rewind();
            byteBuffer.get(this.fPlainBytes);
        }
        finally {
            Erasable.erase(byteBuffer);
        }
    }

    public Erasable copy() {
        byte[] byArray = new byte[this.fPlainBytes.length];
        System.arraycopy(this.fPlainBytes, 0, byArray, 0, this.fPlainBytes.length);
        return new Erasable(byArray);
    }

    public void erase() {
        Erasable.erase(this.fPlainBytes);
    }

    public byte[] get() {
        return Arrays.copyOf(this.fPlainBytes, this.fPlainBytes.length);
    }

    public char[] toCharArray() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.fPlainBytes);
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        char[] cArray = new char[charBuffer.length()];
        charBuffer.get(cArray);
        return cArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Erasable)) {
            return false;
        }
        return Arrays.equals(this.get(), ((Erasable)object).get());
    }

    public int hashCode() {
        return Arrays.hashCode(this.fPlainBytes);
    }

    public static Erasable concat(byte[] ... byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte[] byArray2 : byArray) {
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        }
        return new Erasable(byteArrayOutputStream.toByteArray());
    }

    private static void erase(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            byteBuffer.put((byte)0);
        }
    }

    private static void erase(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    private static void erase(char[] cArray) {
        Arrays.fill(cArray, ' ');
    }
}

