/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.DecryptFailedException;
import com.mathworks.toolbox.distcomp.auth.credentials.LoginTokenCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;

public class EncryptedLoginTokenCredentials
implements TransferableCredentials {
    private final UserIdentity fUserIdentity;
    private final EncryptedObject fEncryptedLoginToken;
    private final byte[] fSalt;
    private final boolean fEncrypted;

    public EncryptedLoginTokenCredentials(UserIdentity userIdentity, EncryptedObject encryptedObject, byte[] byArray) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedLoginToken = encryptedObject;
        this.fSalt = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fSalt, 0, byArray.length);
        this.fEncrypted = true;
    }

    public EncryptedLoginTokenCredentials(UserIdentity userIdentity, Erasable erasable) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedLoginToken = new EncryptedObject(erasable.get());
        this.fSalt = new byte[0];
        this.fEncrypted = false;
    }

    @Override
    public NontransferableCredentials unpack(byte[] byArray, CryptoModule.Decryptor decryptor) throws CredentialCreationException {
        if (!this.fEncrypted) {
            return new LoginTokenCredentials(this.fUserIdentity, new Erasable(this.fEncryptedLoginToken.get()));
        }
        try {
            Erasable erasable = decryptor.decryptWithSalt(this.fEncryptedLoginToken, byArray);
            return new LoginTokenCredentials(this.fUserIdentity, erasable);
        }
        catch (CryptoException cryptoException) {
            throw new DecryptFailedException(this.fUserIdentity, (Throwable)cryptoException);
        }
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }
}

