/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mvm.helpers.MatlabPrintStreamManager;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.TextualCredentialConsumer;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.io.PrintStream;

public final class MatlabCommandWindowPrompt
implements TextualCredentialConsumer.Prompt {
    private static final String READ_PASSWORD_METHOD = "parallel.internal.readPassword";
    private final PrintStream fMatlabOutStream;
    private final PrintStream fMatlabErrStream;

    public MatlabCommandWindowPrompt() throws ConsumerCreationException {
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        if (matlabMCR == null) {
            throw new NoMatlabRefException();
        }
        this.fMatlabOutStream = MatlabPrintStreamManager.createMatlabOutputStream();
        this.fMatlabErrStream = MatlabPrintStreamManager.createMatlabErrorStream();
    }

    @Override
    public PrintStream getOutputStream() {
        return this.fMatlabOutStream;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.fMatlabErrStream;
    }

    @Override
    public char[] prompt(String string, boolean bl) throws NoCredentialsEnteredException {
        Object object;
        Object[] objectArray;
        String string2;
        if (bl) {
            string2 = READ_PASSWORD_METHOD;
            objectArray = new Object[]{string};
        } else {
            string2 = "input";
            objectArray = new Object[]{string, "s"};
        }
        try {
            int n = 1;
            object = MatlabMCR.mtFevalConsoleOutput((String)string2, (Object[])objectArray, (int)n);
        }
        catch (Exception exception) {
            throw new NoCredentialsEnteredException(null, (Throwable)exception);
        }
        if (object instanceof Exception) {
            throw new NoCredentialsEnteredException(null, (Throwable)object);
        }
        return this.canonicalise((String)object).toCharArray();
    }

    private String canonicalise(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\b') {
                if (stringBuilder.length() <= 0) continue;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static final class NoMatlabRefException
    extends ConsumerCreationException {
        private final BaseMsgID fBaseMsgID = new mjs.NoMatlabRef();

        private NoMatlabRefException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

