/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer.model;

import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthModelResourceMessenger;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModel;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputCreator;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputField;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthorizationModelFactory {
    private static final ResourceBundleUtilities.ResourceBundleMessenger SET_CURRENT_USER_USERNAME = new AuthModelResourceMessenger("SetCurrentUser.USERNAME", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger ADD_NEW_USER_NEW_PASSWORD = new AuthModelResourceMessenger("AddNewUser.NEW_PASSWORD", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger ADD_NEW_USER_CONFIRM_NEW = new AuthModelResourceMessenger("AddNewUser.CONFIRM_NEW", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger ADD_NEW_USER_REMEMBER = new AuthModelResourceMessenger("AddNewUser.REMEMBER", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger AUTHENTICATE_CURRENT_PASSWORD = new AuthModelResourceMessenger("Authenticate.CURRENT_PASSWORD", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger AUTHENTICATE_REMEMBER = new AuthModelResourceMessenger("Authenticate.REMEMBER", new Object[0]);
    private static final ResourceBundleUtilities.ResourceBundleMessenger AUTHENTICATE_REMEMBER_CHOICE = new AuthModelResourceMessenger("Authenticate.REMEMBER_CHOICE", new Object[0]);
    private static final String KEY_SET_CURRENT_USER_BLURB = "SetCurrentUser.BLURB";
    private static final String KEY_ADD_NEW_USER_BLURB = "AddNewUser.BLURB";
    private static final String KEY_AUTHENTICATE_BLURB = "Authenticate.BLURB";
    private static final String KEY_SWITCH_USER_BLURB = "SwitchUser.BLURB";
    private final Map<InputField, Object> fDefaults = new HashMap<InputField, Object>();
    private final Set<InputField> fRememberFields = new HashSet<InputField>();
    private final CredentialConsumerConfig fConfig;
    private String fInvokingUsername = null;
    private String fTargetUsername = null;

    public AuthorizationModelFactory(CredentialConsumerConfig credentialConsumerConfig) {
        this.fConfig = credentialConsumerConfig;
        this.setDefault(InputField.REMEMBER, RememberChoice.SESSION);
    }

    public void setInvokingUsername(String string) {
        this.fInvokingUsername = string;
    }

    public void setTargetUsername(String string) {
        this.fTargetUsername = string;
    }

    public AuthorizationModel createModel(ModelSpec modelSpec) {
        InputCreator[] inputCreatorArray;
        String string;
        assert (modelSpec != null) : "spec must not be null.";
        switch (modelSpec) {
            case SET_CURRENT_USER: {
                string = KEY_SET_CURRENT_USER_BLURB;
                inputCreatorArray = new InputCreator[]{new InputCreator(InputField.USERNAME, SET_CURRENT_USER_USERNAME)};
                break;
            }
            case ADD_NEW_USER: {
                string = KEY_ADD_NEW_USER_BLURB;
                inputCreatorArray = new InputCreator[]{new InputCreator(InputField.NEW_PASSWORD, ADD_NEW_USER_NEW_PASSWORD), new InputCreator(InputField.CONFIRM_NEW, ADD_NEW_USER_CONFIRM_NEW), new InputCreator(InputField.REMEMBER, ADD_NEW_USER_REMEMBER)};
                break;
            }
            case AUTHENTICATE: {
                string = KEY_AUTHENTICATE_BLURB;
                if (this.fConfig.getSecurityLevel() == 1) {
                    inputCreatorArray = new InputCreator[]{new InputCreator(InputField.REMEMBER, AUTHENTICATE_REMEMBER_CHOICE)};
                    break;
                }
                inputCreatorArray = new InputCreator[]{new InputCreator(InputField.CURRENT_PASSWORD, AUTHENTICATE_CURRENT_PASSWORD), new InputCreator(InputField.REMEMBER, AUTHENTICATE_REMEMBER)};
                break;
            }
            case CHANGE_PASSWORD: {
                String string2 = this.fInvokingUsername.equals(this.fTargetUsername) ? "ChangePassword.SameUser." : "ChangePassword.DifferentUser.";
                string = string2 + "BLURB";
                inputCreatorArray = new InputCreator[]{new InputCreator(InputField.CURRENT_PASSWORD, new AuthModelResourceMessenger(string2 + "CURRENT_PASSWORD", this.fInvokingUsername)), new InputCreator(InputField.NEW_PASSWORD, new AuthModelResourceMessenger(string2 + "NEW_PASSWORD", this.fTargetUsername)), new InputCreator(InputField.CONFIRM_NEW, new AuthModelResourceMessenger(string2 + "CONFIRM_NEW", this.fTargetUsername)), new InputCreator(InputField.REMEMBER, new AuthModelResourceMessenger(string2 + "REMEMBER", new Object[0]))};
                break;
            }
            case SWITCH_USER: {
                string = KEY_SWITCH_USER_BLURB;
                if (this.fConfig.getSecurityLevel() > 1) {
                    inputCreatorArray = new InputCreator[]{new InputCreator(InputField.USERNAME, SET_CURRENT_USER_USERNAME), new InputCreator(InputField.CURRENT_PASSWORD, AUTHENTICATE_CURRENT_PASSWORD)};
                    break;
                }
                inputCreatorArray = new InputCreator[]{};
                break;
            }
            default: {
                assert (false) : "spec \"" + (Object)((Object)modelSpec) + "\" unrecognized.";
                return null;
            }
        }
        return new AuthorizationModel(this, new AuthModelResourceMessenger(string + "." + this.fConfig.getSecurityLevel(), this.fTargetUsername, this.fInvokingUsername, this.fConfig.getJobManagerName(), this.fConfig.getJobManagerHostname()), this.fConfig.getAllowClientPasswordCache(), inputCreatorArray);
    }

    public synchronized Object getDefault(InputField inputField) {
        return this.fDefaults.get((Object)inputField);
    }

    public synchronized void setDefault(InputField inputField, Object object) {
        this.fDefaults.put(inputField, object);
    }

    protected CredentialConsumerConfig getConfig() {
        return this.fConfig;
    }

    protected String getTargetUsername() {
        return this.fTargetUsername;
    }

    protected String getInvokingUsername() {
        return this.fInvokingUsername;
    }

    private synchronized boolean isRememberedField(InputField inputField) {
        return this.fRememberFields.contains((Object)inputField);
    }

    public synchronized void setRememberValueForField(InputField inputField, boolean bl) {
        if (bl) {
            this.fRememberFields.add(inputField);
        } else {
            this.fRememberFields.remove((Object)inputField);
        }
    }

    void commitModel(AuthorizationModel authorizationModel) {
        for (InputField inputField : authorizationModel.getInputFields()) {
            if (!this.isRememberedField(inputField)) continue;
            this.setDefault(inputField, authorizationModel.getInputValue(inputField));
        }
    }

    public static enum ModelSpec {
        SET_CURRENT_USER,
        ADD_NEW_USER,
        AUTHENTICATE,
        CHANGE_PASSWORD,
        SWITCH_USER;

    }
}

