/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class ExpiryHashMap<K, V>
extends HashMap<K, V> {
    private HashMap<K, Long> fExpiryTimes = new HashMap();
    private TimeProvider fTimeProvider;

    ExpiryHashMap() {
        this.fTimeProvider = new SystemTimeProvider();
    }

    ExpiryHashMap(TimeProvider timeProvider) {
        this.fTimeProvider = timeProvider;
    }

    @Override
    public void clear() {
        super.clear();
        this.fExpiryTimes.clear();
    }

    @Override
    public Object clone() {
        ExpiryHashMap expiryHashMap = (ExpiryHashMap)super.clone();
        expiryHashMap.fExpiryTimes = (HashMap)this.fExpiryTimes.clone();
        expiryHashMap.fTimeProvider = this.fTimeProvider;
        return expiryHashMap;
    }

    @Override
    public boolean containsKey(Object object) {
        this.checkExpiryTime(object);
        return super.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        this.checkAllExpiryTimes();
        return super.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkAllExpiryTimes();
        return super.entrySet();
    }

    @Override
    public V get(Object object) {
        this.checkExpiryTime(object);
        return super.get(object);
    }

    @Override
    public boolean isEmpty() {
        this.checkAllExpiryTimes();
        return super.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.checkAllExpiryTimes();
        return super.keySet();
    }

    public V put(K k, V v, long l) {
        this.addExpiryTime(k, l);
        return this.put(k, v);
    }

    @Override
    public void putAll(ExpiryHashMap<K, V> expiryHashMap) {
        for (Map.Entry<K, V> entry : expiryHashMap.entrySet()) {
            K k = entry.getKey();
            this.put(k, entry.getValue());
            if (!expiryHashMap.fExpiryTimes.containsKey(k)) continue;
            this.fExpiryTimes.put(k, expiryHashMap.fExpiryTimes.get(k));
        }
    }

    @Override
    public V remove(Object object) {
        this.fExpiryTimes.remove(object);
        return super.remove(object);
    }

    @Override
    public int size() {
        this.checkAllExpiryTimes();
        return super.size();
    }

    @Override
    public Collection<V> values() {
        this.checkAllExpiryTimes();
        return super.values();
    }

    private void addExpiryTime(K k, long l) {
        if (l > 0L) {
            long l2 = this.fTimeProvider.currentTimeMillis() + l * 1000L;
            this.fExpiryTimes.put(k, l2);
        }
    }

    private void checkExpiryTime(Object object) {
        if (this.fExpiryTimes.containsKey(object) && this.fExpiryTimes.get(object) < this.fTimeProvider.currentTimeMillis()) {
            this.remove(object);
        }
    }

    private void checkAllExpiryTimes() {
        for (K k : this.fExpiryTimes.keySet()) {
            this.checkExpiryTime(k);
        }
    }
}

