/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.credentials.Credentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.ExpiryHashMap;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class MultiUserCredentialStore<T extends Credentials>
implements CredentialStore<T> {
    private static final long LIFETIME_SECS = 300L;
    private ExpiryHashMap<UserIdentity, T> fMap = new ExpiryHashMap();

    public MultiUserCredentialStore() {
    }

    public MultiUserCredentialStore(T t) {
        this.putCredentials(t);
    }

    public MultiUserCredentialStore(T ... TArray) {
        for (T t : TArray) {
            this.putCredentials(t);
        }
    }

    @Override
    public void removeAllCredentials() {
        this.fMap.clear();
    }

    @Override
    public boolean containsUser(UserIdentity userIdentity) {
        return this.fMap.containsKey(userIdentity);
    }

    @Override
    public T getCredentials(UserIdentity userIdentity) throws NoCredentialsException {
        if (!this.fMap.containsKey(userIdentity)) {
            throw new NoCredentialsException(userIdentity);
        }
        return (T)((Credentials)this.fMap.get(userIdentity));
    }

    @Override
    public void putCredentials(T t) {
        assert (t != null);
        this.fMap.put(t.getUserIdentity(), t);
    }

    @Override
    public void putAllCredentials(Collection<T> collection) {
        for (Credentials credentials : collection) {
            this.putCredentials(credentials);
        }
    }

    @Override
    public void putCredentials(T t, RememberChoice rememberChoice) {
        if (rememberChoice == null) {
            return;
        }
        switch (rememberChoice) {
            case ALWAYS: 
            case SESSION: {
                this.fMap.put(t.getUserIdentity(), t);
                break;
            }
            case TEMPORARY: {
                this.fMap.put(t.getUserIdentity(), t, 300L);
                break;
            }
        }
    }

    @Override
    public T removeUser(UserIdentity userIdentity) {
        assert (userIdentity != null);
        return (T)((Credentials)this.fMap.remove(userIdentity));
    }

    @Override
    public Collection<T> getAllCredentials() {
        return this.fMap.values();
    }

    public String toString() {
        Iterator<T> iterator = this.getAllCredentials().iterator();
        return "MultiUserCredentialStore{" + StringUtils.join(iterator, (String)",") + "}";
    }

    @Override
    public CredentialStore.Memento<T> createMemento() {
        return new MultiUserCredentialStoreMemento(this);
    }

    @Override
    public void restoreFromMemento(CredentialStore.Memento<T> memento) {
        if (!(memento instanceof MultiUserCredentialStoreMemento)) {
            throw new IllegalArgumentException("memento must be instance of MultiUserCredentialStoreMemento.");
        }
        MultiUserCredentialStoreMemento multiUserCredentialStoreMemento = (MultiUserCredentialStoreMemento)memento;
        multiUserCredentialStoreMemento.restore(this);
    }

    private static class MultiUserCredentialStoreMemento<T extends Credentials>
    implements CredentialStore.Memento<T> {
        private ExpiryHashMap<UserIdentity, T> fMementoMap = new ExpiryHashMap();

        private MultiUserCredentialStoreMemento(MultiUserCredentialStore<T> multiUserCredentialStore) {
            this.fMementoMap.putAll(((MultiUserCredentialStore)multiUserCredentialStore).fMap);
        }

        private void restore(MultiUserCredentialStore<T> multiUserCredentialStore) {
            ((MultiUserCredentialStore)multiUserCredentialStore).fMap.clear();
            ((MultiUserCredentialStore)multiUserCredentialStore).fMap.putAll(this.fMementoMap);
        }
    }
}

