/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialVerificationException;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.SignedPlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ChangePasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStoreFactory;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleImpl;
import com.mathworks.toolbox.distcomp.auth.modules.DialogUnavailableException;
import com.mathworks.toolbox.distcomp.auth.modules.RemoteAuthorisationModuleImpl;
import com.mathworks.toolbox.distcomp.auth.modules.SignatureModuleKeyPairImpl;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import java.io.IOException;

public class AuthorisationModuleWithPasswordImpl
extends AuthorisationModuleImpl {
    private static final SignatureModuleKeyPairImpl SIGNATURE_MODULE = new SignatureModuleKeyPairImpl();
    protected final CredentialConsumerConfig fConsumerConfig;
    protected final CredentialStoreFactory fStoreFactory;

    public AuthorisationModuleWithPasswordImpl(AuthorisationModuleConfig authorisationModuleConfig) throws StorageInitException {
        super(authorisationModuleConfig);
        this.fConsumerConfig = authorisationModuleConfig.createCredentialConsumerConfig();
        this.fStoreFactory = authorisationModuleConfig.createCredentialStoreFactory();
    }

    @Override
    protected PlainCredentials retrieveAdminUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException {
        PlainCredentials plainCredentials = this.retrieveUser(userIdentity, credentialProviderLocal);
        AuthorisationModuleWithPasswordImpl.checkSignedPlainCredentials(plainCredentials);
        return plainCredentials;
    }

    private static void checkSignedPlainCredentials(PlainCredentials plainCredentials) throws CredentialVerificationException {
        if (plainCredentials instanceof SignedPlainCredentials) {
            SignedPlainCredentials signedPlainCredentials = (SignedPlainCredentials)plainCredentials;
            try {
                signedPlainCredentials.checkSignature(SIGNATURE_MODULE.readPublicKeyFromProperties(), SIGNATURE_MODULE.getVerifier());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DeserializeClassNotFoundException(plainCredentials.getUserIdentity(), classNotFoundException);
            }
            catch (IOException iOException) {
                throw new DeserializeIOException(plainCredentials.getUserIdentity(), iOException);
            }
        } else {
            throw new NonSignedPlainCredentialsException(plainCredentials.getUserIdentity());
        }
    }

    @Override
    public RemoteAuthorisationModule getRemoteAuthorisationModule() {
        return new RemoteAMWithPasswordImpl(this.fConsumerConfig, this.fStoreFactory);
    }

    private static final class NonSignedPlainCredentialsException
    extends CredentialVerificationException {
        private final BaseMsgID fBaseMsgID = new mjs.NonSignedPlainCredentials();

        private NonSignedPlainCredentialsException(UserIdentity userIdentity) {
            super(userIdentity);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class DeserializeIOException
    extends CredentialVerificationException {
        private final BaseMsgID fBaseMsgID = new mjs.DeserializeIO();

        private DeserializeIOException(UserIdentity userIdentity, Throwable throwable) {
            super(userIdentity, throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class DeserializeClassNotFoundException
    extends CredentialVerificationException {
        private final BaseMsgID fBaseMsgID = new mjs.DeserializeClassNotFound();

        private DeserializeClassNotFoundException(UserIdentity userIdentity, Throwable throwable) {
            super(userIdentity, throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    protected static class RemoteAMWithPasswordImpl
    extends RemoteAuthorisationModuleImpl {
        private static final long serialVersionUID = -2085164124220683458L;
        private final CredentialStoreFactory fStoreFactory;

        protected RemoteAMWithPasswordImpl(CredentialConsumerConfig credentialConsumerConfig, CredentialStoreFactory credentialStoreFactory) {
            super(credentialConsumerConfig);
            this.fStoreFactory = credentialStoreFactory;
        }

        @Override
        public CurrentTokenReturn promptForCurrentPassword(UserIdentity userIdentity, Throwable throwable) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForCurrentPassword(userIdentity, throwable);
        }

        @Override
        public NewPasswordReturn promptForNewPassword(UserIdentity userIdentity) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForNewPassword(userIdentity);
        }

        @Override
        public ChangePasswordReturn promptForChangePassword(UserIdentity userIdentity, UserIdentity userIdentity2) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForChangePassword(userIdentity, userIdentity2);
        }

        @Override
        public CurrentTokenReturn promptForTemporaryUserSwitch(UserIdentity userIdentity) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForTemporaryUserSwitch(userIdentity);
        }

        @Override
        public UserIdentity promptForIdentity(UserIdentity userIdentity) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForIdentity(userIdentity);
        }

        @Override
        public final CredentialStore<AuthenticationToken> createCredentialStore(String string) {
            return this.fStoreFactory.createCredentialStore(string);
        }

        @Override
        public RemoteAMWithPasswordImpl copy() {
            return new RemoteAMWithPasswordImpl(this.getConsumerConfig(), this.fStoreFactory);
        }
    }
}

