/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.auth.modules.SaltMismatchException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public enum CryptoModuleHelper {
    INSTANCE;

    private static final String SYMMETRIC_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEY_PAIR_CIPHER_ALGORITHM = "RSA";
    private static final String DIGEST_ALGORITHM = "SHA-1";
    private static final String KEY_PAIR_ALGORITHM = "RSA";
    private static final int KEY_PAIR_SIZE = 1024;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private Cipher fSymmetricCipher = CryptoModuleHelper.createSymmetricCipher();
    private Cipher fKeyPairCipher = CryptoModuleHelper.createKeyPairCipher();
    private MessageDigest fDigest = CryptoModuleHelper.createDigest();
    private SecureRandom fRandom = CryptoModuleHelper.createRandom();
    private Signature fSignature = CryptoModuleHelper.createSignature();
    private boolean fInitialized = false;

    public KeyPair generateKeyPair() throws CryptoException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FailedToInitializeKeyPairAlgorithmException(noSuchAlgorithmException);
        }
    }

    synchronized byte[] decryptKeyPair(EncryptedObject encryptedObject, PrivateKey privateKey) throws CryptoException {
        return CryptoModuleHelper.decrypt(this.getKeyPairCipher(), encryptedObject, privateKey);
    }

    synchronized byte[] decryptSymmetric(EncryptedObject encryptedObject, Key key) throws CryptoException {
        return CryptoModuleHelper.decryptAES(this.getSymmetricCipher(), encryptedObject, key);
    }

    private static byte[] decrypt(Cipher cipher, EncryptedObject encryptedObject, Key key) throws CryptoException {
        try {
            cipher.init(2, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new FailedToInitializeDecryptionException(invalidKeyException);
        }
        try {
            return cipher.doFinal(encryptedObject.get());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DecryptionFailedException(generalSecurityException);
        }
    }

    private static byte[] decryptAES(Cipher cipher, EncryptedObject encryptedObject, Key key) throws CryptoException {
        try {
            cipher.init(2, key, new IvParameterSpec(encryptedObject.getParameters()));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            throw new FailedToInitializeDecryptionException(generalSecurityException);
        }
        try {
            return cipher.doFinal(encryptedObject.get());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DecryptionFailedException(generalSecurityException);
        }
    }

    synchronized EncryptedObject encryptKeyPair(byte[] byArray, PublicKey publicKey) throws CryptoException {
        return CryptoModuleHelper.encrypt(this.getKeyPairCipher(), byArray, publicKey);
    }

    synchronized EncryptedObject encryptSymmetric(byte[] byArray, Key key) throws CryptoException {
        return CryptoModuleHelper.encryptAES(this.getSymmetricCipher(), byArray, key);
    }

    private static synchronized EncryptedObject encryptAES(Cipher cipher, byte[] byArray, Key key) throws CryptoException {
        try {
            cipher.init(1, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new FailedToInitializeEncryptionException(invalidKeyException);
        }
        try {
            AlgorithmParameters algorithmParameters = cipher.getParameters();
            IvParameterSpec ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
            byte[] byArray2 = ivParameterSpec.getIV();
            return new EncryptedObject(cipher.doFinal(byArray), byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptionFailedException(generalSecurityException);
        }
    }

    private static synchronized EncryptedObject encrypt(Cipher cipher, byte[] byArray, Key key) throws CryptoException {
        try {
            cipher.init(1, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new FailedToInitializeEncryptionException(invalidKeyException);
        }
        try {
            return new EncryptedObject(cipher.doFinal(byArray));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptionFailedException(generalSecurityException);
        }
    }

    synchronized byte[] createSalt(int n) {
        byte[] byArray = new byte[n];
        this.getRandom().nextBytes(byArray);
        return byArray;
    }

    synchronized Erasable addSalt(Erasable erasable, byte[] byArray) {
        if (byArray.length > 0) {
            return Erasable.concat(byArray, erasable.get());
        }
        return erasable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Erasable removeSalt(Erasable erasable, byte[] byArray) throws CryptoException {
        byte[] byArray2;
        int n = byArray.length;
        if (n == 0) {
            return erasable;
        }
        try {
            byte[] byArray3 = new byte[n];
            System.arraycopy(erasable.get(), 0, byArray3, 0, n);
            if (!Arrays.equals(byArray, byArray3)) {
                throw new SaltMismatchException();
            }
            int n2 = erasable.get().length - n;
            byArray2 = new byte[n2];
            System.arraycopy(erasable.get(), n, byArray2, 0, n2);
        }
        finally {
            erasable.erase();
        }
        return new Erasable(byArray2);
    }

    synchronized byte[] hash(byte[] byArray) {
        return this.getDigest().digest(byArray);
    }

    synchronized byte[] sign(byte[] byArray, PrivateKey privateKey) throws CryptoException {
        try {
            this.getSignature().initSign(privateKey);
            this.getSignature().update(byArray);
            return this.getSignature().sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FailedToSignDataException(generalSecurityException);
        }
    }

    synchronized boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws CryptoException {
        try {
            this.getSignature().initVerify(publicKey);
            this.getSignature().update(byArray);
            return this.getSignature().verify(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FailedToVerifySignatureDataException(generalSecurityException);
        }
    }

    private static Cipher createSymmetricCipher() {
        try {
            return Cipher.getInstance(SYMMETRIC_CIPHER_ALGORITHM);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FailedToInitializeSymmetricCipherAlgorithmRuntimeException(generalSecurityException);
        }
    }

    private static Cipher createKeyPairCipher() {
        try {
            return Cipher.getInstance("RSA");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FailedToInitializeKeyPairCipherAlgorithmRuntimeException(generalSecurityException);
        }
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FailedToInitializeDigestHashAlgorithmRuntimeException(noSuchAlgorithmException);
        }
    }

    private static SecureRandom createRandom() {
        try {
            return SecureRandom.getInstance(RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FailedToInitializeRandomAlgorithmRuntimeException(noSuchAlgorithmException);
        }
    }

    private static Signature createSignature() {
        try {
            return Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FailedToInitializeSigningAlgorithmRuntimeException(noSuchAlgorithmException);
        }
    }

    private Cipher getSymmetricCipher() {
        return this.fSymmetricCipher;
    }

    private Cipher getKeyPairCipher() {
        return this.fKeyPairCipher;
    }

    private MessageDigest getDigest() {
        return this.fDigest;
    }

    private SecureRandom getRandom() {
        return this.fRandom;
    }

    private Signature getSignature() {
        return this.fSignature;
    }

    synchronized void initialize() {
        if (!this.fInitialized) {
            PackageInfo.LOGGER.info("Initializing CryptoModuleHelper.fSecureRandom");
            this.getRandom().nextBytes(new byte[1]);
            PackageInfo.LOGGER.info("Initialized CryptoModuleHelper.fSecureRandom");
            this.fInitialized = true;
        }
    }

    private static class FailedToInitializeSigningAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeSigningAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeSigningAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeSigningAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeRandomAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeRandomAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeRandomAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeRandomAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeDigestHashAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeDigestHashAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeDigestHashAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeDigestHashAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeKeyPairCipherAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeKeyPairCipherAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeKeyPairCipherAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeKeyPairCipherAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeSymmetricCipherAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeSymmetricCipherAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeSymmetricCipherAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeSymmetricCipherAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToVerifySignatureDataException
    extends CryptoModuleHelperException {
        FailedToVerifySignatureDataException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToVerifySignatureData(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToVerifySignatureData(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToSignDataException
    extends CryptoModuleHelperException {
        FailedToSignDataException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToSignData(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToSignData(this.getCause().getLocalizedMessage());
        }
    }

    private static class EncryptionFailedException
    extends CryptoModuleHelperException {
        EncryptionFailedException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.EncryptionFailed(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.EncryptionFailed(this.getCause().getLocalizedMessage());
        }
    }

    private static class DecryptionFailedException
    extends CryptoModuleHelperException {
        DecryptionFailedException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.DecryptionFailed(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.DecryptionFailed(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeEncryptionException
    extends CryptoModuleHelperException {
        FailedToInitializeEncryptionException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeEncryption(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeEncryption(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeDecryptionException
    extends CryptoModuleHelperException {
        FailedToInitializeDecryptionException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeDecryption(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeDecryption(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToInitializeKeyPairAlgorithmException
    extends CryptoModuleHelperException {
        FailedToInitializeKeyPairAlgorithmException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToInitializeKeyPairAlgorithm(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToInitializeKeyPairAlgorithm(this.getCause().getLocalizedMessage());
        }
    }

    private static abstract class CryptoModuleHelperException
    extends CryptoException {
        CryptoModuleHelperException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class FailedToInitializeSigningAlgorithmRuntimeException
    extends RuntimeException {
        FailedToInitializeSigningAlgorithmRuntimeException(Throwable throwable) {
            super(new FailedToInitializeSigningAlgorithmException(throwable).getMessage(), throwable);
        }
    }

    private static class FailedToInitializeRandomAlgorithmRuntimeException
    extends RuntimeException {
        FailedToInitializeRandomAlgorithmRuntimeException(Throwable throwable) {
            super(new FailedToInitializeRandomAlgorithmException(throwable).getMessage(), throwable);
        }
    }

    private static class FailedToInitializeDigestHashAlgorithmRuntimeException
    extends RuntimeException {
        FailedToInitializeDigestHashAlgorithmRuntimeException(Throwable throwable) {
            super(new FailedToInitializeDigestHashAlgorithmException(throwable).getMessage(), throwable);
        }
    }

    private static class FailedToInitializeKeyPairCipherAlgorithmRuntimeException
    extends RuntimeException {
        FailedToInitializeKeyPairCipherAlgorithmRuntimeException(Throwable throwable) {
            super(new FailedToInitializeKeyPairCipherAlgorithmException(throwable).getMessage(), throwable);
        }
    }

    private static class FailedToInitializeSymmetricCipherAlgorithmRuntimeException
    extends RuntimeException {
        FailedToInitializeSymmetricCipherAlgorithmRuntimeException(Throwable throwable) {
            super(new FailedToInitializeSymmetricCipherAlgorithmException(throwable).getMessage(), throwable);
        }
    }

    public static final class CryptoHelperException
    extends RuntimeException {
        public CryptoHelperException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

