/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.auth.modules.SymmetricKeyProvider;
import com.mathworks.toolbox.distcomp.auth.modules.UnableToCreateSecurityDirectoryIOException;
import com.mathworks.toolbox.distcomp.auth.modules.UnableToWriteKeyInformationToPathException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;

public class FileAESKeyProvider
implements SymmetricKeyProvider {
    private static final int AES_KEY_LENGTH = 128;
    private final File fSecurityDir;

    public FileAESKeyProvider(String string) {
        this.fSecurityDir = new File(string);
    }

    @Override
    public Key getKey() throws CryptoException {
        try {
            return FileAESKeyProvider.readKey(this.fSecurityDir);
        }
        catch (IOException | ClassNotFoundException exception) {
            try {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating new AES key.");
                Key key = this.generateAESKey();
                FileAESKeyProvider.storeKey(key, this.fSecurityDir);
                return key;
            }
            catch (IOException iOException) {
                throw new UnableToWriteKeyInformationToPathException(this.fSecurityDir, (Throwable)iOException);
            }
        }
    }

    private Key generateAESKey() {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FailedToGenerateAESKeyRuntimeException(noSuchAlgorithmException);
        }
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    private static Key readKey(File file) throws IOException, ClassNotFoundException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Reading AES key from " + file);
        File file2 = new File(file, "aes_private");
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file2));){
            Key key = (Key)objectInputStream.readObject();
            return key;
        }
    }

    private static void storeKey(Key key, File file) throws IOException {
        boolean bl;
        File file2 = new File(file, "aes_private");
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new UnableToCreateSecurityDirectoryIOException(file);
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));){
            objectOutputStream.writeObject(key);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Wrote AES key to security dir " + file);
    }

    private static class FailedToGenerateAESKeyException
    extends CryptoException {
        FailedToGenerateAESKeyException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.FailedToGenerateAESKey(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.FailedToGenerateAESKey(this.getCause().getLocalizedMessage());
        }
    }

    private static class FailedToGenerateAESKeyRuntimeException
    extends RuntimeException {
        FailedToGenerateAESKeyRuntimeException(Throwable throwable) {
            super(new FailedToGenerateAESKeyException(throwable).getMessage());
        }
    }
}

