/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.JobNotMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.Log;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesHelper;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class LastMirrorFilesChore
extends OneTimeChore {
    private MirrorFilesHelper fHelper = null;
    private final MirrorFilesChore fOriginalChore;
    private final Lock fLock = new ReentrantLock();

    LastMirrorFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fHelper = new MirrorFilesHelper(mirrorFilesInfo, string, parameterMap);
        this.fOriginalChore = null;
    }

    LastMirrorFilesChore(MirrorFilesChore mirrorFilesChore, FileMirrorControl fileMirrorControl) {
        super(mirrorFilesChore.getHostname(), mirrorFilesChore.getParameterMap(), fileMirrorControl);
        this.fOriginalChore = mirrorFilesChore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.fLock.lock();
        try {
            super.cancel();
            MirrorFilesHelper mirrorFilesHelper = this.getHelper();
            if (mirrorFilesHelper != null) {
                mirrorFilesHelper.cancel();
            }
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.fine(this.logPrefix() + "Canceled");
    }

    @Override
    public boolean runChore() throws JobNotMirroredException {
        if (!this.hasBeenCanceled()) {
            MirrorFilesHelper mirrorFilesHelper = this.getAndPossiblyCreateHelper();
            return mirrorFilesHelper.runChore();
        }
        return false;
    }

    private MirrorFilesHelper getAndPossiblyCreateHelper() throws JobNotMirroredException {
        MirrorFilesHelper mirrorFilesHelper = this.getHelper();
        if (mirrorFilesHelper == null) {
            this.createHelper();
            mirrorFilesHelper = this.getHelper();
        }
        return mirrorFilesHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MirrorFilesHelper getHelper() {
        this.fLock.lock();
        try {
            MirrorFilesHelper mirrorFilesHelper = this.fHelper;
            return mirrorFilesHelper;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHelper(MirrorFilesHelper mirrorFilesHelper) {
        this.fLock.lock();
        try {
            this.fHelper = mirrorFilesHelper;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void createHelper() throws JobNotMirroredException {
        if (null == this.fOriginalChore) {
            throw new IllegalStateException("Can not initialize a helper without a chore, but fOriginalChore is null");
        }
        if (!this.hasBeenCanceled()) {
            try {
                MirrorFilesHelper mirrorFilesHelper = this.fOriginalChore.copyHelper();
                this.setHelper(mirrorFilesHelper);
            }
            catch (InterruptedException interruptedException) {
                throw new JobStateRetrievalInterruptedException(this.fOriginalChore.getJobId(), interruptedException);
            }
        }
    }

    private int getJobId() {
        if (this.fOriginalChore != null) {
            return this.fOriginalChore.getJobId();
        }
        return this.getHelper().getJobFileInfo().getJobId();
    }

    @Override
    public String logPrefix() {
        return "Last mirror files for job " + this.getJobId() + " on " + this.getHostname() + ": ";
    }

    private static final class JobStateRetrievalInterruptedException
    extends JobNotMirroredException {
        JobStateRetrievalInterruptedException(int n, InterruptedException interruptedException) {
            super(n, (Throwable)interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.JobStateRetrievalInterrupted(this.getJobIdAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.JobStateRetrievalInterrupted(this.getJobIdAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }
}

