/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.control.ClusterLogsResults;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.ControlMessageException;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.NoServicesFoundException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.TestedJobManager;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedJobManagerClient;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.service.UnicastServiceNotFoundException;
import com.mathworks.toolbox.distcomp.worker.WorkerLocal;
import java.rmi.RemoteException;

public class ClusterLogsCommand
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private String fRemoteHostname = "";
    private String fAction = "";
    private String fJobManagerName = "";
    private int fLogLevel = 0;

    public ClusterLogsCommand(String string, int n, String string2) {
        this.fAction = string;
        this.fLogLevel = n;
        this.fJobManagerName = string2;
    }

    void setRemoteHostname(String string) {
        this.fRemoteHostname = string != null ? string : "";
    }

    @Override
    public String getPreRunDescription() {
        if (this.fRemoteHostname.length() == 0) {
            return new RunningClusterLogLevelCommandOnLocalhostMessage().getLocalizedMessage();
        }
        return new RunningClusterLogLevelCommandMessage(this.fRemoteHostname).getLocalizedMessage();
    }

    @Override
    public MDCSCommandResults run() throws Exception {
        MDCSCommandResults mDCSCommandResults;
        TestedJobManager[] testedJobManagerArray;
        if (this.fAction.equals("getLocation")) {
            String string = System.getProperty("com.mathworks.toolbox.distcomp.logdir", null);
            return ClusterLogsResults.create(string);
        }
        if (this.fJobManagerName.isEmpty()) {
            this.fJobManagerName = System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name");
        }
        try {
            testedJobManagerArray = ServiceAccessor.getJobManagers("localhost", this.fJobManagerName);
        }
        catch (UnicastServiceNotFoundException unicastServiceNotFoundException) {
            testedJobManagerArray = new TestedJobManager[]{};
        }
        assert (testedJobManagerArray.length < 2) : "There cannot be more than one job manager with the same name on the same host";
        if (testedJobManagerArray.length > 0) {
            mDCSCommandResults = this.runOnJobManager(testedJobManagerArray[0]);
        } else {
            Object[] objectArray;
            try {
                objectArray = ServiceAccessor.getMLWorkers("localhost", "");
            }
            catch (UnicastServiceNotFoundException unicastServiceNotFoundException) {
                objectArray = new Object[]{};
            }
            if (objectArray.length < 1) {
                throw new NoServicesFoundException(this.fJobManagerName);
            }
            mDCSCommandResults = this.runOnWorker((WorkerLocal[])objectArray);
        }
        return mDCSCommandResults;
    }

    private MDCSCommandResults runOnJobManager(JobManagerLocal jobManagerLocal) throws InvalidClusterLogCommandException, MJSException, RemoteException {
        MDCSCommandResults mDCSCommandResults;
        ProxiedJobManagerClient proxiedJobManagerClient = new ProxiedJobManagerClient(jobManagerLocal, ClusterLogsCommand.createCredentialConsumerFactory(), new SingleUserCredentialStore<AuthenticationToken>());
        if (this.fAction.equals("setLevel")) {
            proxiedJobManagerClient.setClusterLogLevel(this.fLogLevel);
            mDCSCommandResults = ClusterLogsResults.create(this.fLogLevel);
        } else if (this.fAction.equals("getLevel")) {
            mDCSCommandResults = ClusterLogsResults.create(jobManagerLocal.getClusterLogLevel());
        } else {
            throw new InvalidClusterLogCommandException(this.fAction);
        }
        return mDCSCommandResults;
    }

    private MDCSCommandResults runOnWorker(WorkerLocal[] workerLocalArray) throws RemoteException, InvalidClusterLogCommandException, MJSException, NoServicesFoundException {
        MDCSCommandResults mDCSCommandResults;
        if (this.fAction.equals("setLevel")) {
            for (WorkerLocal workerLocal : workerLocalArray) {
                workerLocal.setLogLevel(this.fLogLevel);
            }
            mDCSCommandResults = ClusterLogsResults.create(this.fLogLevel);
        } else if (this.fAction.equals("getLevel")) {
            mDCSCommandResults = ClusterLogsResults.create(workerLocalArray[0].getLogLevel());
        } else {
            throw new InvalidClusterLogCommandException(this.fAction);
        }
        return mDCSCommandResults;
    }

    private static CredentialConsumerFactory createCredentialConsumerFactory() {
        return CredentialConsumerFactory.TRIVIAL_FACTORY;
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 10000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 2000;
    }

    public String toString() {
        return new ClusterLogsCommandMessage(this.fJobManagerName, this.fRemoteHostname, this.fLogLevel).getLocalizedMessage();
    }

    private static final class ClusterLogsCommandMessage
    extends ClusterLevelLogMessage {
        private final BaseMsgID fBaseMsgID;

        ClusterLogsCommandMessage(String string, String string2, int n) {
            this.fBaseMsgID = new mjs.ClusterLogEntryCommand(string, string2, Integer.toString(n));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RunningClusterLogLevelCommandOnLocalhostMessage
    extends ClusterLevelLogMessage {
        private final BaseMsgID fBaseMsgID = new mjs.RunningClusterLogLevelCommandOnLocalhost();

        RunningClusterLogLevelCommandOnLocalhostMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RunningClusterLogLevelCommandMessage
    extends ClusterLevelLogMessage {
        private final BaseMsgID fBaseMsgID;

        RunningClusterLogLevelCommandMessage(String string) {
            this.fBaseMsgID = new mjs.RunningClusterLogLevelCommand(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class ClusterLevelLogMessage
    extends ControlMessage {
        ClusterLevelLogMessage() {
        }
    }

    private static final class InvalidClusterLogCommandException
    extends ControlMessageException {
        private final BaseMsgID fBaseMsgID;

        InvalidClusterLogCommandException(String string) {
            this.fBaseMsgID = new mjs.InvalidClusterLogCommand(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

