/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.modules.SignatureModuleKeyPairImpl;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.AdminUserRegistrar;
import com.mathworks.toolbox.distcomp.util.RemoteConfigurationFileOverride;
import com.mathworks.toolbox.distcomp.util.SystemPropertyNames;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.security.PublicKey;
import java.util.List;

public final class ControlJobmanager
extends ControlStartStopProcess {
    private static final long serialVersionUID = 1L;
    private static final SignatureModuleKeyPairImpl SIGNATURE_MODULE = new SignatureModuleKeyPairImpl();
    private final ControlJobmanagerInfo fInfo;
    private final RemoteConfigurationFileOverride fLookupHosts = new RemoteConfigurationFileOverride(SystemPropertyNames.LOOKUP_HOSTS, "JOB_MANAGER_LOOKUP_NOT_SPECIFIED");
    private final RemoteConfigurationFileOverride fPreserveJobs = new RemoteConfigurationFileOverride(SystemPropertyNames.PRESERVE_JOB_DATABASE);
    private final RemoteConfigurationFileOverride fUseGDSStorage = new RemoteConfigurationFileOverride(SystemPropertyNames.USE_GDS_STORAGE);
    private final RemoteConfigurationFileOverride fGDSEndPoint = new RemoteConfigurationFileOverride(SystemPropertyNames.GDS_END_POINT);
    private final RemoteConfigurationFileOverride fGDSLoginToken = new RemoteConfigurationFileOverride(SystemPropertyNames.GDS_LOGIN_TOKEN);
    private final RemoteConfigurationFileOverride fGDSQueueID = new RemoteConfigurationFileOverride(SystemPropertyNames.GDS_QUEUE_ID);
    private boolean fRegisterAdminUser = true;
    private final transient AdminUserRegistrar fAdminUserRegistrar;
    private final PublicKey fPublicKey;

    @Override
    protected String getDefaultServiceName() {
        return System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name", "");
    }

    public void setAdminPassword(char[] cArray) {
        this.fAdminUserRegistrar.setAdminPassword(cArray);
    }

    public void setGraphical(boolean bl) {
        this.fAdminUserRegistrar.setGraphical(bl);
    }

    @Override
    protected void afterRun() throws AdminUserRegistrar.RegistrationException {
        if (this.isStarting() && this.fRegisterAdminUser) {
            this.fAdminUserRegistrar.findJobManagerAndAddAdmin();
        }
    }

    @Override
    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        super.preRunSetup(warningAndNoteInfo);
        if (this.isStarting()) {
            SignatureModuleKeyPairImpl.writePublicKeyToProperties(this.fPublicKey);
            this.prepareLookupHostsForExport();
        }
    }

    @Override
    protected void addConfigFileOverride(List<String> list) {
        super.addConfigFileOverride(list);
        list.add(this.fLookupHosts.getConfigEntryOverride());
        list.add(this.fPreserveJobs.getConfigEntryOverride());
        list.add(this.fUseGDSStorage.getConfigEntryOverride());
        list.add(this.fGDSEndPoint.getConfigEntryOverride());
        list.add(this.fGDSLoginToken.getConfigEntryOverride());
        list.add(this.fGDSQueueID.getConfigEntryOverride());
    }

    public ControlJobmanager(ConfigRunner configRunner, boolean bl, String string, String string2, Host host, int n) {
        super(configRunner, bl, string, string2);
        this.fInfo = new ControlJobmanagerInfo();
        String string3 = host.getHostname() + ":" + n;
        this.fAdminUserRegistrar = new AdminUserRegistrar(this.getServiceName(), string3, SIGNATURE_MODULE.getSigner());
        this.fPublicKey = this.isStarting() ? SIGNATURE_MODULE.getPublicKey() : null;
    }

    public void setLookupHosts(String string) {
        if (string != null && !string.isEmpty()) {
            this.fLookupHosts.setValue(string);
        }
    }

    public void setPreserveJobs(boolean bl) {
        this.fPreserveJobs.setValue(Boolean.toString(bl));
    }

    public void setUseGDSStorage(boolean bl) {
        this.fUseGDSStorage.setValue(Boolean.toString(bl));
    }

    public void setGDSEndPoint(String string) {
        this.fGDSEndPoint.setValue(string);
    }

    public void setGDSLoginToken(String string) {
        this.fGDSLoginToken.setValue(string);
    }

    public void setGDSQueueID(String string) {
        this.fGDSQueueID.setValue(string);
    }

    @Override
    public ControlStartStopProcessInfo getInfo() {
        return this.fInfo;
    }

    private void prepareLookupHostsForExport() {
        boolean bl;
        boolean bl2 = bl = !"JOB_MANAGER_LOOKUP_NOT_SPECIFIED".equals(this.fLookupHosts.getValue());
        if (bl) {
            return;
        }
        String string = System.getProperty(SystemPropertyNames.LOOKUP_HOSTS.getPropertyName(), "");
        boolean bl3 = "MDCE_LOOKUP_NOT_SPECIFIED".equals(string);
        if (bl3) {
            String string2 = System.getProperty("com.mathworks.toolbox.distcomp.hostname", "");
            this.fLookupHosts.setValue(string2);
        } else {
            this.fLookupHosts.setValue(null);
        }
    }

    public void registerAdminUser(boolean bl) {
        this.fRegisterAdminUser = bl;
    }

    private static final class JobManagerStopNotNeededDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerStopNotNeededDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.JobManagerStopNotNeededDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JobManagerStartNotNeededDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerStartNotNeededDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.JobManagerStartNotNeededDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JobManagerPreStopDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerPreStopDescriptionMessage(String string) {
            this.fBaseMsgID = new mjs.JobManagerPreStopDescription(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JobManagerPreStartDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerPreStartDescriptionMessage(String string) {
            this.fBaseMsgID = new mjs.JobManagerPreStartDescription(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JobManagerStopSuccessDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerStopSuccessDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.JobManagerStopSuccessDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JobManagerStartSuccessDescriptionMessage
    extends ControlJobManagerMessage {
        private final BaseMsgID fBaseMsgID;

        JobManagerStartSuccessDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.JobManagerStartSuccessDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class ControlJobManagerMessage
    extends ControlMessage {
        ControlJobManagerMessage() {
        }
    }

    private static class ControlJobmanagerInfo
    extends ControlStartStopProcessInfo {
        private static final long serialVersionUID = 1L;

        private ControlJobmanagerInfo() {
        }

        @Override
        public String getStartSuccessDescription() {
            return new JobManagerStartSuccessDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getStopSuccessDescription() {
            return new JobManagerStopSuccessDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getPreStartDescription() {
            return new JobManagerPreStartDescriptionMessage(this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getPreStopDescription() {
            return new JobManagerPreStopDescriptionMessage(this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getStartNotNeededDescription() {
            return new JobManagerStartNotNeededDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getStopNotNeededDescription() {
            return new JobManagerStopNotNeededDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }
    }
}

