/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.DisplayableResultsImpl;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public class MDCSCommandArray
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private final MDCSCommand[] fCommands;
    private static final String sLINE_END = System.getProperty("line.separator");

    public MDCSCommandArray(MDCSCommand[] mDCSCommandArray) {
        this.fCommands = Arrays.copyOf(mDCSCommandArray, mDCSCommandArray.length);
    }

    @Override
    public String getPreRunDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        for (MDCSCommand mDCSCommand : this.fCommands) {
            stringBuffer.append(mDCSCommand.getPreRunDescription());
        }
        if (stringBuffer.length() > 0) {
            return new MDCSCommandArrayPreStartDescriptionMessage(this.fCommands.length).getLocalizedMessage() + this.prefixWithLineEndIfNotEmpty(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void beforeRun() throws Exception {
        for (MDCSCommand mDCSCommand : this.fCommands) {
            mDCSCommand.beforeRun();
        }
    }

    @Override
    protected void afterRun() throws Exception {
        for (MDCSCommand mDCSCommand : this.fCommands) {
            mDCSCommand.afterRun();
        }
    }

    @Override
    public MDCSCommandResults run() throws Exception {
        ForkJoinPool forkJoinPool = new ForkJoinPool(this.fCommands.length);
        LinkedList<TaskAndExceptionPair> linkedList = new LinkedList<TaskAndExceptionPair>();
        for (final MDCSCommand mDCSCommand : this.fCommands) {
            final TaskAndExceptionPair taskAndExceptionPair = new TaskAndExceptionPair();
            linkedList.add(taskAndExceptionPair);
            taskAndExceptionPair.fTask = forkJoinPool.submit(new Callable<MDCSCommandResults>(){

                @Override
                public MDCSCommandResults call() throws Exception {
                    try {
                        return mDCSCommand.run();
                    }
                    catch (Exception exception) {
                        taskAndExceptionPair.fException = exception;
                        throw exception;
                    }
                }
            });
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
        for (final TaskAndExceptionPair taskAndExceptionPair : linkedList) {
            try {
                MDCSCommandResults mDCSCommandResults = taskAndExceptionPair.fTask.get();
                if (!(mDCSCommandResults instanceof DisplayableResults)) continue;
                DisplayableResults displayableResults = (DisplayableResults)mDCSCommandResults;
                stringBuffer.append(this.prefixWithLineEndIfNotEmpty(displayableResults.getOutputForDisplay()));
                stringBuffer2.append(this.prefixWithLineEndIfNotEmpty(displayableResults.getPostRunDescription()));
                warningAndNoteInfo.addAll(displayableResults.getWarnings());
            }
            catch (ExecutionException executionException) {
                if (taskAndExceptionPair.fException != null) {
                    throw taskAndExceptionPair.fException;
                }
                throw executionException;
            }
        }
        return new DisplayableResultsImpl(stringBuffer.toString(), warningAndNoteInfo, stringBuffer2.toString());
    }

    private String prefixWithLineEndIfNotEmpty(String string) {
        if (string != null && string.length() > 0) {
            return sLINE_END + string;
        }
        return "";
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 60000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 5000;
    }

    private static final class MDCSCommandArrayPreStartDescriptionMessage
    extends MDCSCommandArrayMessage {
        private final BaseMsgID fBaseMsgID;

        MDCSCommandArrayPreStartDescriptionMessage(int n) {
            this.fBaseMsgID = new mjs.MDCSCommandArrayPreStartDescription(Integer.toString(n));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class MDCSCommandArrayMessage
    extends ControlMessage {
        MDCSCommandArrayMessage() {
        }
    }

    private static class TaskAndExceptionPair {
        ForkJoinTask<MDCSCommandResults> fTask;
        Exception fException;

        private TaskAndExceptionPair() {
        }
    }
}

