/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.CommandConfigParser;
import com.mathworks.toolbox.distcomp.control.CommandSender;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.ControlMessageException;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.StatusCommand;
import com.mathworks.toolbox.distcomp.control.StatusResults;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.cert.CertificateException;
import net.jini.config.ConfigurationException;

public final class RunCommandSender {
    private RunCommandSender() {
    }

    public static void main(String[] stringArray) {
        Object object;
        MDCSCommand mDCSCommand = null;
        String string = null;
        String string2 = null;
        ErrorPrinterImpl errorPrinterImpl = new ErrorPrinterImpl();
        int n = 0;
        boolean bl = false;
        try {
            object = new ConfigFileWrapper(stringArray);
            string2 = ((ConfigFileWrapper)object).getStringEntry("matlabroot");
            XMLMessageSystem.initializeXMLMessageSystem((String)string2);
            mDCSCommand = CommandConfigParser.createMDCSCommand((ConfigFileWrapper)object);
            string = CommandConfigParser.getRemoteHostname((ConfigFileWrapper)object);
            n = CommandConfigParser.getRemotePort((ConfigFileWrapper)object);
            bl = CommandConfigParser.isVerbose((ConfigFileWrapper)object);
        }
        catch (ControlMessageException | ConfigurationException throwable) {
            boolean bl2 = false;
            errorPrinterImpl.printThrowable(throwable, bl2);
            System.exit(1);
        }
        try {
            RunCommandSender.installCertificateIfSystemPropertySet(errorPrinterImpl, bl);
        }
        catch (CertificateNotFoundException | CertificateNotValidException controlMessageException) {
            Logger.LOGGER.finer(controlMessageException.getMessage());
            System.exit(1);
        }
        if (bl) {
            System.out.println(mDCSCommand.getPreRunDescription() + "\n");
        }
        object = null;
        try {
            object = CommandSender.sendAndRunCommand(mDCSCommand, string, n);
        }
        catch (Exception exception) {
            errorPrinterImpl.printError(exception);
            System.exit(1);
        }
        if (object instanceof DisplayableResults) {
            WarningAndNoteInfo warningAndNoteInfo;
            DisplayableResults displayableResults = (DisplayableResults)object;
            String string3 = displayableResults.getOutputForDisplay();
            if (string3.length() > 0) {
                System.out.println(string3);
            }
            if ((warningAndNoteInfo = displayableResults.getWarnings()) != null) {
                warningAndNoteInfo.printAllWarningsAndNotesToSystemOut();
            }
            if (bl) {
                System.out.println(displayableResults.getPostRunDescription() + "\n");
            }
        }
        System.exit(0);
    }

    private static void installCertificateIfSystemPropertySet(ErrorPrinter errorPrinter, boolean bl) throws CertificateNotFoundException, CertificateNotValidException {
        String string = "com.mathworks.toolbox.distcomp.control.certificate_file";
        String string2 = System.getProperty(string);
        if (string2 != null && !string2.isEmpty()) {
            try {
                if (bl) {
                    System.out.println(new UsingCertificateMessage(string2).getLocalizedMessage());
                    System.out.println();
                }
                File file = new File(string2);
                String string3 = RunCommandSender.class.getSimpleName();
                ClientCertificateStore.getInstance().setCertificateEntry(string3, file);
            }
            catch (CertificateException certificateException) {
                errorPrinter.printError(new CertificateNotValidException(string2).getLocalizedMessage(), certificateException.getLocalizedMessage());
                throw new CertificateNotValidException(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                errorPrinter.printError(new CertificateNotFoundException(string2).getLocalizedMessage(), fileNotFoundException.getLocalizedMessage());
                throw new CertificateNotFoundException(string2);
            }
        }
    }

    public static StatusResults getStatusResults(String string, int n) {
        MDCSCommandResults mDCSCommandResults;
        StatusCommand statusCommand = new StatusCommand(0);
        try {
            int n2 = PortConfig.getRemoteCommandPort(Integer.toString(n));
            mDCSCommandResults = CommandSender.sendAndRunCommand(statusCommand, string, n2);
        }
        catch (Exception exception) {
            return null;
        }
        if (!(mDCSCommandResults instanceof StatusResults)) {
            return null;
        }
        return (StatusResults)mDCSCommandResults;
    }

    private static class UsingCertificateMessage
    extends ControlMessage {
        private final BaseMsgID fBaseMsgID;

        UsingCertificateMessage(String string) {
            this.fBaseMsgID = new mjs.UsingCertificate(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static class CertificateNotFoundException
    extends ControlMessageException {
        private final BaseMsgID fBaseMsgID;

        CertificateNotFoundException(String string) {
            this.fBaseMsgID = new mjs.CertificateNotFound(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static class CertificateNotValidException
    extends ControlMessageException {
        private final BaseMsgID fBaseMsgID;

        CertificateNotValidException(String string) {
            this.fBaseMsgID = new mjs.CertificateNotValid(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

