/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import java.io.Serializable;
import java.util.Date;

public abstract class ServiceInfo
implements Comparable<ServiceInfo>,
Serializable {
    private Host fHost;
    private String fServiceName;
    private Date fStartTime;
    private ServiceStatus fStatus;

    protected ServiceInfo(String string, Host host, Date date, ServiceStatus serviceStatus) {
        assert (string != null) : "serviceName was null";
        assert (serviceStatus != null) : "status was null";
        this.fHost = host;
        this.fServiceName = string;
        this.fStartTime = date;
        this.fStatus = serviceStatus;
    }

    public String getServiceName() {
        return this.fServiceName;
    }

    public Host getHost() {
        return this.fHost;
    }

    public String getHostName() {
        return this.getUserSpecifiedHostName();
    }

    public String getMDCSHostName() throws NoValidMDCSHostnameException {
        String string = this.fHost.getMDCSHostname();
        if (string == null) {
            throw new NoValidMDCSHostnameException();
        }
        return string;
    }

    public String getUserSpecifiedHostName() {
        return this.fHost.getHostname();
    }

    public Date getStartTime() {
        return this.fStartTime == null ? null : (Date)this.fStartTime.clone();
    }

    public ServiceStatus getStatus() {
        return this.fStatus;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceInfo)) {
            return false;
        }
        return this.compareTo((ServiceInfo)object) == 0;
    }

    public int hashCode() {
        return this.getServiceName().hashCode() ^ this.getHostName().hashCode();
    }

    @Override
    public int compareTo(ServiceInfo serviceInfo) {
        if (this.getServiceName().equals(serviceInfo.getServiceName())) {
            return this.getHostName().toLowerCase().compareTo(serviceInfo.getHostName().toLowerCase());
        }
        return this.getServiceName().compareTo(serviceInfo.getServiceName());
    }

    public String toString() {
        String string = this.getUserSpecifiedHostName();
        try {
            if (!string.equals(this.getMDCSHostName())) {
                string = string + " (" + this.getMDCSHostName() + ")";
            }
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            string = string + " (unknown)";
        }
        return this.getServiceName() + " | " + string + " | " + (Object)((Object)this.getStatus()) + " | " + this.getStartTime();
    }

    protected abstract ServiceType getServiceType();
}

