/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.toolbox.distcomp.distcompobjects.EntityProxy;
import java.io.File;

public final class EntityFileProxy
extends EntityProxy {
    private final String fStorageLocation;
    private final String fEntityLocation;
    private int fEntityID;
    private String fName;

    public static EntityFileProxy[] createInstance(String string, String[] stringArray, int[] nArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        EntityFileProxy[] entityFileProxyArray = new EntityFileProxy[n];
        for (int i = 0; i < n; ++i) {
            entityFileProxyArray[i] = new EntityFileProxy(string, stringArray[i], nArray[i]);
        }
        return entityFileProxyArray;
    }

    public static EntityFileProxy createInstance(String string, String string2, int n) {
        return new EntityFileProxy(string, string2, n);
    }

    EntityFileProxy(String string, String string2, int n) {
        super(string + string2);
        this.fStorageLocation = string;
        this.fEntityLocation = string2;
        this.fEntityID = n;
        this.fName = this.initName();
    }

    public String getStorageLocation() {
        return this.fStorageLocation;
    }

    public String getEntityLocation() {
        return this.fEntityLocation;
    }

    public int getEntityID() {
        return this.fEntityID;
    }

    public String getName() {
        return this.fName;
    }

    private String initName() {
        int n = this.fEntityLocation.lastIndexOf(File.separatorChar);
        if (n < this.fEntityLocation.length()) {
            return this.fEntityLocation.substring(n + 1);
        }
        return "";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EntityFileProxy entityFileProxy = (EntityFileProxy)object;
        if (!this.fEntityLocation.equals(entityFileProxy.fEntityLocation)) {
            return false;
        }
        return this.fStorageLocation.equals(entityFileProxy.fStorageLocation);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.fStorageLocation.hashCode();
        n = 31 * n + this.fEntityLocation.hashCode();
        return n;
    }
}

