/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.jobmanager.JobCounter;
import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.JobManagerStorage;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class JobRunner
extends Thread {
    private JobManager fJobManager;
    private JobManagerStorage fStorage;
    private JobCounter fJobCounter;
    private boolean fBreakJobRunnerWait = false;
    private boolean fTerminateForUnitTest = false;

    public JobRunner(JobManager jobManager, JobManagerStorage jobManagerStorage, JobCounter jobCounter) {
        this.fJobManager = jobManager;
        this.fStorage = jobManagerStorage;
        this.fJobCounter = jobCounter;
    }

    public synchronized void init() {
        this.start();
    }

    public synchronized void clear() throws InterruptedException {
        this.terminate();
        this.join();
    }

    public void runAvailableTasks() {
        this.breakJobRunnerWait();
    }

    public void workerIsIdle() {
        this.breakJobRunnerWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    JobRunner jobRunner = this;
                    synchronized (jobRunner) {
                        if (this.fTerminateForUnitTest) {
                            break block7;
                        }
                    }
                    this.waitForTasksAndWorkers();
                    try {
                        this.dispatchTasksOfAllRunningJobs();
                        this.dispatchTasksOfAllQueuedJobs();
                        continue block7;
                    }
                    catch (NoWorkersAvailableException noWorkersAvailableException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private synchronized void breakJobRunnerWait() {
        this.fBreakJobRunnerWait = true;
        this.notifyAll();
    }

    private synchronized void terminate() {
        this.fTerminateForUnitTest = true;
        this.notifyAll();
    }

    private synchronized void waitForTasksAndWorkers() {
        while (!this.fTerminateForUnitTest) {
            boolean bl;
            boolean bl2 = bl = this.getJobManagerState() == 1;
            if (!bl && this.fJobCounter.queuedOrRunningJobsPresent() && this.fBreakJobRunnerWait) {
                this.fBreakJobRunnerWait = false;
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void dispatchTasksOfAllQueuedJobs() throws NoWorkersAvailableException, MJSException {
        Uuid uuid = this.fStorage.readFirstJobByState(1);
        while (uuid != null) {
            PackageInfo.LOGGER.log(Level.FINEST, "Dispatching tasks for first queued job: " + uuid);
            try {
                JobImpl jobImpl = (JobImpl)this.fStorage.readWorkUnit(uuid);
                Worker[][] workerArray = WorkerPool.instance().getIdleAndBusyWorkers();
                Worker[] workerArray2 = jobImpl.checkConstraintsAndRunJob(workerArray);
                boolean bl = this.workersExist(workerArray2);
                if (!bl) {
                    return;
                }
                boolean bl2 = this.dispatchTasksOfAQueuedJob(jobImpl, workerArray2);
                if (!bl2) {
                    continue;
                }
            }
            catch (WorkUnitNotFoundException | WorkUnitStateException mJSException) {
                // empty catch block
            }
            uuid = this.fStorage.readFirstJobByState(1);
        }
    }

    private void dispatchTasksOfAllRunningJobs() throws NoWorkersAvailableException, MJSException {
        Object[] objectArray = this.fStorage.readJobsByJobStateWithTasksInState(2, 0);
        PackageInfo.LOGGER.log(Level.FINEST, "Dispatching pending tasks of running jobs: " + Arrays.toString(objectArray));
        for (Object object : objectArray) {
            try {
                JobImpl jobImpl = (JobImpl)this.fStorage.readWorkUnit((Uuid)object);
                Worker[][] workerArray = WorkerPool.instance().getIdleAndBusyWorkers();
                Worker[] workerArray2 = workerArray[0];
                if (!this.workersExist(workerArray2)) {
                    throw new NoWorkersAvailableException();
                }
                Worker[] workerArray3 = jobImpl.checkConstraintsOnRunningJob(workerArray);
                boolean bl = this.workersExist(workerArray3);
                if (!bl) continue;
                this.dispatchTasksOfARunningJob(jobImpl, workerArray3);
            }
            catch (WorkUnitNotFoundException | WorkUnitStateException mJSException) {
            }
            catch (MJSException mJSException) {
                PackageInfo.LOGGER.log(Level.SEVERE, "Could not dispatch tasks due to an MJSException.", mJSException);
                throw mJSException;
            }
        }
    }

    private boolean dispatchTasksOfAQueuedJob(JobImpl jobImpl, Worker[] workerArray) throws MJSException {
        int n = jobImpl.getMinWorkers();
        int n2 = jobImpl.getMaxWorkers();
        int n3 = this.runTaskDispatcher(jobImpl, workerArray, n2);
        if (n3 == 0) {
            return false;
        }
        if (n3 < jobImpl.getMinimumTasksToDispatch()) {
            jobImpl.rerunOrCancel(new FewerTasksThanMinWorkersMessage(jobImpl.workUnitTypeForPrinting(), n3, n));
        }
        return true;
    }

    private void dispatchTasksOfARunningJob(JobImpl jobImpl, Worker[] workerArray) throws MJSException {
        Uuid uuid = jobImpl.getID();
        int n = jobImpl.getMaxWorkers();
        int n2 = WorkerPool.instance().getNumBusyWorkersForJob(uuid);
        int n3 = n - n2;
        this.runTaskDispatcher(jobImpl, workerArray, n3);
    }

    private int runTaskDispatcher(JobImpl jobImpl, Worker[] workerArray, int n) throws MJSException {
        jobImpl.sortWorkers(workerArray);
        Uuid[] uuidArray = this.getWorkerIDs(workerArray);
        TaskDispatcher taskDispatcher = jobImpl.getTaskDispatcherToUse();
        Uuid uuid = jobImpl.getID();
        int n2 = jobImpl.getJobMLType();
        boolean bl = jobImpl.isRestartWorker();
        return taskDispatcher.dispatchTasks(uuid, n2, bl, uuidArray, n);
    }

    private Uuid[] getWorkerIDs(Worker[] workerArray) {
        Uuid[] uuidArray = new Uuid[workerArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            uuidArray[i] = ((WorkerProxy)workerArray[i]).getID();
        }
        return uuidArray;
    }

    private int getJobManagerState() {
        int n;
        try {
            n = this.fJobManager.getState();
        }
        catch (RemoteException remoteException) {
            n = 2;
        }
        return n;
    }

    private boolean workersExist(Worker[] workerArray) {
        return workerArray != null && workerArray.length > 0;
    }

    public void runAvailableTasksForUnitTests() throws Exception {
        try {
            this.dispatchTasksOfAllRunningJobs();
            this.dispatchTasksOfAllQueuedJobs();
        }
        catch (NoWorkersAvailableException noWorkersAvailableException) {
            // empty catch block
        }
    }

    private static class NoWorkersAvailableException
    extends Exception {
        private NoWorkersAvailableException() {
        }
    }

    private static class FewerTasksThanMinWorkersMessage
    extends SimpleCancelMessage {
        FewerTasksThanMinWorkersMessage(String string, int n, int n2) {
            super((BaseMsgID)new mjs.FewerTasksThanMinWorkers(string, Integer.toString(n), Integer.toString(n2)));
        }
    }
}

