/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.jobmanager.NodeLocationMessageCode;
import com.mathworks.toolbox.distcomp.util.LocalNetworkInfo;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NodeLocationMessage {
    private final NetworkInformationProvider fNetworkInformationProvider;

    public NodeLocationMessage() {
        this.fNetworkInformationProvider = new LocalNetworkInformationProvider();
    }

    public NodeLocationMessage(NetworkInformationProvider networkInformationProvider) {
        this.fNetworkInformationProvider = networkInformationProvider;
    }

    public String clientLocationMessage() {
        String string;
        String[] stringArray;
        String string2;
        String string3 = null;
        try {
            string3 = this.fNetworkInformationProvider.findHostName();
            string2 = new NodeLocationI18nMessage(NodeLocationMessageCode.LocalHostNameMessage, string3).getLocalizedMessage();
        }
        catch (NetworkConfigException networkConfigException) {
            string2 = new NodeLocationI18nMessage(NodeLocationMessageCode.LocalHostNameUnknown, networkConfigException.getLocalizedMessage()).getLocalizedMessage();
        }
        if (string3 != null) {
            try {
                stringArray = this.fNetworkInformationProvider.fullyQualifiedHostName(string3);
                string = new NodeLocationI18nMessage(NodeLocationMessageCode.FullyQualifiedHostNameMessage, new Object[]{stringArray}).getLocalizedMessage();
            }
            catch (UnknownHostException unknownHostException) {
                string = new NodeLocationI18nMessage(NodeLocationMessageCode.FullyQualifiedHostNameUnknown, unknownHostException.getLocalizedMessage()).getLocalizedMessage();
            }
        } else {
            string = "";
        }
        String string4 = (stringArray = this.fNetworkInformationProvider.findHostAddresses()).length > 0 ? new NodeLocationI18nMessage(NodeLocationMessageCode.IPAddressMessage, this.createAddressListString(stringArray)).getLocalizedMessage() : new NodeLocationI18nMessage(NodeLocationMessageCode.IPAddressUnknown, new Object[0]).getLocalizedMessage();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2).append("\n").append(string).append("\n").append(string4);
        return stringBuilder.toString();
    }

    public String jobManagerLocationMessage(String string, String string2, String[] stringArray) {
        String string3;
        String string4;
        String string5 = new NodeLocationI18nMessage(NodeLocationMessageCode.MJSNameMessage, string).getLocalizedMessage();
        String string6 = new NodeLocationI18nMessage(NodeLocationMessageCode.MJSHostNameMessage, string2).getLocalizedMessage();
        try {
            string4 = this.fNetworkInformationProvider.fullyQualifiedHostName(string2);
            string3 = new NodeLocationI18nMessage(NodeLocationMessageCode.FullyQualifiedHostNameMessage, string4).getLocalizedMessage();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = new NodeLocationI18nMessage(NodeLocationMessageCode.MJSFullyQualifiedHostNameUnknown, unknownHostException.getLocalizedMessage()).getLocalizedMessage();
        }
        string4 = new NodeLocationI18nMessage(NodeLocationMessageCode.MJSIPAddressMessage, this.createAddressListString(stringArray)).getLocalizedMessage();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string5).append("\n").append(string6).append("\n").append(string3).append("\n").append(string4);
        return stringBuilder.toString();
    }

    public String workerLocationMessage(String string, String string2, String[] stringArray) {
        String string3;
        String string4;
        String string5 = new NodeLocationI18nMessage(NodeLocationMessageCode.WorkerNameMessage, string).getLocalizedMessage();
        String string6 = new NodeLocationI18nMessage(NodeLocationMessageCode.WorkerHostNameMessage, string2).getLocalizedMessage();
        try {
            string4 = this.fNetworkInformationProvider.fullyQualifiedHostName(string2);
            string3 = new NodeLocationI18nMessage(NodeLocationMessageCode.FullyQualifiedHostNameMessage, string4).getLocalizedMessage();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = new NodeLocationI18nMessage(NodeLocationMessageCode.WorkerFullyQualifiedHostNameUnknown, new Object[0]).getLocalizedMessage();
        }
        string4 = new NodeLocationI18nMessage(NodeLocationMessageCode.WorkerIPAddressMessage, this.createAddressListString(stringArray)).getLocalizedMessage();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string5).append("\n").append(string6).append("\n").append(string3).append("\n").append(string4);
        return stringBuilder.toString();
    }

    private String createAddressListString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("  ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static class NodeLocationI18nMessage
    implements HasI18nMatlabIdentifiedMessage {
        private final I18nMatlabIdentifiedMessageCreator fMessageCreator;
        private final Object[] fArguments;

        NodeLocationI18nMessage(I18nMatlabIdentifiedMessageCreator i18nMatlabIdentifiedMessageCreator, Object ... objectArray) {
            this.fMessageCreator = i18nMatlabIdentifiedMessageCreator;
            this.fArguments = objectArray;
        }

        @Override
        public String getMessage() {
            return this.fMessageCreator.createMessage(this.fArguments);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fMessageCreator.createLocalizedMessage(this.fArguments);
        }

        public String getMessageID() {
            return this.fMessageCreator.getMessageID();
        }
    }

    private static class LocalNetworkInformationProvider
    implements NetworkInformationProvider {
        private LocalNetworkInformationProvider() {
        }

        @Override
        public String findHostName() throws NetworkConfigException {
            return LocalNetworkInfo.findHostName();
        }

        @Override
        public String fullyQualifiedHostName(String string) throws UnknownHostException {
            return InetAddress.getByName(string).getCanonicalHostName();
        }

        @Override
        public String[] findHostAddresses() {
            return LocalNetworkInfo.findAllHostAddresses();
        }
    }

    public static interface NetworkInformationProvider {
        public String findHostName() throws NetworkConfigException;

        public String fullyQualifiedHostName(String var1) throws UnknownHostException;

        public String[] findHostAddresses();
    }
}

