/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.distcompobjects.Distcomp;
import com.mathworks.toolbox.distcomp.jobmanager.JobRunner;
import com.mathworks.toolbox.distcomp.jobmanager.NodeLocationMessage;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.RegistrationAuthority;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.toolbox.distcomp.workunit.TaskAttemptIdentifier;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.messages.UserDefinedCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;

public class WorkerPool
implements WorkerRegistration {
    private static WorkerPool sWorkerPool = null;
    private static final String WORKER_BECAME_IDLE_MESSAGE = "The worker working on this task re-registered with the job manager as an Idle worker.\nThis indicates that the worker crashed during execution or had problems submitting its results.";
    private static final String CONTACT_LOST_MESSAGE = "The task was cancelled because the job manager lost contact with the worker. This may have been\ncaused by a network failure, a crash of the worker process, a crash of the worker computer,\nor the worker being stopped during execution.";
    private static final String WORKER_WAS_REMOVED = "The task was cancelled because its worker has been removed from the cluster (it has either been\nstopped or destroyed).";
    private static final int MIN_CANCELLER_THREADS = 1;
    private static final int MAX_CANCELLER_THREADS = 5;
    private static final long KEEP_ALIVE_TIME_MILLIS = 200L;
    private HashMap<Uuid, IdleWorkerReg> fIdleWorkers = new HashMap();
    private HashMap<Uuid, BusyWorkerReg> fBusyWorkers = new HashMap();
    private final long fRenewalIntervalMillis;
    private long fTimeoutMillis;
    private final WorkUnitStorage fStorage;
    private WorkerRegistration fStub;
    private final RegistrationAuthority fRegistrationAuthority;
    private JobRunner fJobRunner;
    private boolean fUnitTesting;
    private Vector<Uuid> fDispatchInProgressWorkerIDs = new Vector();
    private ThreadPoolExecutor fWorkerTaskCanceller;
    private TimeProvider fTimeProvider = new SystemTimeProvider();
    private final ExporterFactory fExporterFactory;

    private WorkerPool(long l, long l2, WorkUnitStorage workUnitStorage, Uuid[] uuidArray, RegistrationAuthority registrationAuthority, ExporterFactory exporterFactory, JobRunner jobRunner, boolean bl) throws MJSException {
        this.fExporterFactory = exporterFactory;
        this.fUnitTesting = bl;
        this.fTimeoutMillis = (long)(1.2 * (double)l);
        this.fRenewalIntervalMillis = Math.min(l2, l);
        this.fStorage = workUnitStorage;
        this.fRegistrationAuthority = registrationAuthority;
        this.fJobRunner = jobRunner;
        this.registerBusyWorkersAfterRecovery(uuidArray);
    }

    static synchronized void create(long l, long l2, WorkUnitStorage workUnitStorage, Uuid[] uuidArray, RegistrationAuthority registrationAuthority, ExporterFactory exporterFactory, JobRunner jobRunner, boolean bl) throws ExportException, MJSException {
        assert (sWorkerPool == null) : "Worker Pool singleton cannot be created twice.";
        WorkerPool workerPool = new WorkerPool(l, l2, workUnitStorage, uuidArray, registrationAuthority, exporterFactory, jobRunner, bl);
        workerPool.init();
        sWorkerPool = workerPool;
    }

    static synchronized void destroy() {
        assert (sWorkerPool != null) : "Cannot destroy uninitialized singleton.";
        WorkerPool.sWorkerPool.fWorkerTaskCanceller.shutdown();
        WorkerTimeoutChecker.stopWorkerTimeoutChecker();
        sWorkerPool = null;
    }

    public static WorkerPool instance() {
        return sWorkerPool;
    }

    private TimeProvider getTimeProvider() {
        return this.fTimeProvider;
    }

    public void setTimeProvider(TimeProvider timeProvider) {
        this.fTimeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long registerAsIdle(Worker worker) throws RegistrationAuthority.RegistrationFailedException {
        WorkerProxy workerProxy = (WorkerProxy)worker;
        Uuid uuid = workerProxy.getID();
        String string = String.format("worker %s on computer %s", workerProxy.getName(), workerProxy.getHostName());
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Idle registration received from " + string);
        WorkerTaskInfo workerTaskInfo = null;
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            WorkerReg workerReg;
            if (!this.fIdleWorkers.containsKey(uuid) && !this.fBusyWorkers.containsKey(uuid)) {
                this.authoriseRegistration(workerProxy, string);
                this.printWorkerRegistrationMessage(workerProxy);
            }
            if (this.fBusyWorkers.containsKey(uuid)) {
                workerReg = this.fBusyWorkers.remove(uuid);
                workerTaskInfo = ((BusyWorkerReg)workerReg).areJobAndTaskValid() ? ((BusyWorkerReg)workerReg).getWorkerTaskInfo() : null;
            }
            workerReg = new IdleWorkerReg(workerProxy);
            this.fIdleWorkers.put(uuid, (IdleWorkerReg)workerReg);
        }
        if (workerTaskInfo != null) {
            try {
                this.cancelTask(workerTaskInfo, WORKER_BECAME_IDLE_MESSAGE, SendMessage.No);
            }
            catch (MJSException mJSException) {
                throw new RegistrationAuthority.RegistrationFailedException(mJSException);
            }
        }
        this.fJobRunner.workerIsIdle();
        return this.fRenewalIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long registerAsBusy(WorkerTaskInfo workerTaskInfo) throws RegistrationAuthority.RegistrationFailedException {
        WorkerProxy workerProxy = (WorkerProxy)workerTaskInfo.getWorker();
        Uuid uuid = workerProxy.getID();
        String string = String.format("worker %s on computer %s", workerProxy.getName(), workerProxy.getHostName());
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Busy registration received from " + string);
        boolean bl = false;
        Distcomp distcomp = this;
        synchronized (distcomp) {
            if (this.fIdleWorkers.containsKey(uuid)) {
                return this.fRenewalIntervalMillis;
            }
            if (this.fBusyWorkers.containsKey(uuid)) {
                BusyWorkerReg busyWorkerReg = new BusyWorkerReg(workerTaskInfo);
                this.fBusyWorkers.put(uuid, busyWorkerReg);
                bl = true;
            } else {
                this.authoriseRegistration(workerProxy, string);
            }
        }
        if (bl) {
            try {
                distcomp = (TaskImpl)this.fStorage.readWorkUnit(workerTaskInfo.getTaskID());
                if (((WorkUnitImpl)distcomp).getState() != 3) {
                    return this.fRenewalIntervalMillis;
                }
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
            }
            catch (StorageException storageException) {
                throw new RegistrationAuthority.RegistrationFailedException(storageException);
            }
        }
        this.cancelTaskOnWorker(workerTaskInfo);
        return this.fRenewalIntervalMillis;
    }

    private void authoriseRegistration(WorkerProxy workerProxy, String string) throws RegistrationAuthority.RegistrationFailedException {
        try {
            this.fRegistrationAuthority.authoriseRegistration(workerProxy);
        }
        catch (RegistrationAuthority.RegistrationFailedException registrationFailedException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Cannot register " + string + ". Reason: " + registrationFailedException.getMessage());
            throw registrationFailedException;
        }
        catch (RemoteException remoteException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to register worker due to connection problems." + remoteException.getMessage());
            throw new RegistrationAuthority.RecoverableRegistrationFailedException(remoteException);
        }
    }

    public void cancelTaskOnWorker(WorkerTaskInfo workerTaskInfo) {
        assert (workerTaskInfo != null) : "info was null";
        this.fWorkerTaskCanceller.execute(new WorkerTaskCancellation(workerTaskInfo));
    }

    synchronized int getNumBusyWorkers() {
        return this.fBusyWorkers.size();
    }

    synchronized Worker[] getBusyWorkers() {
        return this.getWorkerArray(this.fBusyWorkers);
    }

    synchronized int getNumIdleWorkers() {
        return this.fIdleWorkers.size();
    }

    synchronized Worker[] getIdleWorkers() {
        return this.getWorkerArray(this.fIdleWorkers);
    }

    synchronized Worker[][] getIdleAndBusyWorkers() {
        Worker[] workerArray = this.getIdleWorkers();
        Worker[] workerArray2 = this.getBusyWorkers();
        return new Worker[][]{workerArray, workerArray2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerProperties[] getIdleWorkerProperties() {
        WorkerProperties[] workerPropertiesArray = this;
        synchronized (this) {
            ArrayList<IdleWorkerReg> arrayList = new ArrayList<IdleWorkerReg>(this.fIdleWorkers.values());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            workerPropertiesArray = new WorkerProperties[arrayList.size()];
            int n = 0;
            for (IdleWorkerReg idleWorkerReg : arrayList) {
                workerPropertiesArray[n++] = idleWorkerReg.getWorker().getWorkerProperties();
            }
            Arrays.sort(workerPropertiesArray, new SimpleWorkerPropertiesNameComparator());
            return workerPropertiesArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerProperties[] getBusyWorkerProperties() {
        WorkerProperties[] workerPropertiesArray = this;
        synchronized (this) {
            ArrayList<BusyWorkerReg> arrayList = new ArrayList<BusyWorkerReg>(this.fBusyWorkers.values());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            workerPropertiesArray = new WorkerProperties[arrayList.size()];
            int n = 0;
            for (BusyWorkerReg busyWorkerReg : arrayList) {
                workerPropertiesArray[n++] = busyWorkerReg.getWorker().getWorkerProperties();
            }
            Arrays.sort(workerPropertiesArray, new SimpleWorkerPropertiesNameComparator());
            return workerPropertiesArray;
        }
    }

    synchronized int getNumBusyWorkersForJob(Uuid uuid) {
        int n = 0;
        Collection<BusyWorkerReg> collection = this.fBusyWorkers.values();
        for (BusyWorkerReg busyWorkerReg : collection) {
            BusyWorkerReg busyWorkerReg2 = busyWorkerReg;
            if (!busyWorkerReg2.getJobID().equals((Object)uuid)) continue;
            ++n;
        }
        return n;
    }

    synchronized Worker[] getAllWorkersOrderedByName() {
        WorkerProxy[] workerProxyArray = this.getWorkerArray(this.fIdleWorkers);
        WorkerProxy[] workerProxyArray2 = this.getWorkerArray(this.fBusyWorkers);
        Worker[] workerArray = new WorkerProxy[workerProxyArray.length + workerProxyArray2.length];
        System.arraycopy(workerProxyArray, 0, workerArray, 0, workerProxyArray.length);
        System.arraycopy(workerProxyArray2, 0, workerArray, workerProxyArray.length, workerProxyArray2.length);
        Arrays.sort(workerArray, new NameComparator());
        return workerArray;
    }

    synchronized WorkerProxy taskDispatchBegun(Uuid uuid) {
        WorkerProxy workerProxy = null;
        if (this.fIdleWorkers.containsKey(uuid)) {
            IdleWorkerReg idleWorkerReg = this.fIdleWorkers.get(uuid);
            workerProxy = idleWorkerReg.getWorker();
            this.fDispatchInProgressWorkerIDs.add(uuid);
        }
        return workerProxy;
    }

    synchronized void returnWorkerToIdle(Uuid uuid) {
        if (this.fDispatchInProgressWorkerIDs.contains(uuid)) {
            this.fDispatchInProgressWorkerIDs.remove(uuid);
        }
    }

    synchronized void taskDispatchFailed(Uuid uuid) {
        if (this.fIdleWorkers.containsKey(uuid)) {
            IdleWorkerReg idleWorkerReg = this.fIdleWorkers.get(uuid);
            this.printLostContactWithWorkerMessage(idleWorkerReg.getWorker());
            this.fIdleWorkers.remove(uuid);
        }
        if (this.fDispatchInProgressWorkerIDs.contains(uuid)) {
            this.fDispatchInProgressWorkerIDs.remove(uuid);
        }
    }

    synchronized void taskDispatchFailedForAbnormallyFinishedTask(Uuid uuid, JobAndTaskIdentifier jobAndTaskIdentifier) {
        this.taskDispatchSucceeded(uuid, jobAndTaskIdentifier);
    }

    synchronized void taskDispatchSucceeded(Uuid uuid, JobAndTaskIdentifier jobAndTaskIdentifier) {
        if (this.fDispatchInProgressWorkerIDs.contains(uuid)) {
            this.fDispatchInProgressWorkerIDs.remove(uuid);
            if (this.fIdleWorkers.containsKey(uuid)) {
                IdleWorkerReg idleWorkerReg = this.fIdleWorkers.remove(uuid);
                WorkerTaskInfo workerTaskInfo = new WorkerTaskInfo(idleWorkerReg.getWorker(), jobAndTaskIdentifier);
                BusyWorkerReg busyWorkerReg = new BusyWorkerReg(workerTaskInfo);
                this.fBusyWorkers.put(uuid, busyWorkerReg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorker(Uuid uuid) throws MJSException {
        WorkerTaskInfo workerTaskInfo = null;
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            BusyWorkerReg busyWorkerReg;
            IdleWorkerReg idleWorkerReg = this.fIdleWorkers.remove(uuid);
            if (idleWorkerReg != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Removing idle worker " + idleWorkerReg.getWorker().getName() + " from worker pool.");
            }
            if ((busyWorkerReg = this.fBusyWorkers.remove(uuid)) != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Removing busy worker " + busyWorkerReg.getWorker().getName() + " from worker pool.");
                workerTaskInfo = busyWorkerReg.areJobAndTaskValid() ? busyWorkerReg.getWorkerTaskInfo() : null;
            }
        }
        if (workerTaskInfo != null) {
            this.cancelTask(workerTaskInfo, WORKER_WAS_REMOVED, SendMessage.No);
        }
    }

    public synchronized void removeTaskFromWorker(WorkerTaskInfo workerTaskInfo) {
        Uuid uuid = ((WorkerProxy)workerTaskInfo.getWorker()).getID();
        BusyWorkerReg busyWorkerReg = this.fBusyWorkers.get(uuid);
        if (busyWorkerReg != null) {
            busyWorkerReg.invalidateJobAndTask();
            this.cancelTaskOnWorker(workerTaskInfo);
        }
    }

    WorkerRegistration getStub() {
        return this.fStub;
    }

    private void init() throws ExportException {
        NamedThreadFactory namedThreadFactory = NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fWorkerTaskCanceller-"), (Logger)PackageInfo.LOGGER);
        this.fWorkerTaskCanceller = new ThreadPoolExecutor(1, 5, 200L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)namedThreadFactory);
        WorkerTimeoutChecker.startWorkerTimeoutChecker(this);
        this.exportWorkerRegistration();
    }

    private WorkerProxy[] getWorkerArray(HashMap hashMap) {
        Collection collection = hashMap.values();
        WorkerProxy[] workerProxyArray = new WorkerProxy[collection.size()];
        int n = 0;
        for (Object v : collection) {
            WorkerReg workerReg = (WorkerReg)v;
            workerProxyArray[n++] = workerReg.getWorker();
        }
        Arrays.sort(workerProxyArray, new NameComparator());
        return workerProxyArray;
    }

    private void printWorkerRegistrationMessage(WorkerProxy workerProxy) {
        if (!this.fUnitTesting) {
            NodeLocationMessage nodeLocationMessage = new NodeLocationMessage();
            System.out.println("\nWORKER REGISTERED WITH JOB MANAGER:\n" + nodeLocationMessage.workerLocationMessage(workerProxy.getName(), workerProxy.getHostName(), workerProxy.getAllHostAddresses()) + "\n");
        }
    }

    private void printLostContactWithWorkerMessage(WorkerProxy workerProxy) {
        if (!this.fUnitTesting) {
            NodeLocationMessage nodeLocationMessage = new NodeLocationMessage();
            System.out.println("\nJOB MANAGER LOST CONTACT WITH WORKER:\n" + nodeLocationMessage.workerLocationMessage(workerProxy.getName(), workerProxy.getHostName(), workerProxy.getAllHostAddresses()) + "\n");
        }
    }

    private void exportWorkerRegistration() throws ExportException {
        Exporter exporter = this.fExporterFactory.createExporter();
        this.fStub = (WorkerRegistration)exporter.export(this);
    }

    private synchronized void registerBusyWorkersAfterRecovery(Uuid[] uuidArray) throws StorageException {
        for (Uuid uuid : uuidArray) {
            try {
                TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
                WorkerProxy workerProxy = (WorkerProxy)taskImpl.getWorker();
                BusyWorkerReg busyWorkerReg = new BusyWorkerReg(taskImpl.getWorkerTaskInfo());
                this.fBusyWorkers.put(workerProxy.getID(), busyWorkerReg);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                // empty catch block
            }
        }
    }

    private void cancelTask(WorkerTaskInfo workerTaskInfo, String string, SendMessage sendMessage) throws MJSException {
        Uuid uuid = workerTaskInfo.getTaskID();
        boolean bl = sendMessage == SendMessage.Yes;
        try {
            TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
            NodeLocationMessage nodeLocationMessage = new NodeLocationMessage();
            WorkerProxy workerProxy = (WorkerProxy)workerTaskInfo.getWorker();
            string = string + "\n" + nodeLocationMessage.workerLocationMessage(workerProxy.getName(), workerProxy.getHostName(), workerProxy.getAllHostAddresses());
            taskImpl.rerunOrCancel(new UserDefinedCancelMessage(string), bl);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            // empty catch block
        }
    }

    private static class SimpleWorkerPropertiesNameComparator
    implements Comparator<WorkerProperties>,
    Serializable {
        private SimpleWorkerPropertiesNameComparator() {
        }

        @Override
        public int compare(WorkerProperties workerProperties, WorkerProperties workerProperties2) {
            String string = workerProperties == null ? "" : workerProperties.getName();
            String string2 = workerProperties2 == null ? "" : workerProperties2.getName();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }

    private static class NameComparator
    implements Comparator<WorkerProxy>,
    Serializable {
        private NameComparator() {
        }

        @Override
        public int compare(WorkerProxy workerProxy, WorkerProxy workerProxy2) {
            String string = workerProxy == null ? "" : workerProxy.getName();
            String string2 = workerProxy2 == null ? "" : workerProxy2.getName();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }

    private static class WorkerTaskCancellation
    implements Runnable {
        private WorkerTaskInfo iWorkerTaskInfo;

        protected WorkerTaskCancellation(WorkerTaskInfo workerTaskInfo) {
            this.iWorkerTaskInfo = workerTaskInfo;
        }

        @Override
        public void run() {
            TaskAttemptIdentifier taskAttemptIdentifier = this.iWorkerTaskInfo.getTaskAttemptIdentifier();
            Worker worker = this.iWorkerTaskInfo.getWorker();
            try {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending cancellation message to worker " + worker.getName() + " on computer " + worker.getHostName() + " " + taskAttemptIdentifier);
                worker.cancelRunningTask(taskAttemptIdentifier);
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sent cancellation message to worker " + worker.getName() + " on computer " + worker.getHostName() + " " + taskAttemptIdentifier);
            }
            catch (RemoteException remoteException) {
                StackTraceElement[] stackTraceElementArray;
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Cancellation message to worker was not sent because " + remoteException.getMessage());
                for (StackTraceElement stackTraceElement : stackTraceElementArray = remoteException.getStackTrace()) {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, stackTraceElement.toString());
                }
            }
        }
    }

    private static final class WorkerTimeoutChecker
    extends Thread {
        private static WorkerTimeoutChecker sWorkerTimeoutChecker = null;
        private final WorkerPool iWorkerPool;
        private boolean iTerminateForUnitTests = false;

        private WorkerTimeoutChecker(WorkerPool workerPool) {
            this.iWorkerPool = workerPool;
        }

        private static synchronized void startWorkerTimeoutChecker(WorkerPool workerPool) {
            if (sWorkerTimeoutChecker == null) {
                sWorkerTimeoutChecker = new WorkerTimeoutChecker(workerPool);
                sWorkerTimeoutChecker.start();
            }
        }

        private static synchronized void stopWorkerTimeoutChecker() {
            sWorkerTimeoutChecker.terminate();
            try {
                sWorkerTimeoutChecker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sWorkerTimeoutChecker = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                long l = this.iWorkerPool.fTimeoutMillis;
                Vector<WorkerTaskInfo> vector = new Vector<WorkerTaskInfo>();
                Object object = this.iWorkerPool;
                synchronized (object) {
                    if (this.iTerminateForUnitTests) {
                        break;
                    }
                    long l2 = this.iWorkerPool.getTimeProvider().currentTimeMillis();
                    Collection collection = this.iWorkerPool.fIdleWorkers.values();
                    long l3 = this.removeExpiredRegistrations(l2, collection, vector);
                    Collection collection2 = this.iWorkerPool.fBusyWorkers.values();
                    long l4 = this.removeExpiredRegistrations(l2, collection2, vector);
                    long l5 = Math.min(l3, l4);
                    l = Math.min(l, l5);
                    if (vector.isEmpty()) {
                        try {
                            this.iWorkerPool.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                object = vector.iterator();
                while (true) {
                    if (!object.hasNext()) continue block7;
                    WorkerTaskInfo workerTaskInfo = (WorkerTaskInfo)object.next();
                    try {
                        this.iWorkerPool.cancelTask(workerTaskInfo, WorkerPool.CONTACT_LOST_MESSAGE, SendMessage.No);
                    }
                    catch (MJSException mJSException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "Failed to cancel tasks on worker timeout.", mJSException);
                    }
                    Thread thread = new Thread(new WorkerTaskCancellation(workerTaskInfo));
                    thread.setDaemon(true);
                    thread.start();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            WorkerPool workerPool = this.iWorkerPool;
            synchronized (workerPool) {
                this.iTerminateForUnitTests = true;
                this.iWorkerPool.notifyAll();
            }
        }

        private long removeExpiredRegistrations(long l, Collection collection, Vector<WorkerTaskInfo> vector) {
            long l2 = this.iWorkerPool.fTimeoutMillis;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                WorkerReg workerReg;
                try {
                    workerReg = (WorkerReg)iterator.next();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (workerReg.isExpired(l)) {
                    try {
                        if (workerReg instanceof BusyWorkerReg) {
                            vector.add(((BusyWorkerReg)workerReg).getWorkerTaskInfo());
                        }
                        iterator.remove();
                        this.iWorkerPool.printLostContactWithWorkerMessage(workerReg.getWorker());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                    continue;
                }
                long l3 = workerReg.iTimeLastRenewed + this.iWorkerPool.fTimeoutMillis - l;
                l3 = Math.max(l3, 1L);
                l2 = Math.min(l2, l3);
            }
            return l2;
        }
    }

    private class BusyWorkerReg
    extends WorkerReg {
        private JobAndTaskIdentifier iJobAndTask;

        private BusyWorkerReg(WorkerTaskInfo workerTaskInfo) {
            super((WorkerProxy)workerTaskInfo.getWorker());
            this.iJobAndTask = workerTaskInfo.getJobAndTaskIdentifier();
        }

        protected Uuid getJobID() {
            return this.iJobAndTask.getJobID();
        }

        protected JobAndTaskIdentifier getJobAndTask() {
            return this.iJobAndTask;
        }

        protected WorkerTaskInfo getWorkerTaskInfo() {
            return new WorkerTaskInfo(this.getWorker(), this.iJobAndTask);
        }

        protected boolean areJobAndTaskValid() {
            return this.iJobAndTask.areValid();
        }

        protected void invalidateJobAndTask() {
            this.iJobAndTask = new JobAndTaskIdentifier();
        }
    }

    private class IdleWorkerReg
    extends WorkerReg {
        private IdleWorkerReg(WorkerProxy workerProxy) {
            super(workerProxy);
        }
    }

    private abstract class WorkerReg {
        protected WorkerProxy iWorker;
        protected long iTimeLastRenewed;

        protected WorkerReg(WorkerProxy workerProxy) {
            this.iWorker = workerProxy;
            this.iTimeLastRenewed = WorkerPool.this.fTimeProvider.currentTimeMillis();
        }

        protected WorkerProxy getWorker() {
            return this.iWorker;
        }

        protected boolean isExpired(long l) {
            long l2 = l - this.iTimeLastRenewed;
            return l2 > WorkerPool.this.fTimeoutMillis;
        }
    }

    private static enum SendMessage {
        No,
        Yes;

    }
}

