/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager.statenotification;

import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.NotificationFailedException;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.NotificationSender;
import com.mathworks.toolbox.distcomp.process.CommandLine;
import com.mathworks.toolbox.distcomp.process.InvalidUserOrPasswordException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.apache.commons.io.output.TeeOutputStream;

public final class ScriptNotificationSender
implements NotificationSender {
    private final File fBusyScript;
    private final File fIdleScript;
    private final OutputStream fOutputStream;

    public ScriptNotificationSender(File file, File file2) {
        this.fBusyScript = file;
        this.fIdleScript = file2;
        this.checkScriptLocations();
        this.fOutputStream = null;
    }

    public ScriptNotificationSender(File file, File file2, OutputStream outputStream) {
        this.fBusyScript = file;
        this.fIdleScript = file2;
        this.checkScriptLocations();
        this.fOutputStream = outputStream;
    }

    @Override
    public void sendBusyNotification() throws InterruptedException, NotificationFailedException {
        this.runScript(this.fBusyScript);
    }

    @Override
    public void sendIdleNotification() throws InterruptedException, NotificationFailedException {
        this.runScript(this.fIdleScript);
    }

    private void checkScriptLocations() {
        if (!this.fBusyScript.exists()) {
            throw new IllegalStateException("Busy notification script does not exist in the script root. Busy script should be: " + this.fBusyScript);
        }
        if (!this.fIdleScript.exists()) {
            throw new IllegalStateException("Idle notification script does not exist in the script root. Idle script should be: " + this.fIdleScript);
        }
    }

    private void runScript(File file) throws InterruptedException, NotificationFailedException {
        CommandLine commandLine = new CommandLine(file.toString());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = this.fOutputStream != null ? new TeeOutputStream((OutputStream)byteArrayOutputStream, this.fOutputStream) : byteArrayOutputStream;
        try {
            commandLine.redirectOutput(byteArrayOutputStream2);
            Process process = commandLine.start();
            int n = process.waitFor();
            if (n != 0) {
                PackageInfo.LOGGER.log(Level.WARNING, "Failed to run script: " + file + ". Error code: " + n);
                throw new NotificationFailedException("Failed to run script: " + file + ". Error code: " + n);
            }
            PackageInfo.LOGGER.log(Level.FINER, "Output of " + file + ": " + ScriptNotificationSender.getOutput(byteArrayOutputStream));
        }
        catch (InvalidUserOrPasswordException | IOException exception) {
            PackageInfo.LOGGER.log(Level.WARNING, "Failed to run script: " + file, exception);
            throw new NotificationFailedException("Failed to run script: " + file, exception);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.WARNING, "Failed to close script logging output stream.", iOException);
            }
        }
    }

    private static String getOutput(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            return byteArrayOutputStream.toString(Charset.defaultCharset().name()).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Default charset not recognized", unsupportedEncodingException);
        }
    }
}

