/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.pml.ParallelJobSetupInfo;
import com.mathworks.toolbox.distcomp.pml.SimultaneousTasksJob;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import java.rmi.RemoteException;
import net.jini.id.Uuid;
import org.jetbrains.annotations.NotNull;

public class GDSClientSimultaneousTasksJobAccess
extends GDSClientJobAccess
implements ReadOnlyClientSimultaneousTasksJobAccess {
    private DatabaseStorage fDatabaseStorage;

    public GDSClientSimultaneousTasksJobAccess(DatabaseStorage databaseStorage) {
        super(databaseStorage);
        this.fDatabaseStorage = databaseStorage;
    }

    @Override
    public ParallelJobSetupInfo[] getParallelJobSetupInfo(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        ParallelJobSetupInfo[] parallelJobSetupInfoArray = new ParallelJobSetupInfo[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            SimultaneousTasksJob simultaneousTasksJob = (SimultaneousTasksJob)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            parallelJobSetupInfoArray[i] = simultaneousTasksJob.getParallelJobSetupInfo();
        }
        return parallelJobSetupInfoArray;
    }

    @Override
    public boolean[] isLeadingTask(@NotNull Uuid[] uuidArray, @NotNull Uuid[] uuidArray2) throws RemoteException, MJSException {
        assert (uuidArray.length == uuidArray2.length) : "Number of task IDs and job IDs do not match.";
        boolean[] blArray = new boolean[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            SimultaneousTasksJob simultaneousTasksJob = (SimultaneousTasksJob)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            blArray[i] = simultaneousTasksJob.isLeadingTask(uuidArray2[i]);
        }
        return blArray;
    }

    @Override
    public int[] getNumLabs(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            SimultaneousTasksJob simultaneousTasksJob = (SimultaneousTasksJob)((Object)this.fDatabaseStorage.readWorkUnit(uuidArray[i]));
            nArray[i] = simultaneousTasksJob.getNumLabs();
        }
        return nArray;
    }
}

