/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.GDSClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyJobManagerClient;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorageWithWorkUnitInitializer;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInitializer;
import java.rmi.RemoteException;

public class GDSJobManagerClient
implements ReadOnlyJobManagerClient {
    private final DatabaseStorage fDatabaseStorage;

    public GDSJobManagerClient(DatabaseStorage databaseStorage) {
        WorkUnitInitializer workUnitInitializer = new WorkUnitInitializer();
        workUnitInitializer.setJobStorage(databaseStorage).setTaskStorage(databaseStorage).setLargeDataStorage(databaseStorage).setAppendableDataStorage(databaseStorage);
        this.fDatabaseStorage = new DatabaseStorageWithWorkUnitInitializer(databaseStorage, workUnitInitializer);
    }

    @Override
    public JobIDAndMLType[] getJobs() throws RemoteException, StorageException {
        return this.fDatabaseStorage.readJobsAndTypes();
    }

    @Override
    public JobIDAndMLType[][] getJobs(int[] nArray) throws RemoteException, StorageException {
        return this.fDatabaseStorage.readJobsAndTypesByState(nArray);
    }

    @Override
    public ReadOnlyClientJobAccess getReadOnlyJobAccess() throws RemoteException, MJSException {
        return new GDSClientJobAccess(this.fDatabaseStorage);
    }

    @Override
    public ReadOnlyClientTaskAccess getReadOnlyTaskAccess() throws RemoteException, MJSException {
        return new GDSClientTaskAccess(this.fDatabaseStorage);
    }

    @Override
    public ReadOnlyClientSimultaneousTasksJobAccess getReadOnlySimultaneousTasksJobAccess() throws RemoteException, MJSException {
        return new GDSClientSimultaneousTasksJobAccess(this.fDatabaseStorage);
    }

    @Override
    public void dispose() throws RemoteException, MJSException {
    }

    @Override
    public String getName() throws RemoteException {
        return "cloud";
    }

    @Override
    public boolean requireWebLicensing() throws RemoteException {
        return true;
    }

    @Override
    public void updateStorageCredentials(UserCredentials userCredentials) throws MJSException, RemoteException {
        this.fDatabaseStorage.updateCredentials(userCredentials);
    }
}

