/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteArrayItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.CallerDataStoreExceededException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.Log;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.workunit.DataAccessor;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class DataStoreBackedDataSender<T> {
    private final DataStore fDataStore;
    private final long fMinTransferUsingDataStore;
    private long fReturnValDirectSize = 0L;
    private long fReturnValInDataStoreSize = 0L;
    private long fDataStoreSize;
    private static final int MAX_TRANSFER_ATTEMPTS = 20;

    public DataStoreBackedDataSender(DataStore dataStore, long l) {
        this.fDataStore = dataStore;
        this.fMinTransferUsingDataStore = l;
    }

    public TransferableData[][] transferData(List<T> list, List<DataAccessor<T>> list2) throws MJSException {
        DataNotFoundException dataNotFoundException = null;
        for (int i = 0; i < 20; ++i) {
            try {
                return this.doTransferForMultipleFields(list, list2);
            }
            catch (DataNotFoundException dataNotFoundException2) {
                Log.LOGGER.log(Level.FINE, "Unexpected failure to transfer data from storage to the data store, retrying.", dataNotFoundException2);
                dataNotFoundException = dataNotFoundException2;
                continue;
            }
        }
        throw dataNotFoundException;
    }

    private TransferableData[][] doTransferForMultipleFields(List<T> list, List<DataAccessor<T>> list2) throws MJSException {
        int n = list.size();
        TransferableData[][] transferableDataArray = new TransferableData[n][list2.size()];
        this.fReturnValDirectSize = 0L;
        this.fReturnValInDataStoreSize = 0L;
        try {
            this.fDataStoreSize = this.fDataStore.getDataStoreSize();
        }
        catch (RemoteException remoteException) {
            throw new DataStoreException("Failed to get the data store size", remoteException);
        }
        for (int i = 0; i < n; ++i) {
            transferableDataArray[i] = this.readItems(list.get(i), list2);
        }
        return transferableDataArray;
    }

    public TransferableData[] transferData(List<T> list, DataAccessor<T> dataAccessor) throws MJSException {
        DataNotFoundException dataNotFoundException = null;
        for (int i = 0; i < 20; ++i) {
            try {
                return this.doTransferForSingleField(list, dataAccessor);
            }
            catch (DataNotFoundException dataNotFoundException2) {
                Log.LOGGER.log(Level.FINE, "Unexpected failure to transfer data from storage to the data store, retrying.", dataNotFoundException2);
                dataNotFoundException = dataNotFoundException2;
                continue;
            }
        }
        throw dataNotFoundException;
    }

    private TransferableData[] doTransferForSingleField(List<T> list, DataAccessor<T> dataAccessor) throws MJSException {
        int n = list.size();
        TransferableData[] transferableDataArray = new TransferableData[n];
        ArrayList<DataAccessor<T>> arrayList = new ArrayList<DataAccessor<T>>(1);
        arrayList.add(dataAccessor);
        this.fReturnValDirectSize = 0L;
        this.fReturnValInDataStoreSize = 0L;
        try {
            this.fDataStoreSize = this.fDataStore.getDataStoreSize();
        }
        catch (RemoteException remoteException) {
            throw new DataStoreException("Failed to get the data store size", remoteException);
        }
        for (int i = 0; i < n; ++i) {
            transferableDataArray[i] = this.readItems(list.get(i), arrayList)[0];
        }
        return transferableDataArray;
    }

    private TransferableData[] readItems(T t, List<DataAccessor<T>> list) throws MJSException {
        int n = list.size();
        LargeData[] largeDataArray = new TransferableData[n];
        try {
            for (int i = 0; i < n; ++i) {
                TransferableData transferableData;
                DataAccessor<T> dataAccessor = list.get(i);
                dataAccessor.doCredentialCheck(t);
                int n2 = dataAccessor.getDataSize(t);
                if (this.fReturnValDirectSize + (long)n2 < this.fMinTransferUsingDataStore) {
                    this.fReturnValDirectSize += (long)n2;
                    Log.LOGGER.log(DistcompLevel.SIX, "Getting data direct for item of size: " + n2);
                    byte[] byArray = dataAccessor.getDataDirect(t);
                    transferableData = new ByteArrayItem(byArray);
                } else if (this.fReturnValInDataStoreSize + (long)n2 <= this.fDataStoreSize) {
                    this.fReturnValInDataStoreSize += (long)n2;
                    Log.LOGGER.log(DistcompLevel.SIX, "Streaming data via data store for item of size: " + n2);
                    transferableData = this.streamToDataStore(t, dataAccessor, n2);
                } else {
                    long l = this.fReturnValInDataStoreSize + (long)n2;
                    DataStoreBackedDataSender.cleanDataStore(this.fDataStore, largeDataArray);
                    Log.LOGGER.log(DistcompLevel.ONE, "too much data for data store, size of data: " + l + ", size of data store: " + this.fDataStoreSize);
                    throw new CallerDataStoreExceededException("Cannot put " + l + " bytes in a data store of size " + this.fDataStoreSize);
                }
                largeDataArray[i] = transferableData;
            }
        }
        catch (DataNotFoundException dataNotFoundException) {
            DataStoreBackedDataSender.cleanDataStore(this.fDataStore, largeDataArray);
            throw dataNotFoundException;
        }
        return largeDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStoreItem streamToDataStore(T t, DataAccessor<T> dataAccessor, int n) throws MJSException {
        DataStoreItem dataStoreItem = new DataStoreItem(n, this.fDataStore);
        OutputStream outputStream = null;
        try {
            outputStream = dataStoreItem.getOutputStream();
            dataAccessor.getDataViaStream(t, outputStream, n);
            DataStoreItem dataStoreItem2 = dataStoreItem;
            return dataStoreItem2;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.warning("Failed to close DataStoreOutputStream");
                }
            }
        }
    }

    private static void cleanDataStore(DataStore dataStore, LargeData[] largeDataArray) throws DataStoreException {
        Vector<DataStoreItem> vector = new Vector<DataStoreItem>();
        for (LargeData largeData : largeDataArray) {
            if (!(largeData instanceof DataStoreItem)) continue;
            vector.add((DataStoreItem)largeData);
        }
        try {
            dataStore.remove(vector.toArray(new DataStoreItem[0]));
        }
        catch (RemoteException remoteException) {
            throw new DataStoreException("The job manager was unable to contact the client/worker computer", remoteException);
        }
    }
}

