/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteArrayItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteBufferItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreImpl;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreProxy;
import com.mathworks.toolbox.distcomp.mjs.datastore.InvocationWithDataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.Log;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.service.Exporter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.logging.Level;

public class LargeDataInvoker
implements Serializable {
    private transient DataStoreImpl fStore;
    private static long sDesiredDataStoreSize = -1L;
    private static transient int sBytesInVMHeap;
    private long fMinTransferUsingDataStore;

    public LargeDataInvoker(long l, long l2, Exporter exporter) throws ExportException {
        this.fMinTransferUsingDataStore = l2;
        this.createDataStore(l, exporter);
    }

    private void createDataStore(long l, Exporter exporter) throws ExportException {
        this.fStore = new DataStoreImpl(l, exporter, this.fMinTransferUsingDataStore);
    }

    private DataStoreImpl getDataStore() {
        if (this.fStore == null) {
            Log.LOGGER.log(Level.SEVERE, "Datastore is null, this LargeDataInvoker has been disposed. LargeDataInvoker: " + this.toString());
            throw new IllegalStateException("Cannot use LargeDataInvoker after it has been disposed");
        }
        return this.fStore;
    }

    public TransferableData[] putLargeInputsInDataStore(LargeData[] largeDataArray) throws DataStoreException {
        this.clearDataStore();
        return this.appendLargeInputsToDataStore(largeDataArray);
    }

    public void clearDataStore() {
        sBytesInVMHeap = 0;
        this.getDataStore().clearData();
    }

    public TransferableData[] appendLargeInputsToDataStore(LargeData[] largeDataArray) throws DataStoreException {
        TransferableData[] transferableDataArray = new TransferableData[largeDataArray.length];
        int n = -1;
        for (LargeData largeData : largeDataArray) {
            ++n;
            if (largeData == null) continue;
            long l = largeData.getNumBytes();
            if ((long)sBytesInVMHeap + l < this.getDataStoreMinLimit()) {
                sBytesInVMHeap = (int)((long)sBytesInVMHeap + l);
                transferableDataArray[n] = this.convertLargeDataItemToByteArrayItem(largeData);
                continue;
            }
            transferableDataArray[n] = this.convertLargeDataItemToDataStoreItem(largeData);
        }
        return transferableDataArray;
    }

    public LargeData[] getLargeOutputsFromDataStore(LargeData[] largeDataArray) {
        LargeData[] largeDataArray2 = new LargeData[largeDataArray.length];
        int n = -1;
        for (LargeData largeData : largeDataArray) {
            ++n;
            try {
                largeDataArray2[n] = this.convertLargeDataItemToByteBufferItem(largeData);
            }
            catch (DataStoreException dataStoreException) {
                assert (false) : "DataStoreException thrown on argument return - should not be possible\n" + dataStoreException;
            }
        }
        this.getDataStore().clearData();
        return largeDataArray2;
    }

    private ByteArrayItem convertLargeDataItemToByteArrayItem(LargeData largeData) throws DataStoreException {
        ByteArrayItem byteArrayItem;
        if (largeData instanceof ByteArrayItem) {
            return (ByteArrayItem)largeData;
        }
        if (largeData instanceof ByteBufferItem) {
            ByteBufferItem byteBufferItem = (ByteBufferItem)largeData;
            byteBufferItem.rewind();
            byte[] byArray = byteBufferItem.getData(byteBufferItem.getNumBytes());
            byteArrayItem = new ByteArrayItem(byArray);
        } else if (largeData instanceof DataStoreItem) {
            ByteBufferItem byteBufferItem = this.convertLargeDataItemToByteBufferItem(largeData);
            byteArrayItem = this.convertLargeDataItemToByteArrayItem(byteBufferItem);
        } else {
            throw new InvalidDataItemException("Invalid data type for DataStore");
        }
        return byteArrayItem;
    }

    private DataStoreItem convertLargeDataItemToDataStoreItem(LargeData largeData) throws DataStoreException {
        ByteBufferItem byteBufferItem;
        if (largeData instanceof DataStoreItem) {
            return (DataStoreItem)largeData;
        }
        if (largeData instanceof ByteBufferItem) {
            byteBufferItem = (ByteBufferItem)largeData;
        } else if (largeData instanceof ByteArrayItem) {
            byteBufferItem = this.convertLargeDataItemToByteBufferItem(largeData);
        } else {
            throw new InvalidDataItemException("Invalid data type for DataStore");
        }
        DataStoreItem dataStoreItem = this.getDataStore().putByteBufferItem(byteBufferItem);
        return dataStoreItem;
    }

    private ByteBufferItem convertLargeDataItemToByteBufferItem(LargeData largeData) throws DataStoreException {
        ByteBufferItem byteBufferItem;
        if (largeData instanceof ByteBufferItem) {
            return (ByteBufferItem)largeData;
        }
        if (largeData instanceof DataStoreItem) {
            byteBufferItem = this.getDataStore().getByteBufferItem((DataStoreItem)largeData);
        } else if (largeData instanceof ByteArrayItem) {
            byte[] byArray = ((ByteArrayItem)largeData).getData();
            byteBufferItem = new ByteBufferItem(byArray.length);
            byteBufferItem.putData(byArray);
        } else {
            throw new InvalidDataItemException("Invalid data type for DataStore");
        }
        return byteBufferItem;
    }

    public DataStoreProxy getDataStoreProxy() {
        return this.getDataStore().getProxy();
    }

    public long getDataStoreMinLimit() {
        return this.fMinTransferUsingDataStore;
    }

    public long getDataStoreSize() {
        return this.getDataStore().getDataStoreSize();
    }

    public int getDataStoreExportPort() {
        return this.getDataStore().getExportPort();
    }

    public void dispose() {
        if (this.fStore != null) {
            this.clearDataStore();
            this.fStore.unexport();
            this.fStore = null;
        }
    }

    public <T> T invokeWithDataStore(InvocationWithDataStore<T> invocationWithDataStore) throws RemoteException, MJSException {
        invocationWithDataStore.setDataStore(this.getDataStoreProxy());
        return invocationWithDataStore.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T setInvokeWithDataStore(InvocationWithDataStore<T> invocationWithDataStore) throws RemoteException, MJSException {
        try {
            T t = this.invokeWithDataStore(invocationWithDataStore);
            return t;
        }
        finally {
            this.getDataStore().clearData();
        }
    }

    public static void setDesiredDataStoreSize(long l) {
        sDesiredDataStoreSize = l;
    }

    public static long getDesiredDataStoreSize() {
        return sDesiredDataStoreSize;
    }

    public static LargeDataInvoker createLargeDataInvoker(long l, Exporter exporter) throws ExportException {
        long l2 = LargeDataInvoker.getDesiredDataStoreSize();
        if (l2 > 0L) {
            return new LargeDataInvoker(l2, l, exporter);
        }
        return null;
    }

    public static class InvalidDataItemException
    extends DataStoreException {
        InvalidDataItemException(String string) {
            super(string);
        }
    }
}

