/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.ClientOutputGroupFactory;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.LocalMethodInvocationHandler;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.RemoteMethodInvocationHandler;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.RemoteMethods;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public final class PeerRmiInvocationHandler
implements InvocationHandler,
Serializable {
    private static final String TAG = PeerRmiInvocationHandler.class.getSimpleName();
    private final InvocationHandler fRemoteMethodInvocationHandler;
    private final InvocationHandler fLocalMethodInvocationHandler;
    private final ObjectRegistry.ID fObjectId;
    private final Class<?>[] fRemoteInterfaces;
    private transient RemoteMethods fRemoteMethods;

    public PeerRmiInvocationHandler(ObjectRegistry.ID iD, Class<?>[] classArray, InvocationHandler invocationHandler) {
        this.fObjectId = iD;
        this.fRemoteInterfaces = classArray;
        this.fRemoteMethodInvocationHandler = invocationHandler;
        this.fLocalMethodInvocationHandler = new LocalMethodInvocationHandler();
    }

    public PeerRmiInvocationHandler(ObjectRegistry.ID iD, Class<?>[] classArray, Instance instance, ClientOutputGroupFactory clientOutputGroupFactory, long l) {
        Log.LOGGER.info(TAG + ": Creating invocation handler for object " + iD);
        this.fObjectId = iD;
        this.fRemoteInterfaces = classArray;
        this.fRemoteMethodInvocationHandler = new RemoteMethodInvocationHandler(iD, instance, clientOutputGroupFactory, l);
        this.fLocalMethodInvocationHandler = new LocalMethodInvocationHandler();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        assert (Proxy.isProxyClass(object.getClass())) : "First argument to invoke should be a proxy object";
        if (this.isRemoteMethod(method)) {
            Log.LOGGER.fine(TAG + ": Call to remote method " + method.getDeclaringClass().getSimpleName() + "." + method.getName());
            return this.fRemoteMethodInvocationHandler.invoke(object, method, objectArray);
        }
        Log.LOGGER.fine(TAG + ": Call to local method " + method.getDeclaringClass().getSimpleName() + "." + method.getName());
        return this.fLocalMethodInvocationHandler.invoke(object, method, objectArray);
    }

    private synchronized boolean isRemoteMethod(Method method) {
        if (this.fRemoteMethods == null) {
            this.fRemoteMethods = new RemoteMethods();
        }
        return this.fRemoteMethods.isRemoteMethod(method);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PeerRmiInvocationHandler peerRmiInvocationHandler = (PeerRmiInvocationHandler)object;
        return this.fObjectId.equals(peerRmiInvocationHandler.fObjectId);
    }

    public int hashCode() {
        return this.fObjectId.hashCode();
    }

    public String toString() {
        return "PeerRmiInvocationHandler{fRemoteInterfaces=" + (this.fRemoteInterfaces == null ? null : Arrays.asList(this.fRemoteInterfaces)) + ", fObjectId=" + this.fObjectId + ", fRemoteMethodInvocationHandler=" + this.fRemoteMethodInvocationHandler + ", fLocalMethodInvocationHandler=" + this.fLocalMethodInvocationHandler + '}';
    }
}

