/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.nativedmatlab;

import com.mathworks.toolbox.distcomp.nativedmatlab.ByteBuffAndKey;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FreeableDirectByteBuffer {
    private static final int MIN_ACCEPTABLE_BUFFER_SIZE = 8;
    private static ConcurrentHashMap<Long, WeakAndPhantomRefs> sBufAndKeyMap;
    private static PhantomReferenceReaper sRefReaper;

    private FreeableDirectByteBuffer() {
    }

    public static ByteBuffAndKey allocateFreeableDirect(int n) {
        if (n > 8) {
            ByteBuffer byteBuffer = FreeableDirectByteBuffer.nativeAllocateDirect(n);
            if (byteBuffer == null) {
                throw new OutOfMemoryError("Failed to allocate a direct ByteBuffer of size: " + n);
            }
            byteBuffer.position(0);
            long l = byteBuffer.getLong();
            byteBuffer.clear();
            ByteBuffAndKey byteBuffAndKey = new ByteBuffAndKey(byteBuffer, l, true);
            sBufAndKeyMap.put(l, new WeakAndPhantomRefs(byteBuffAndKey, sRefReaper.getRefQueue()));
            return byteBuffAndKey;
        }
        return new ByteBuffAndKey(ByteBuffer.allocateDirect(n), -1L, false);
    }

    static void freeByKey(long l) {
        ByteBuffAndKey byteBuffAndKey;
        WeakAndPhantomRefs weakAndPhantomRefs = sBufAndKeyMap.remove(l);
        if (weakAndPhantomRefs != null && (byteBuffAndKey = (ByteBuffAndKey)weakAndPhantomRefs.fWeak.get()) != null) {
            byteBuffAndKey.getBuffer().position(0).limit(0);
        }
        FreeableDirectByteBuffer.free(l);
    }

    public static void freeByBuffAndKey(ByteBuffAndKey byteBuffAndKey) {
        FreeableDirectByteBuffer.freeByKey(byteBuffAndKey.getKey());
    }

    static native boolean free(long var0);

    private static native ByteBuffer nativeAllocateDirect(int var0);

    private static native long memstats();

    public static native long bytesAllocated();

    public static void dumpStats() {
        for (Long l : sBufAndKeyMap.keySet()) {
            WeakAndPhantomRefs weakAndPhantomRefs = sBufAndKeyMap.get(l);
            System.out.println("Key: " + l + ", value: " + (weakAndPhantomRefs == null ? "null" : String.valueOf(weakAndPhantomRefs.fWeak.get())));
        }
        FreeableDirectByteBuffer.memstats();
    }

    public static Map<Long, Integer> getBufferCapacities() {
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        for (Long l : sBufAndKeyMap.keySet()) {
            ByteBuffAndKey byteBuffAndKey;
            WeakAndPhantomRefs weakAndPhantomRefs = sBufAndKeyMap.get(l);
            if (weakAndPhantomRefs == null || (byteBuffAndKey = (ByteBuffAndKey)weakAndPhantomRefs.fWeak.get()) == null) continue;
            hashMap.put(byteBuffAndKey.getKey(), byteBuffAndKey.getBuffer().capacity());
        }
        return hashMap;
    }

    static {
        System.loadLibrary("dctprocess");
        sBufAndKeyMap = new ConcurrentHashMap();
        sRefReaper = PhantomReferenceReaper.build();
    }

    private static final class PhantomReferenceReaper
    implements Runnable {
        private Thread fThread;
        private ReferenceQueue<ByteBuffAndKey> fRefQueue = new ReferenceQueue();
        private static final long THREAD_SLEEP_AMOUNT = 100L;

        private PhantomReferenceReaper() {
        }

        private void init() {
            this.fThread = new Thread((Runnable)this, "FreeableDirectByteBuffer reference reaper");
            this.fThread.setDaemon(true);
            this.fThread.start();
        }

        static PhantomReferenceReaper build() {
            PhantomReferenceReaper phantomReferenceReaper = new PhantomReferenceReaper();
            phantomReferenceReaper.init();
            return phantomReferenceReaper;
        }

        ReferenceQueue<ByteBuffAndKey> getRefQueue() {
            return this.fRefQueue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference<ByteBuffAndKey> reference;
                        if ((reference = this.fRefQueue.poll()) instanceof PhantomRefToBBAK) {
                            PhantomRefToBBAK phantomRefToBBAK = (PhantomRefToBBAK)reference;
                            FreeableDirectByteBuffer.freeByKey(phantomRefToBBAK.getAllocationKey());
                        } else assert (reference == null) : "Reference queue unexpectedly got: " + reference;
                        if (reference != null) continue;
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class WeakAndPhantomRefs {
        private final WeakReference<ByteBuffAndKey> fWeak;
        private final PhantomRefToBBAK fPhantom;

        private WeakAndPhantomRefs(ByteBuffAndKey byteBuffAndKey, ReferenceQueue<ByteBuffAndKey> referenceQueue) {
            this.fWeak = new WeakReference<ByteBuffAndKey>(byteBuffAndKey);
            this.fPhantom = new PhantomRefToBBAK(byteBuffAndKey, referenceQueue);
        }
    }

    private static final class PhantomRefToBBAK
    extends PhantomReference<ByteBuffAndKey> {
        private final long fAllocationKey;

        PhantomRefToBBAK(ByteBuffAndKey byteBuffAndKey, ReferenceQueue<ByteBuffAndKey> referenceQueue) {
            super(byteBuffAndKey, referenceQueue);
            this.fAllocationKey = byteBuffAndKey.getKey();
        }

        public long getAllocationKey() {
            return this.fAllocationKey;
        }
    }
}

