/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.ScrollablePopupList;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.IntSetChooser;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class IntSetPopup {
    private int fLowerLimit;
    private int fUpperLimit;
    private String fMemberLabelFormat;
    private String fChooserTitle;
    private IntSet fValue;
    private Action[] fActions;
    private Component fInvoker;
    private ChangeListener fChangeListener;

    IntSetPopup(int n, int n2, String string, String string2) {
        if (n > n2) {
            throw new IllegalArgumentException("lowerLimit must not exceed upperLimit");
        }
        this.fLowerLimit = n;
        this.fUpperLimit = n2;
        this.fMemberLabelFormat = string;
        this.fChooserTitle = string2;
        this.fValue = new IntSet();
        this.fActions = new Action[n2 - n + 3];
        this.fActions[0] = new SelectAllAction();
        this.fActions[1] = new SelectSomeAction();
        int n3 = 2;
        int n4 = n;
        while (n4 <= n2) {
            this.fActions[n3] = new SelectOneAction(n4);
            ++n4;
            ++n3;
        }
    }

    void setValue(IntSet intSet) {
        this.fValue = new IntSet(intSet);
    }

    IntSet getValue() {
        return this.fValue;
    }

    public void show(Component component, int n, int n2, ChangeListener changeListener) {
        this.fInvoker = component;
        this.fChangeListener = changeListener;
        ScrollablePopupList scrollablePopupList = new ScrollablePopupList(this.fActions);
        final Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        scrollablePopupList.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (component2 != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            component2.requestFocus();
                        }
                    });
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        scrollablePopupList.showPopup(component, n, n2);
    }

    private void fireChangeEvent() {
        if (this.fChangeListener != null) {
            this.fChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private class SelectOneAction
    extends MJAbstractAction {
        int iMember;

        SelectOneAction(int n) {
            super(MessageFormat.format(IntSetPopup.this.fMemberLabelFormat, new Integer(n)));
            this.iMember = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IntSetPopup.this.fValue = new IntSet(this.iMember);
            IntSetPopup.this.fireChangeEvent();
        }
    }

    private class SelectSomeAction
    extends MJAbstractAction {
        SelectSomeAction() {
            super(ParallelUI.sRes.getString("action.Some"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IntSet intSet = IntSetChooser.show(IntSetPopup.this.fInvoker, IntSetPopup.this.fLowerLimit, IntSetPopup.this.fUpperLimit, IntSetPopup.this.fValue, IntSetPopup.this.fMemberLabelFormat, IntSetPopup.this.fChooserTitle);
            if (intSet != null) {
                IntSetPopup.this.fValue = intSet;
                IntSetPopup.this.fireChangeEvent();
            }
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            super(ParallelUI.sRes.getString("action.All"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IntSetPopup.this.fValue = new IntSet(IntSetPopup.this.fLowerLimit, IntSetPopup.this.fUpperLimit);
            IntSetPopup.this.fireChangeEvent();
        }
    }
}

