/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

class IntSetTextField
extends MJFormattedTextField {
    IntSetTextField() {
        super((JFormattedTextField.AbstractFormatter)new IntSetFormatter());
    }

    static class IntSetStringFilter
    extends DocumentFilter {
        IntSetStringFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.isValid(string)) {
                filterBypass.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.isValid(string)) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private boolean isValid(String string) {
            boolean bl = true;
            for (int i = 0; i < string.length() && bl; ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == ',' || c == '-' || c == ':' || Character.isDigit(c)) continue;
                bl = false;
            }
            return bl;
        }
    }

    static class IntSetFormatter
    extends JFormattedTextField.AbstractFormatter {
        IntSetStringFilter iIntSetStringFilter = new IntSetStringFilter();

        IntSetFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            return new IntSet(string);
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            return object == null ? "" : ((IntSet)object).toString();
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return this.iIntSetStringFilter;
        }
    }
}

