/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.jidesoft.swing.StyleRange;
import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.toolbox.distcomp.parallelui.BackspaceScanner;
import com.mathworks.toolbox.distcomp.parallelui.HyperLinkScanner;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.SimpleTextStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.SubRegionStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.SyntaxTextStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.TextStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.TextSyntax;
import com.mathworks.util.FileUtils;
import com.mathworks.xml.XMLUtils;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OutputCollection {
    private final int fSourceCount;
    private final OutputBuffer[] fOutputBuffers;
    private final Queue<OutputRecord> fOutputQueue = new ConcurrentLinkedQueue<OutputRecord>();
    private final OutputEvent fOutputEvent = new OutputEvent();
    private int fOutputHeadroom;
    private AtomicBoolean[] fDiscardOutput;
    private Timer fOutputResumeTimer;
    private final LinkedList<Record> fSessionRecords = new LinkedList();
    private final CommandRecord[] fCommandRecords;
    private int fFirstCommandIndex;
    private int fCommandCount;
    private final List<OutputDocument> fDocuments = new ArrayList<OutputDocument>();
    private CommandTableModel fTableModel;
    private AttributeSet[][] fOutputAttributes;
    private AttributeSet[] fToggleAttributes = new AttributeSet[2];
    private Thread fSaveThread;
    private final BlockingQueue<CommandRecord> fSaveQueue = new LinkedBlockingQueue<CommandRecord>();
    private final CommandRecord NULL_COMMAND_RECORD = new CommandRecord();
    public static final int DEFAULT_OUTPUT_CHAR_CAPACITY = 1000000;
    public static final int MINIMUM_CHAR_CAPACITY_PER_SOURCE = 50000;
    public static final int DEFAULT_COMMAND_RECORD_CAPACITY = 10000;
    public static final int DEFAULT_DOCUMENT_RECORD_CAPACITY = 5000;
    public static final int DEFAULT_DOCUMENT_LINE_CAPACITY = 10000;
    public static final int MINIMUM_OUTPUT_HEADROOM = 10000;
    public static final int COMMAND_REUSE_SEARCH_LIMIT = 100;
    private static final String COMMAND_FILE_NAME = "PModeHistory.xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static final String XML_HISTORY_HEADER = "<History>";
    private static final String XML_SESSION_HEADER = "<Session>";
    private static final String XML_HISTORY_TERMINATOR = "</History>";
    private static final String XML_SESSION_TERMINATOR = "</Session>";
    private static final String XML_COMMAND_TAG = "Command";
    private static final String XML_PROMPT_ATTRIBUTE = "prompt";
    private static final String XML_ERROR_ATTRIBUTE = "error";
    private static final String XML_REPEAT_ATTRIBUTE = "repeat";
    private static final String XML_YES_VALUE = "yes";
    public static final String SOURCE_ATTRIBUTE = "Source Attribute";
    public static final String TOGGLE_ATTRIBUTE = "Toggle Attribute";
    public static final String PROMPT_ATTRIBUTE = "Prompt Attribute";

    public OutputCollection(int n) {
        this(n, -1, -1, -1);
    }

    public OutputCollection(int n, int n2, int n3, int n4) {
        int n5;
        this.fSourceCount = n;
        if (n2 < 0) {
            n2 = Math.max(1000000, n * 50000);
        }
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        this.fOutputBuffers = new OutputBuffer[n + 1];
        int n6 = n2 / n;
        int n7 = 0;
        for (n5 = 1; n5 <= n; ++n5) {
            CharBuffer charBuffer2;
            int n8 = n7 + n6;
            this.fOutputBuffers[n5] = new OutputBuffer();
            charBuffer.position(n7).limit(n8);
            this.fOutputBuffers[n5].iWriteBuffer = charBuffer2 = charBuffer.slice();
            this.fOutputBuffers[n5].iReadBuffer = charBuffer2.duplicate();
            n7 = n8;
        }
        this.fOutputHeadroom = n3;
        if (this.fOutputHeadroom < 0) {
            this.fOutputHeadroom = n6 / 10;
            if (this.fOutputHeadroom < 10000) {
                this.fOutputHeadroom = 10000;
            }
        }
        this.fDiscardOutput = new AtomicBoolean[n + 1];
        for (n5 = 1; n5 <= n; ++n5) {
            this.fDiscardOutput[n5] = new AtomicBoolean();
        }
        if (n4 < 0) {
            n4 = 10000;
        }
        this.fCommandRecords = new CommandRecord[n4];
        this.fOutputAttributes = new AttributeSet[2][];
        this.fOutputAttributes[0] = new AttributeSet[n + 1];
        this.fOutputAttributes[1] = new AttributeSet[n + 1];
        for (n5 = 1; n5 <= n; ++n5) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(TOGGLE_ATTRIBUTE, Boolean.FALSE);
            simpleAttributeSet.addAttribute(SOURCE_ATTRIBUTE, new Integer(n5));
            this.fOutputAttributes[0][n5] = simpleAttributeSet;
            simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(TOGGLE_ATTRIBUTE, Boolean.TRUE);
            simpleAttributeSet.addAttribute(SOURCE_ATTRIBUTE, new Integer(n5));
            this.fOutputAttributes[1][n5] = simpleAttributeSet;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(TOGGLE_ATTRIBUTE, Boolean.FALSE);
        this.fToggleAttributes[0] = simpleAttributeSet;
        simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(TOGGLE_ATTRIBUTE, Boolean.TRUE);
        this.fToggleAttributes[1] = simpleAttributeSet;
    }

    public void addCommand(String string, String string2, IntSet intSet) {
        char[] cArray;
        int n;
        Object object = intSet.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            this.fOutputBuffers[n].iExpectingContinuation = false;
            this.fDiscardOutput[n].set(false);
        }
        object = new SyntaxTextStyleInfo(TextSyntax.M, string);
        n = 0;
        if (string2 != null) {
            n = string2.length();
            cArray = new char[string.length() + n + 1];
            string2.getChars(0, n, cArray, 0);
            string.getChars(0, string.length(), cArray, n);
        } else {
            cArray = new char[string.length() + 1];
            string.getChars(0, string.length(), cArray, 0);
        }
        cArray[cArray.length - 1] = 10;
        CommandRecord commandRecord = this.getRecentCommandMatch(cArray, 100);
        if (commandRecord != null) {
            cArray = commandRecord.iText;
            if (object.equals(commandRecord.iStyleInfo)) {
                object = commandRecord.iStyleInfo;
            }
        }
        CommandRecord commandRecord2 = new CommandRecord(intSet, (TextStyleInfo)object, cArray, n, false);
        this.addRecord(commandRecord2);
    }

    public void addCommands(String[] stringArray, String string, String string2, IntSet intSet) {
        if (stringArray.length == 0) {
            return;
        }
        this.addCommand(stringArray[0], string2, intSet);
        if (stringArray.length == 1) {
            return;
        }
        SyntaxTextStyleInfo syntaxTextStyleInfo = new SyntaxTextStyleInfo(TextSyntax.M, string);
        int n = stringArray[0].length() + 1;
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0) {
                SubRegionStyleInfo subRegionStyleInfo = new SubRegionStyleInfo(syntaxTextStyleInfo, n, stringArray[i].length());
                char[] cArray = new char[stringArray[i].length() + 1];
                stringArray[i].getChars(0, stringArray[i].length(), cArray, 0);
                cArray[cArray.length - 1] = 10;
                CommandRecord commandRecord = new CommandRecord(intSet, subRegionStyleInfo, cArray, 0, true);
                this.addRecord(commandRecord);
            }
            n += stringArray[i].length() + 1;
        }
    }

    public void addOutput(int n, char[] cArray, int n2, int n3) {
        this.addOutput(n, cArray, n2, n3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutput(int n, char[] cArray, int n2, int n3, boolean bl) {
        int n4;
        if (n3 > this.fOutputHeadroom) {
            throw new IllegalArgumentException("Output length = " + n3 + " must be less than " + this.fOutputHeadroom);
        }
        if (n3 == 0 || this.fDiscardOutput[n].get()) {
            return;
        }
        OutputBuffer outputBuffer = this.fOutputBuffers[n];
        int n5 = 0;
        int n6 = n2;
        boolean bl2 = outputBuffer.iExpectingContinuation;
        if (bl2 && n3 > (n4 = this.fOutputBuffers[n].iWriteBuffer.capacity() - this.fOutputBuffers[n].iWriteBuffer.position())) {
            int n7;
            int n8 = n2;
            for (n7 = 1; n7 <= n3 && cArray[n8] != '\n'; ++n7) {
                ++n8;
            }
            if (n7 <= n4) {
                n6 = n2 + n7;
                n5 = n3 - n7;
                n3 = n7;
            } else {
                bl2 = false;
            }
        }
        outputBuffer.iExpectingContinuation = cArray[n2 + n3 - 1] != '\n';
        BackspaceScanner backspaceScanner = new BackspaceScanner(cArray, n2, n3);
        if (!bl2 && backspaceScanner.getNetOverwriteCount() == 0) {
            cArray = backspaceScanner.getCondensedText();
            n2 = backspaceScanner.getCondensedOffset();
            n3 = backspaceScanner.getCondensedLength();
            SimpleAttributeSet simpleAttributeSet = null;
            if (bl) {
                simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(SimpleTextStyleInfo.COLOR_KEY_ATTRIBUTE, "Colors_M_Errors");
            }
            if (n3 == 0) {
                return;
            }
            HyperLinkScanner hyperLinkScanner = new HyperLinkScanner(cArray, n2, n3, simpleAttributeSet);
            cArray = hyperLinkScanner.getStrippedText();
            n2 = hyperLinkScanner.getStrippedOffset();
            n3 = hyperLinkScanner.getStrippedLength();
            if (n3 == 0) {
                return;
            }
            TextStyleInfo textStyleInfo = hyperLinkScanner.getStyleInfo();
            if (textStyleInfo == null && simpleAttributeSet != null) {
                textStyleInfo = new SimpleTextStyleInfo(n3, simpleAttributeSet);
            }
            OutputRecord outputRecord = null;
            while (outputRecord == null) {
                if (outputBuffer.hasRoomFor(n3)) {
                    outputRecord = new OutputRecord(n, n3, OutputCollection.getLineEnds(cArray, n2, n3), textStyleInfo, outputBuffer.iWriteBuffer.position());
                    outputBuffer.iWriteBuffer.put(cArray, n2, n3);
                }
                OutputEvent outputEvent = this.fOutputEvent;
                synchronized (outputEvent) {
                    if (this.fDiscardOutput[n].get()) {
                        return;
                    }
                    if (outputRecord != null) {
                        this.fOutputQueue.offer(outputRecord);
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.fOutputEvent.run();
                    } else {
                        if (!this.fOutputEvent.iIsPending) {
                            this.fOutputEvent.iIsPending = true;
                            EventQueue.invokeLater(this.fOutputEvent);
                        }
                        if (outputRecord == null) {
                            try {
                                this.fOutputEvent.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        } else {
            OutputRecord outputRecord = new OutputRecord(n, backspaceScanner);
            OutputEvent outputEvent = this.fOutputEvent;
            synchronized (outputEvent) {
                if (this.fDiscardOutput[n].get()) {
                    return;
                }
                this.fOutputQueue.offer(outputRecord);
                if (EventQueue.isDispatchThread()) {
                    this.fOutputEvent.run();
                } else {
                    if (!this.fOutputEvent.iIsPending) {
                        this.fOutputEvent.iIsPending = true;
                        EventQueue.invokeLater(this.fOutputEvent);
                    }
                    try {
                        this.fOutputEvent.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (n5 > 0) {
            this.addOutput(n, cArray, n6, n5, bl);
        }
    }

    public void recordError(final int n) {
        IntSet intSet;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputCollection.this.recordError(n);
                }
            });
            return;
        }
        if (this.fCommandCount == 0) {
            return;
        }
        int n2 = this.fFirstCommandIndex + this.fCommandCount - 1;
        if (n2 >= this.fCommandRecords.length) {
            n2 -= this.fCommandRecords.length;
        }
        for (int i = this.fCommandCount; i > 0 && (intSet = this.fCommandRecords[n2].iDestinations) != null; --i) {
            if (intSet.contains(n)) {
                this.fCommandRecords[n2].iCausedError = true;
                if (this.fTableModel == null) break;
                this.fTableModel.changed(i - 1);
                break;
            }
            if (--n2 >= 0) continue;
            n2 = this.fCommandRecords.length - 1;
        }
    }

    void outputDone(int n) {
        this.fDiscardOutput[n].set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSession() {
        int n;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputCollection.this.clearSession();
                }
            });
            return;
        }
        OutputEvent outputEvent = this.fOutputEvent;
        synchronized (outputEvent) {
            this.interruptOutput(new IntSet(1, this.fSourceCount));
            for (OutputDocument outputDocument : this.fDocuments) {
                outputDocument.clear();
            }
            this.fSessionRecords.clear();
            for (n = 1; n <= this.fSourceCount; ++n) {
                int n2 = this.fOutputBuffers[n].iReadEnd;
                this.fOutputBuffers[n].setOccupiedRange(n2, n2);
            }
            this.fOutputQueue.clear();
            this.fOutputEvent.iIsPending = false;
        }
        if (this.fCommandCount > 0) {
            CommandRecord commandRecord;
            int n3 = this.fFirstCommandIndex + this.fCommandCount - 1;
            if (n3 >= this.fCommandRecords.length) {
                n3 -= this.fCommandRecords.length;
            }
            for (n = 0; n < this.fCommandCount && (commandRecord = this.fCommandRecords[n3]) != null && !commandRecord.iIsSessionHeader; ++n) {
                commandRecord.iIsOutputAvailable = false;
                if (--n3 >= 0) continue;
                n3 = this.fCommandRecords.length - 1;
            }
        }
    }

    void interruptOutput(IntSet intSet) {
        Iterator iterator = intSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.fDiscardOutput[n].set(true);
        }
        if (this.fOutputResumeTimer != null && this.fOutputResumeTimer.isRunning()) {
            this.fOutputResumeTimer.stop();
        }
        this.fOutputResumeTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputCollection.this.fOutputResumeTimer = null;
                for (int i = 1; i <= OutputCollection.this.fSourceCount; ++i) {
                    OutputCollection.this.fDiscardOutput[i].set(false);
                }
            }
        });
        this.fOutputResumeTimer.setRepeats(false);
        this.fOutputResumeTimer.start();
    }

    void clearOutput(final int n) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputCollection.this.clearOutput(n);
                }
            });
            return;
        }
        Object object = this.fSessionRecords.iterator();
        while (object.hasNext()) {
            Record record = (Record)object.next();
            if (record.getSource() == n) {
                object.remove();
            }
            if (!(record instanceof CommandRecord)) continue;
            ((CommandRecord)record).getDestinations().remove(n);
        }
        object = this.fOutputBuffers[n];
        ((OutputBuffer)object).setOccupiedRange(((OutputBuffer)object).iReadEnd, ((OutputBuffer)object).iReadEnd);
        for (OutputDocument outputDocument : this.fDocuments) {
            if (!outputDocument.iSources.contains(n)) continue;
            outputDocument.clear(n);
        }
    }

    public StyledDocument createDocument(IntSet intSet) {
        return this.createDocument(intSet, 5000);
    }

    public StyledDocument createDocument(IntSet intSet, int n) {
        OutputDocument outputDocument = new OutputDocument(intSet, n);
        this.fDocuments.add(outputDocument);
        return outputDocument;
    }

    public void destroyDocument(Document document) {
        if (document instanceof OutputDocument) {
            ((OutputDocument)document).clear();
            this.fDocuments.remove(document);
        }
    }

    void refreshAllDocuments() {
        for (OutputDocument outputDocument : this.fDocuments) {
            outputDocument.refresh();
        }
    }

    TableModel getTableModel() {
        if (this.fTableModel == null) {
            this.fTableModel = new CommandTableModel();
        }
        return this.fTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCommands() {
        if (CmdHistoryPrefs.getNumCommandsToSave() == -1) {
            return;
        }
        if (this.fSaveThread != null) {
            this.fSaveQueue.offer(this.NULL_COMMAND_RECORD);
            try {
                this.fSaveThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fSaveThread = null;
        }
        File file = OutputCollection.getCommandFile();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(XML_HEADER);
            fileWriter.write(10);
            fileWriter.write(XML_HISTORY_HEADER);
            fileWriter.write(10);
            if (this.fCommandCount > 0) {
                fileWriter.write(XML_SESSION_HEADER);
                fileWriter.write(10);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", XML_YES_VALUE);
                transformer.setOutputProperty("omit-xml-declaration", XML_YES_VALUE);
                transformer.setOutputProperty("encoding", "utf-8");
                int n = this.fFirstCommandIndex;
                for (int i = 0; i < this.fCommandCount; ++i) {
                    CommandRecord commandRecord = this.fCommandRecords[n];
                    if (commandRecord.iIsSessionHeader && i > 0) {
                        fileWriter.write(XML_SESSION_TERMINATOR);
                        fileWriter.write(10);
                        fileWriter.write(XML_SESSION_HEADER);
                        fileWriter.write(10);
                    }
                    org.w3c.dom.Document document = documentBuilder.newDocument();
                    Element element = commandRecord.toXML(document);
                    document.appendChild(element);
                    StringWriter stringWriter = new StringWriter();
                    transformer.transform(XMLUtils.transformSourceFactory((Object)document), XMLUtils.transformResultFactory((Object)stringWriter));
                    fileWriter.write(stringWriter.getBuffer().toString().trim());
                    fileWriter.write(10);
                    if (++n < this.fCommandRecords.length) continue;
                    n = 0;
                }
                fileWriter.write(XML_SESSION_TERMINATOR);
                fileWriter.write(10);
                fileWriter.write(XML_HISTORY_TERMINATOR);
                fileWriter.write(10);
            }
        }
        catch (Exception exception) {
            System.out.println("An error was encountered while saving the PMode command history");
            exception.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recallCommands() {
        File file = OutputCollection.getCommandFile();
        if (!file.exists()) {
            return;
        }
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            this.fFirstCommandIndex = 0;
            this.fCommandCount = 0;
            inputStreamReader = new FileReader(file);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            if (!string.startsWith(XML_HEADER)) {
                throw new DataFormatException("Missing XML header");
            }
            string = bufferedReader.readLine();
            if (!string.startsWith(XML_HISTORY_HEADER)) {
                throw new DataFormatException("Missing history header");
            }
            boolean bl = true;
            String[] stringArray = new String[1];
            String string2 = null;
            LinkedList<CommandRecord> linkedList = new LinkedList<CommandRecord>();
            string = bufferedReader.readLine();
            while (string != null) {
                if (string.startsWith(XML_SESSION_HEADER) || string.startsWith(XML_SESSION_TERMINATOR)) {
                    bl = true;
                } else {
                    if (string.startsWith(XML_HISTORY_TERMINATOR)) break;
                    SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                    StringReader stringReader = new StringReader(string);
                    SimpleElement simpleElement = simpleDOMParser.parse((Reader)stringReader);
                    CommandRecord commandRecord = new CommandRecord((SimpleElement)simpleElement.getFirstChild(), bl, stringArray);
                    commandRecord.iIsOutputAvailable = false;
                    bl = false;
                    if (commandRecord.iStyleInfo == null) {
                        linkedList.add(commandRecord);
                        string2 = stringArray[0];
                    } else if (linkedList.size() > 0) {
                        this.setBatchStyles(string2, linkedList);
                    }
                    CommandRecord commandRecord2 = this.getRecentCommandMatch(commandRecord.iText, 100);
                    if (commandRecord2 != null) {
                        CommandRecord.access$302(commandRecord, commandRecord2.iText);
                    }
                    if (this.fCommandCount < this.fCommandRecords.length) {
                        this.fCommandRecords[this.fCommandCount++] = commandRecord;
                    } else {
                        this.fCommandRecords[this.fFirstCommandIndex] = commandRecord;
                        ++this.fFirstCommandIndex;
                        if (this.fFirstCommandIndex >= this.fCommandRecords.length) {
                            this.fFirstCommandIndex = 0;
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            if (linkedList.size() > 0) {
                this.setBatchStyles(string2, linkedList);
            }
        }
        catch (Exception exception) {
            System.out.println("An error was encountered while loading the PMode command history");
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setBatchStyles(String string, List<CommandRecord> list) {
        SyntaxTextStyleInfo syntaxTextStyleInfo = new SyntaxTextStyleInfo(TextSyntax.M, string);
        for (CommandRecord commandRecord : list) {
            commandRecord.setStyleInfo(syntaxTextStyleInfo);
        }
        list.clear();
    }

    void injectDateTimeRecord() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string = dateFormat.format(date);
        dateFormat = DateFormat.getTimeInstance(3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string2 = dateFormat.format(date);
        String string3 = "%-- " + string + " " + string2 + " --%\n";
        char[] cArray = string3.toCharArray();
        SyntaxTextStyleInfo syntaxTextStyleInfo = new SyntaxTextStyleInfo(TextSyntax.M, cArray);
        CommandRecord commandRecord = new CommandRecord(null, syntaxTextStyleInfo, cArray, 0, true);
        commandRecord.iIsSessionHeader = true;
        commandRecord.iIsOutputAvailable = false;
        this.addToCommands(commandRecord);
    }

    private static File getCommandFile() {
        return new File(FileUtils.getPreferencesDirectory(), COMMAND_FILE_NAME);
    }

    private CommandRecord getRecentCommandMatch(char[] cArray, int n) {
        int n2;
        if (this.fCommandCount == 0) {
            return null;
        }
        if (n > this.fCommandCount) {
            n = this.fCommandCount;
        }
        if ((n2 = this.fFirstCommandIndex + this.fCommandCount - 1) >= this.fCommandRecords.length) {
            n2 -= this.fCommandRecords.length;
        }
        while (n > 0) {
            char[] cArray2 = this.fCommandRecords[n2].iText;
            if (cArray2.length == cArray.length) {
                int n3;
                for (n3 = 0; n3 < cArray.length && cArray2[n3] == cArray[n3]; ++n3) {
                }
                if (n3 == cArray.length) {
                    return this.fCommandRecords[n2];
                }
            }
            if (--n2 < 0) {
                n2 = this.fCommandRecords.length - 1;
            }
            --n;
        }
        return null;
    }

    private static int[] getLineEnds(char[] cArray, int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2 - 1; ++i) {
            if (cArray[n + i] != '\n') continue;
            arrayList.add(i);
        }
        arrayList.add(n2);
        return OutputCollection.toIntArray(arrayList);
    }

    private static int[] getLineEnds(CharBuffer charBuffer, int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2 - 1; ++i) {
            if (charBuffer.get(n + i) != '\n') continue;
            arrayList.add(i);
        }
        arrayList.add(n2);
        return OutputCollection.toIntArray(arrayList);
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    private void addRecord(Record record) {
        this.fSessionRecords.add(record);
        for (OutputDocument outputDocument : this.fDocuments) {
            if (!outputDocument.includeRecord(record)) continue;
            outputDocument.add(record);
        }
        if (record instanceof CommandRecord) {
            this.addToCommands((CommandRecord)record);
        }
    }

    private void addToCommands(CommandRecord commandRecord) {
        int n;
        String string = commandRecord.getCommandString();
        if ("\n".equals(string)) {
            return;
        }
        if (!CmdHistoryPrefs.getSaveExitQuit() && ("exit".equals(string) || "quit".equals(string) || "pmode exit".equals(string) || string != null && string.startsWith("quit "))) {
            return;
        }
        if (!CmdHistoryPrefs.getSaveDuplicates() && this.fCommandCount > 0 && !commandRecord.iBelongsToBatch) {
            n = this.fFirstCommandIndex + this.fCommandCount - 1;
            if (n >= this.fCommandRecords.length) {
                n -= this.fCommandRecords.length;
            }
            CommandRecord commandRecord2 = this.fCommandRecords[n];
            if (commandRecord.iText == commandRecord2.iText || Arrays.equals(commandRecord.iText, commandRecord2.iText)) {
                commandRecord.iRepeatCount = commandRecord2.iRepeatCount + 1;
                this.fCommandRecords[n] = commandRecord;
                if (this.fTableModel != null) {
                    this.fTableModel.changed(this.fCommandCount - 1);
                }
                return;
            }
        }
        if (this.fCommandCount == this.fCommandRecords.length) {
            this.fCommandRecords[this.fFirstCommandIndex++] = commandRecord;
            if (this.fFirstCommandIndex >= this.fCommandRecords.length) {
                this.fFirstCommandIndex = 0;
            }
            if (this.fTableModel != null) {
                this.fTableModel.removed(0);
            }
        } else {
            n = this.fFirstCommandIndex + this.fCommandCount;
            if (n >= this.fCommandRecords.length) {
                n -= this.fCommandRecords.length;
            }
            this.fCommandRecords[n] = commandRecord;
            ++this.fCommandCount;
            if (this.fTableModel != null) {
                this.fTableModel.added(this.fCommandCount - 1);
            }
        }
        if (CmdHistoryPrefs.getNumCommandsToSave() != -1 && CmdHistoryPrefs.getNumCommandsToSave() != -2) {
            if (this.fSaveThread == null) {
                this.fSaveThread = new Thread(new CommandSaver());
                this.fSaveThread.setPriority(1);
                this.fSaveThread.setDaemon(true);
                this.fSaveThread.start();
            }
            this.fSaveQueue.offer(commandRecord);
        }
    }

    class CommandSaver
    implements Runnable {
        CommandSaver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            RandomAccessFile randomAccessFile = null;
            DocumentBuilderFactory documentBuilderFactory = null;
            DocumentBuilder documentBuilder = null;
            TransformerFactory transformerFactory = null;
            Transformer transformer = null;
            while (!bl) {
                try {
                    CommandRecord commandRecord = (CommandRecord)OutputCollection.this.fSaveQueue.take();
                    if (commandRecord == OutputCollection.this.NULL_COMMAND_RECORD) {
                        bl = true;
                        continue;
                    }
                    File file = OutputCollection.getCommandFile();
                    if (randomAccessFile == null) {
                        boolean bl3 = file.exists();
                        randomAccessFile = new RandomAccessFile(file, "rw");
                        documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        transformerFactory = TransformerFactory.newInstance();
                        transformer = transformerFactory.newTransformer();
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("indent", OutputCollection.XML_YES_VALUE);
                        transformer.setOutputProperty("omit-xml-declaration", OutputCollection.XML_YES_VALUE);
                        transformer.setOutputProperty("encoding", "utf-8");
                        if (!bl3) {
                            randomAccessFile.writeBytes(OutputCollection.XML_HEADER);
                            randomAccessFile.write(10);
                            randomAccessFile.writeBytes(OutputCollection.XML_HISTORY_HEADER);
                            randomAccessFile.write(10);
                            randomAccessFile.writeBytes(OutputCollection.XML_SESSION_HEADER);
                            randomAccessFile.write(10);
                        } else {
                            long l = randomAccessFile.length();
                            int n = OutputCollection.XML_SESSION_TERMINATOR.length() + OutputCollection.XML_HISTORY_TERMINATOR.length() + 2;
                            randomAccessFile.seek(l - (long)n);
                        }
                    }
                    org.w3c.dom.Document document = documentBuilder.newDocument();
                    Element element = commandRecord.toXML(document);
                    document.appendChild(element);
                    StringWriter stringWriter = new StringWriter();
                    transformer.transform(XMLUtils.transformSourceFactory((Object)document), XMLUtils.transformResultFactory((Object)stringWriter));
                    randomAccessFile.writeBytes(stringWriter.getBuffer().toString().trim());
                    randomAccessFile.write(10);
                }
                catch (Exception exception) {
                    System.out.println("An error was encountered while saving a command to the PMode history");
                    exception.printStackTrace();
                    bl2 = true;
                    bl = true;
                }
                finally {
                    if (randomAccessFile == null || !bl && OutputCollection.this.fSaveQueue.peek() != null) continue;
                    try {
                        if (!bl2) {
                            randomAccessFile.writeBytes(OutputCollection.XML_SESSION_TERMINATOR);
                            randomAccessFile.write(10);
                            randomAccessFile.writeBytes(OutputCollection.XML_HISTORY_TERMINATOR);
                            randomAccessFile.write(10);
                        }
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                    randomAccessFile = null;
                    documentBuilderFactory = null;
                    documentBuilder = null;
                    transformerFactory = null;
                    transformer = null;
                }
            }
        }
    }

    private static class Deletion {
        int[] iDeletedRows;
        CommandRecord[] iDeletedRecords;

        private Deletion() {
        }
    }

    class CommandTableModel
    extends AbstractTableModel {
        List<Deletion> iUndoStack = new ArrayList<Deletion>();

        CommandTableModel() {
        }

        @Override
        public int getRowCount() {
            return OutputCollection.this.fCommandCount;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = OutputCollection.this.fFirstCommandIndex + n;
            if (n3 >= OutputCollection.this.fCommandRecords.length) {
                n3 -= OutputCollection.this.fCommandRecords.length;
            }
            CommandRecord commandRecord = OutputCollection.this.fCommandRecords[n3];
            if (n2 == 0) {
                return commandRecord.iCausedError ? -1 : commandRecord.iRepeatCount;
            }
            if (n2 == 1) {
                return commandRecord.getPromptString();
            }
            if (n2 == 2) {
                return commandRecord;
            }
            return null;
        }

        private void added(int n) {
            this.iUndoStack.clear();
            this.fireTableRowsInserted(n, n);
        }

        private void removed(int n) {
            this.fireTableRowsDeleted(n, n);
        }

        private void changed(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        void delete(int[] nArray) {
            int n;
            int n2;
            if (nArray == null || nArray.length == 0) {
                return;
            }
            Deletion deletion = new Deletion();
            deletion.iDeletedRows = nArray;
            deletion.iDeletedRecords = new CommandRecord[nArray.length];
            this.iUndoStack.add(deletion);
            int n3 = OutputCollection.this.fFirstCommandIndex + nArray[0];
            if (n3 >= OutputCollection.this.fCommandRecords.length) {
                n3 -= OutputCollection.this.fCommandRecords.length;
            }
            if ((n2 = n3 + 1) == OutputCollection.this.fCommandRecords.length) {
                n2 = 0;
            }
            if (OutputCollection.this.fCommandCount < OutputCollection.this.fCommandRecords.length) {
                n = OutputCollection.this.fFirstCommandIndex + OutputCollection.this.fCommandRecords.length - 1;
                if (n >= OutputCollection.this.fCommandRecords.length) {
                    n -= OutputCollection.this.fCommandRecords.length;
                }
            } else {
                n = OutputCollection.this.fFirstCommandIndex - 1;
                if (n < 0) {
                    n += OutputCollection.this.fCommandRecords.length;
                }
            }
            deletion.iDeletedRecords[0] = OutputCollection.this.fCommandRecords[n3];
            this.removed(nArray[0]);
            int n4 = nArray[0] + 1;
            int n5 = 1;
            while (n2 != n) {
                if (n5 < nArray.length && nArray[n5] == n4) {
                    deletion.iDeletedRecords[n5] = OutputCollection.this.fCommandRecords[n2];
                    this.removed(nArray[n5]);
                    ++n5;
                    ++n4;
                    if (++n2 != OutputCollection.this.fCommandRecords.length) continue;
                    n2 = 0;
                    continue;
                }
                ((OutputCollection)OutputCollection.this).fCommandRecords[n3] = OutputCollection.this.fCommandRecords[n2];
                ++n4;
                if (++n3 == OutputCollection.this.fCommandRecords.length) {
                    n3 = 0;
                }
                if (++n2 != OutputCollection.this.fCommandRecords.length) continue;
                n2 = 0;
            }
            OutputCollection.this.fCommandCount -= nArray.length;
        }

        boolean anythingToUndo() {
            return this.iUndoStack.size() > 0;
        }

        void undoLastDeletion() {
            int n;
            Deletion deletion = this.iUndoStack.remove(this.iUndoStack.size() - 1);
            int n2 = deletion.iDeletedRows.length;
            int n3 = OutputCollection.this.fFirstCommandIndex + OutputCollection.this.fCommandCount + n2 - 1;
            if (n3 >= OutputCollection.this.fCommandRecords.length) {
                n3 -= OutputCollection.this.fCommandRecords.length;
            }
            if ((n = n3 - n2) < 0) {
                n = OutputCollection.this.fCommandRecords.length - 1;
            }
            int n4 = OutputCollection.this.fCommandCount + n2 - 1;
            int n5 = n2 - 1;
            while (n5 >= 0) {
                if (deletion.iDeletedRows[n5] == n4) {
                    ((OutputCollection)OutputCollection.this).fCommandRecords[n3] = deletion.iDeletedRecords[n5];
                    --n4;
                    --n5;
                    if (--n3 >= 0) continue;
                    n3 = OutputCollection.this.fCommandRecords.length - 1;
                    continue;
                }
                ((OutputCollection)OutputCollection.this).fCommandRecords[n3] = OutputCollection.this.fCommandRecords[n];
                --n4;
                if (--n3 < 0) {
                    n3 = OutputCollection.this.fCommandRecords.length - 1;
                }
                if (--n >= 0) continue;
                n = OutputCollection.this.fCommandRecords.length - 1;
            }
            OutputCollection.this.fCommandCount += n2;
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = deletion.iDeletedRows[n5];
                this.fireTableRowsInserted(n6, n6);
            }
        }
    }

    class OutputDocument
    implements StyledDocument {
        private IntSet iSources;
        private long iCharCount;
        private int iLineCount;
        private Record[] iRecords;
        private long[] iRecordStarts;
        private RecordElement[] iElements;
        private javax.swing.text.Element iEmptyElement;
        private BitSet iToggleSet;
        private int iFirstRecordIndex;
        private int iRecordCount;
        private boolean iToggleValue;
        private int iLastSource = -1;
        private Position iStartPosition = new Position(){

            @Override
            public int getOffset() {
                return 0;
            }
        };
        private Position iEndPosition = new Position(){

            @Override
            public int getOffset() {
                return OutputDocument.this.getLength();
            }
        };
        private Properties iProperties = new Properties();
        private javax.swing.text.Element iRootElement = new RootElement();
        private List<DocumentListener> iListeners = new ArrayList<DocumentListener>();
        private final StyleContext iStyleContext = new StyleContext();

        OutputDocument(IntSet intSet, int n) {
            this.iSources = intSet;
            this.iRecords = new Record[n];
            this.iRecordStarts = new long[n];
            this.iElements = new RecordElement[n];
            this.iEmptyElement = new EmptyElement();
            this.iToggleSet = new BitSet(n);
            for (Record record : OutputCollection.this.fSessionRecords) {
                if (!this.includeRecord(record)) continue;
                this.add(record);
            }
        }

        private boolean includeRecord(Record record) {
            return record instanceof OutputRecord && this.iSources.contains(((OutputRecord)record).iSource) || record instanceof CommandRecord && this.iSources.containsAny(((CommandRecord)record).iDestinations);
        }

        @Override
        public int getLength() {
            if (this.iRecordCount == 0) {
                return 0;
            }
            int n = this.iFirstRecordIndex + this.iRecordCount - 1;
            if (n >= this.iRecords.length) {
                n -= this.iRecords.length;
            }
            Record record = this.iRecords[n];
            return (int)(this.iRecordStarts[n] - this.iRecordStarts[this.iFirstRecordIndex]) + record.iLength;
        }

        @Override
        public void addDocumentListener(DocumentListener documentListener) {
            this.iListeners.add(documentListener);
        }

        @Override
        public void removeDocumentListener(DocumentListener documentListener) {
            this.iListeners.remove(documentListener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        public Object getProperty(Object object) {
            return this.iProperties.get(object);
        }

        @Override
        public void putProperty(Object object, Object object2) {
            this.iProperties.put(object, object2);
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        }

        @Override
        public String getText(int n, int n2) throws BadLocationException {
            Segment segment = new Segment();
            this.getText(n, n2, segment);
            return new String(segment.array, segment.offset, segment.count);
        }

        @Override
        public void getText(int n, int n2, Segment segment) throws BadLocationException {
            int n3 = this.getRecordIndex(n);
            if (n3 == -1) {
                segment.offset = 0;
                segment.count = 0;
                segment.array = new char[0];
                return;
            }
            int n4 = n - (int)(this.iRecordStarts[n3] - this.iRecordStarts[this.iFirstRecordIndex]);
            int n5 = this.iRecords[n3].iLength - n4;
            OutputRecord outputRecord = null;
            CharBuffer charBuffer = null;
            if (this.iRecords[n3] instanceof OutputRecord) {
                outputRecord = (OutputRecord)this.iRecords[n3];
                charBuffer = ((OutputCollection)OutputCollection.this).fOutputBuffers[outputRecord.iSource].iReadBuffer;
            }
            if (charBuffer != null && charBuffer.hasArray() && (segment.isPartialReturn() || n2 <= n5)) {
                segment.array = charBuffer.array();
                segment.offset = charBuffer.arrayOffset() + outputRecord.iBufferPosition + n4;
                segment.count = Math.min(n2, n5);
            } else if (this.iRecords[n3] instanceof CommandRecord && (segment.isPartialReturn() || n2 <= n5)) {
                CommandRecord commandRecord = (CommandRecord)this.iRecords[n3];
                segment.array = commandRecord.iText;
                segment.offset = n4 + commandRecord.iPromptLength;
                segment.count = Math.min(n2, n5);
            } else {
                segment.offset = 0;
                if (segment.array == null || segment.array.length < n2) {
                    segment.array = new char[n2];
                }
                segment.count = 0;
                while (segment.count < n2 && n5 > 0) {
                    int n6 = n2 - segment.count;
                    if (n6 > n5) {
                        n6 = n5;
                    }
                    if (this.iRecords[n3] instanceof CommandRecord) {
                        CommandRecord commandRecord = (CommandRecord)this.iRecords[n3];
                        int n7 = n4 + commandRecord.iPromptLength;
                        for (int i = 0; i < n6; ++i) {
                            segment.array[segment.count++] = commandRecord.iText[n7];
                            ++n7;
                        }
                    } else {
                        outputRecord = (OutputRecord)this.iRecords[n3];
                        charBuffer = ((OutputCollection)OutputCollection.this).fOutputBuffers[outputRecord.iSource].iReadBuffer;
                        charBuffer.position(outputRecord.iBufferPosition + n4);
                        charBuffer.get(segment.array, segment.count, n6);
                        segment.count += n6;
                    }
                    if (++n3 == this.iRecords.length) {
                        n3 = 0;
                    }
                    n4 = 0;
                    n5 = this.iRecords[n3] == null ? 0 : this.iRecords[n3].iLength;
                }
            }
        }

        @Override
        public Position getStartPosition() {
            return this.iStartPosition;
        }

        @Override
        public Position getEndPosition() {
            return this.iEndPosition;
        }

        @Override
        public Position createPosition(int n) throws BadLocationException {
            long l = this.iRecordCount == 0 ? this.iCharCount : this.iRecordStarts[this.iFirstRecordIndex] + (long)n;
            return new CountBasedPosition(l);
        }

        @Override
        public javax.swing.text.Element[] getRootElements() {
            return new javax.swing.text.Element[]{this.iRootElement};
        }

        @Override
        public javax.swing.text.Element getDefaultRootElement() {
            return this.iRootElement;
        }

        public javax.swing.text.Element getSectionElement(int n) {
            int n2 = this.iRootElement.getElementIndex(n);
            return this.iRootElement.getElement(n2);
        }

        @Override
        public javax.swing.text.Element getParagraphElement(int n) {
            javax.swing.text.Element element = this.getSectionElement(n);
            int n2 = element.getElementIndex(n);
            return element.getElement(n2);
        }

        @Override
        public javax.swing.text.Element getCharacterElement(int n) {
            javax.swing.text.Element element = this.getParagraphElement(n);
            if (element instanceof LeafElement) {
                return element;
            }
            int n2 = element.getElementIndex(n);
            return element.getElement(n2);
        }

        @Override
        public void render(Runnable runnable) {
        }

        @Override
        public Style addStyle(String string, Style style) {
            return this.iStyleContext.addStyle(string, style);
        }

        @Override
        public void removeStyle(String string) {
            this.iStyleContext.removeStyle(string);
        }

        @Override
        public Style getLogicalStyle(int n) {
            return this.iStyleContext.getStyle("default");
        }

        @Override
        public void setLogicalStyle(int n, Style style) {
        }

        @Override
        public Style getStyle(String string) {
            return this.iStyleContext.getStyle(string);
        }

        @Override
        public Color getBackground(AttributeSet attributeSet) {
            return this.iStyleContext.getBackground(attributeSet);
        }

        @Override
        public Color getForeground(AttributeSet attributeSet) {
            return this.iStyleContext.getForeground(attributeSet);
        }

        @Override
        public Font getFont(AttributeSet attributeSet) {
            return this.iStyleContext.getFont(attributeSet);
        }

        @Override
        public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        }

        @Override
        public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        }

        javax.swing.text.Element getRecordElement(int n) {
            return this.iElements[n];
        }

        String getCommandString(javax.swing.text.Element element) {
            int n;
            Record record;
            if (element instanceof LineElement) {
                element = element.getParentElement();
            }
            if (element instanceof RecordElement && (record = this.iRecords[n = ((RecordElement)element).iRecordIndex]) instanceof CommandRecord) {
                return ((CommandRecord)record).getCommandString();
            }
            return null;
        }

        String getPromptString(javax.swing.text.Element element) {
            int n;
            Record record;
            if (element instanceof LineElement) {
                element = element.getParentElement();
            }
            if (element instanceof RecordElement && (record = this.iRecords[n = ((RecordElement)element).iRecordIndex]) instanceof CommandRecord) {
                return ((CommandRecord)record).getPromptString();
            }
            return null;
        }

        StyleRange[] getStyleRanges(javax.swing.text.Element element) {
            int n;
            Record record;
            if (element instanceof LineElement) {
                element = element.getParentElement();
            }
            if (element instanceof RecordElement && (record = this.iRecords[n = ((RecordElement)element).iRecordIndex]) instanceof CommandRecord) {
                return record.iStyleInfo == null ? new StyleRange[]{} : record.iStyleInfo.getStyleRanges();
            }
            return null;
        }

        javax.swing.text.Element getElement(Record record) {
            if (record instanceof CommandRecord && !((CommandRecord)record).iIsOutputAvailable) {
                return null;
            }
            for (int i = 0; i < this.iRecords.length; ++i) {
                if (this.iRecords[i] != record) continue;
                return this.getRecordElement(i);
            }
            return null;
        }

        private void add(Record record) {
            if (this.iRecordCount == this.iRecords.length) {
                this.remove(this.iRecords[this.iFirstRecordIndex]);
            }
            while (this.iLineCount + record.getLineCount() > 10000 && this.iRecordCount > 0) {
                this.remove(this.iRecords[this.iFirstRecordIndex]);
            }
            int n = this.iFirstRecordIndex + this.iRecordCount;
            if (n >= this.iRecords.length) {
                n -= this.iRecords.length;
            }
            this.iRecords[n] = record;
            this.iRecordStarts[n] = this.iCharCount;
            this.iElements[n] = new RecordElement(n);
            int n2 = record.getSource();
            if (this.iLastSource != -1 && this.iLastSource != n2 && n2 != 0) {
                this.iToggleValue = !this.iToggleValue;
            }
            this.iToggleSet.set(n, this.iToggleValue);
            if (n2 != 0) {
                this.iLastSource = n2;
            }
            ++this.iRecordCount;
            this.iLineCount += record.getLineCount();
            this.iCharCount += (long)record.iLength;
            RecordEvent recordEvent = new RecordEvent(DocumentEvent.EventType.INSERT, n);
            for (DocumentListener documentListener : this.iListeners) {
                documentListener.insertUpdate(recordEvent);
            }
        }

        private void remove(Record record) {
            int n;
            int n2 = this.iFirstRecordIndex;
            for (n = 0; n < this.iRecordCount && record != this.iRecords[n2]; ++n) {
                if (++n2 < this.iRecords.length) continue;
                n2 = 0;
            }
            if (record == this.iRecords[n2]) {
                int n3;
                RecordEvent recordEvent = new RecordEvent(DocumentEvent.EventType.REMOVE, n2);
                int n4 = -1;
                boolean bl = false;
                boolean bl2 = false;
                int n5 = n2;
                for (n3 = n + 1; n3 < this.iRecordCount && n4 == -1; ++n3) {
                    if (++n5 >= this.iRecords.length) {
                        n5 = 0;
                    }
                    if (!(this.iRecords[n5] instanceof OutputRecord)) continue;
                    n4 = ((OutputRecord)this.iRecords[n5]).iSource;
                    bl = this.iToggleSet.get(n5);
                }
                n5 = n2;
                for (n3 = 0; n3 < n; ++n3) {
                    int n6 = n5 - 1;
                    if (n6 < 0) {
                        n6 = this.iRecords.length - 1;
                    }
                    this.iRecords[n5] = this.iRecords[n6];
                    this.iRecordStarts[n5] = this.iRecordStarts[n6] + (long)record.iLength;
                    this.iElements[n5] = this.iElements[n6];
                    this.iElements[n5].iRecordIndex = n5;
                    int n7 = this.iRecords[n5].getSource();
                    if (n7 != 0 && n7 != n4 && n4 != -1) {
                        bl = !bl;
                    }
                    this.iToggleSet.set(n5, bl);
                    if (!bl2) {
                        boolean bl3 = bl2 = bl != this.iToggleSet.get(n6);
                    }
                    if (n7 != 0) {
                        n4 = n7;
                    }
                    n5 = n6;
                }
                this.iRecords[this.iFirstRecordIndex] = null;
                this.iRecordStarts[this.iFirstRecordIndex] = -1L;
                this.iElements[this.iFirstRecordIndex] = null;
                ++this.iFirstRecordIndex;
                if (this.iFirstRecordIndex >= this.iRecords.length) {
                    this.iFirstRecordIndex = 0;
                }
                --this.iRecordCount;
                this.iLineCount -= record.getLineCount();
                for (DocumentListener documentListener : this.iListeners) {
                    documentListener.removeUpdate(recordEvent);
                }
            }
        }

        private void removeRecent(Record record) {
            int n = this.iFirstRecordIndex + this.iRecordCount - 1;
            if (n >= this.iRecords.length) {
                n -= this.iRecords.length;
            }
            int n2 = n;
            while (n2 != this.iFirstRecordIndex && this.iRecords[n2] != record) {
                if (--n2 >= 0) continue;
                n2 = this.iRecords.length - 1;
            }
            if (this.iRecords[n2] == record) {
                RecordEvent recordEvent = new RecordEvent(DocumentEvent.EventType.REMOVE, n2);
                while (n2 != n) {
                    int n3 = n2 + 1;
                    if (n3 == this.iRecords.length) {
                        n3 = 0;
                    }
                    this.iRecords[n2] = this.iRecords[n3];
                    this.iRecordStarts[n2] = this.iRecordStarts[n3] - (long)record.iLength;
                    this.iElements[n2] = this.iElements[n3];
                    this.iElements[n2].iRecordIndex = n2;
                    n2 = n3;
                }
                --this.iRecordCount;
                this.iLineCount -= record.getLineCount();
                this.iCharCount -= (long)record.iLength;
                for (DocumentListener documentListener : this.iListeners) {
                    documentListener.removeUpdate(recordEvent);
                }
            }
        }

        private void replace(Record record, Record record2) {
            int n = this.iFirstRecordIndex + this.iRecordCount - 1;
            if (n >= this.iRecords.length) {
                n -= this.iRecords.length;
            }
            int n2 = record2.iLength - record.iLength;
            int n3 = n;
            while (n3 != this.iFirstRecordIndex && this.iRecords[n3] != record) {
                if (n2 != 0) {
                    int n4 = n3;
                    this.iRecordStarts[n4] = this.iRecordStarts[n4] + (long)n2;
                }
                if (--n3 >= 0) continue;
                n3 = this.iRecords.length - 1;
            }
            if (this.iRecords[n3] == record) {
                RecordEvent recordEvent = new RecordEvent(DocumentEvent.EventType.REMOVE, n3);
                this.iRecords[n3] = record2;
                this.iElements[n3] = new RecordElement(n3);
                RecordEvent recordEvent2 = new RecordEvent(DocumentEvent.EventType.INSERT, n3);
                this.iLineCount += record2.getLineCount() - record.getLineCount();
                this.iCharCount += (long)n2;
                for (DocumentListener documentListener : this.iListeners) {
                    documentListener.removeUpdate(recordEvent);
                    documentListener.insertUpdate(recordEvent2);
                }
            }
        }

        void refresh() {
            RootEvent rootEvent = new RootEvent(DocumentEvent.EventType.CHANGE);
            for (DocumentListener documentListener : this.iListeners) {
                documentListener.changedUpdate(rootEvent);
            }
        }

        IntSet getSources() {
            return this.iSources;
        }

        void clear() {
            if (this.iRecordCount == 0) {
                return;
            }
            RootEvent rootEvent = new RootEvent(DocumentEvent.EventType.REMOVE);
            for (DocumentListener documentListener : this.iListeners) {
                documentListener.removeUpdate(rootEvent);
            }
            this.iCharCount = 0L;
            this.iLineCount = 0;
            for (int i = 0; i < this.iRecords.length; ++i) {
                this.iRecords[i] = null;
                this.iRecordStarts[i] = 0L;
                this.iElements[i] = null;
            }
            this.iToggleSet.clear();
            this.iFirstRecordIndex = 0;
            this.iRecordCount = 0;
            this.iToggleValue = false;
            this.iLastSource = -1;
        }

        void clear(int n) {
            if (this.iRecordCount == 0) {
                return;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.iFirstRecordIndex;
            int n6 = this.iFirstRecordIndex;
            int n7 = -1;
            boolean bl = false;
            for (int i = 0; i < this.iRecordCount; ++i) {
                RecordEvent recordEvent;
                boolean bl2;
                Record record = this.iRecords[n6];
                int n8 = record.getSource();
                boolean bl3 = bl2 = n8 == n;
                if (!bl2 && record instanceof CommandRecord) {
                    boolean bl4 = bl2 = !((CommandRecord)record).getDestinations().containsAny(this.iSources);
                }
                if (bl2) {
                    this.iRecords[n5] = this.iRecords[n6];
                    this.iRecordStarts[n5] = this.iRecordStarts[n6] - (long)n2;
                    this.iElements[n5] = this.iElements[n6];
                    this.iElements[n5].iRecordIndex = n5;
                    recordEvent = new RecordEvent(DocumentEvent.EventType.REMOVE, n5);
                    for (DocumentListener documentListener : this.iListeners) {
                        documentListener.removeUpdate(recordEvent);
                    }
                    ++n4;
                    n3 += record.getLineCount();
                    n2 += record.iLength;
                } else {
                    if (n4 == 0) {
                        bl = this.iToggleSet.get(n5);
                    } else {
                        this.iRecords[n5] = this.iRecords[n6];
                        this.iRecordStarts[n5] = this.iRecordStarts[n6] - (long)n2;
                        this.iElements[n5] = this.iElements[n6];
                        this.iElements[n5].iRecordIndex = n5;
                        if (n8 != 0 && n8 != n7 && n7 != -1) {
                            bl = !bl;
                        }
                        this.iToggleSet.set(n5, bl);
                        if (bl != this.iToggleSet.get(n6)) {
                            recordEvent = new RecordEvent(DocumentEvent.EventType.CHANGE, n5);
                            for (DocumentListener documentListener : this.iListeners) {
                                documentListener.changedUpdate(recordEvent);
                            }
                        }
                    }
                    if (n8 != 0) {
                        n7 = n8;
                    }
                    if (++n5 >= this.iRecords.length) {
                        n5 = 0;
                    }
                }
                if (++n6 < this.iRecords.length) continue;
                n6 = 0;
            }
            this.iRecordCount -= n4;
            this.iLineCount -= n3;
            this.iCharCount -= (long)n2;
            this.iToggleValue = bl;
            this.iLastSource = n7;
        }

        private int getRecordIndex(int n) {
            if (this.iRecordCount == 0 || n < 0 || n >= this.getLength()) {
                return -1;
            }
            int n2 = this.iFirstRecordIndex;
            int n3 = this.iFirstRecordIndex + this.iRecordCount - 1;
            long l = (long)n + this.iRecordStarts[this.iFirstRecordIndex];
            while (n2 < n3) {
                int n4;
                int n5 = (n2 + n3) / 2;
                int n6 = n4 = n5 < this.iRecords.length ? n5 : n5 - this.iRecords.length;
                if (l < this.iRecordStarts[n4]) {
                    n3 = n5;
                    continue;
                }
                if (l >= this.iRecordStarts[n4] + (long)this.iRecords[n4].iLength) {
                    n2 = n2 == n5 ? n2 + 1 : n5;
                    continue;
                }
                n2 = n3 = n5;
            }
            return n2 < this.iRecords.length ? n2 : n2 - this.iRecords.length;
        }

        private class RootRemoveAllChange
        implements DocumentEvent.ElementChange {
            private javax.swing.text.Element[] iAdded;
            private javax.swing.text.Element[] iRemoved;

            RootRemoveAllChange() {
                this.iAdded = new javax.swing.text.Element[]{OutputDocument.this.iEmptyElement};
                this.iRemoved = new javax.swing.text.Element[OutputDocument.this.iRecordCount];
                int n = OutputDocument.this.iFirstRecordIndex;
                for (int i = 0; i < OutputDocument.this.iRecordCount; ++i) {
                    this.iRemoved[i] = OutputDocument.this.iElements[i];
                    if (++n < OutputDocument.this.iRecords.length) continue;
                    n = 0;
                }
            }

            @Override
            public javax.swing.text.Element[] getChildrenAdded() {
                return this.iAdded;
            }

            @Override
            public javax.swing.text.Element[] getChildrenRemoved() {
                return this.iRemoved;
            }

            @Override
            public javax.swing.text.Element getElement() {
                return OutputDocument.this.iRootElement;
            }

            @Override
            public int getIndex() {
                return 0;
            }
        }

        private class RootEvent
        implements DocumentEvent {
            private DocumentEvent.EventType iType;
            private DocumentEvent.ElementChange iChange;

            RootEvent(DocumentEvent.EventType eventType) {
                this.iType = eventType;
                if (eventType == DocumentEvent.EventType.REMOVE) {
                    this.iChange = new RootRemoveAllChange();
                }
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public int getLength() {
                return OutputDocument.this.getLength();
            }

            @Override
            public int getOffset() {
                return 0;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return this.iType;
            }

            @Override
            public DocumentEvent.ElementChange getChange(javax.swing.text.Element element) {
                if (element != OutputDocument.this.iRootElement) {
                    return null;
                }
                return this.iChange;
            }
        }

        private class RecordChange
        implements DocumentEvent.ElementChange {
            private int iChildIndex;
            private javax.swing.text.Element[] iAdded = new javax.swing.text.Element[0];
            private javax.swing.text.Element[] iRemoved = new javax.swing.text.Element[0];

            RecordChange(DocumentEvent.EventType eventType, int n) {
                this.iChildIndex = n - OutputDocument.this.iFirstRecordIndex;
                if (this.iChildIndex < 0) {
                    this.iChildIndex += OutputDocument.this.iRecords.length;
                }
                if (eventType == DocumentEvent.EventType.INSERT) {
                    this.iAdded = new javax.swing.text.Element[]{OutputDocument.this.iElements[n]};
                    if (OutputDocument.this.iRecordCount == 1) {
                        this.iRemoved = new javax.swing.text.Element[]{OutputDocument.this.iEmptyElement};
                    }
                } else if (eventType == DocumentEvent.EventType.REMOVE) {
                    this.iRemoved = new javax.swing.text.Element[]{OutputDocument.this.iElements[n]};
                }
            }

            @Override
            public javax.swing.text.Element[] getChildrenAdded() {
                return this.iAdded;
            }

            @Override
            public javax.swing.text.Element[] getChildrenRemoved() {
                return this.iRemoved;
            }

            @Override
            public javax.swing.text.Element getElement() {
                return OutputDocument.this.iRootElement;
            }

            @Override
            public int getIndex() {
                return this.iChildIndex;
            }
        }

        private class RecordEvent
        implements DocumentEvent {
            private DocumentEvent.EventType iType;
            private Record iRecord;
            private int iOffset;
            private RecordChange iChange;

            RecordEvent(DocumentEvent.EventType eventType, int n) {
                this.iType = eventType;
                this.iRecord = OutputDocument.this.iRecords[n];
                this.iOffset = (int)(OutputDocument.this.iRecordStarts[n] - OutputDocument.this.iRecordStarts[OutputDocument.this.iFirstRecordIndex]);
                this.iChange = new RecordChange(eventType, n);
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public int getLength() {
                return this.iRecord.iLength;
            }

            @Override
            public int getOffset() {
                return this.iOffset;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return this.iType;
            }

            @Override
            public DocumentEvent.ElementChange getChange(javax.swing.text.Element element) {
                if (element != OutputDocument.this.iRootElement) {
                    return null;
                }
                return this.iChange;
            }
        }

        private class LeafElement
        implements javax.swing.text.Element {
            private javax.swing.text.Element iParent;
            private int iOffset;
            private int iLength;
            private TextStyleInfo iStyleInfo;
            private int iStyleIndex;

            LeafElement(javax.swing.text.Element element, int n, int n2, TextStyleInfo textStyleInfo, int n3) {
                this.iParent = element;
                this.iOffset = n;
                this.iLength = n2;
                this.iStyleInfo = textStyleInfo;
                this.iStyleIndex = n3;
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public javax.swing.text.Element getParentElement() {
                return this.iParent;
            }

            @Override
            public String getName() {
                return "content";
            }

            @Override
            public int getStartOffset() {
                return this.iParent.getStartOffset() + this.iOffset;
            }

            @Override
            public int getEndOffset() {
                return this.getStartOffset() + this.iLength;
            }

            @Override
            public int getElementIndex(int n) {
                return -1;
            }

            @Override
            public int getElementCount() {
                return 0;
            }

            @Override
            public javax.swing.text.Element getElement(int n) {
                return null;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }

            @Override
            public AttributeSet getAttributes() {
                Style style = OutputDocument.this.getStyle("default");
                if (this.iStyleInfo != null && this.iStyleIndex < this.iStyleInfo.getAttributesCount()) {
                    AttributeSet attributeSet = this.iStyleInfo.getAttributes(this.iStyleIndex);
                    if (attributeSet instanceof MutableAttributeSet) {
                        ((MutableAttributeSet)attributeSet).setResolveParent(style);
                    }
                    if (attributeSet != null) {
                        return attributeSet;
                    }
                }
                return style;
            }
        }

        private class EmptyElement
        implements javax.swing.text.Element {
            private EmptyElement() {
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public javax.swing.text.Element getParentElement() {
                return OutputDocument.this.iRootElement;
            }

            @Override
            public String getName() {
                return "paragraph";
            }

            @Override
            public int getStartOffset() {
                return 0;
            }

            @Override
            public int getEndOffset() {
                return 1;
            }

            @Override
            public int getElementIndex(int n) {
                return 0;
            }

            @Override
            public int getElementCount() {
                return 1;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public javax.swing.text.Element getElement(int n) {
                return new LeafElement(this, 0, 1, null, -1);
            }

            @Override
            public AttributeSet getAttributes() {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(OutputCollection.SOURCE_ATTRIBUTE, new Integer(Integer.MAX_VALUE));
                return simpleAttributeSet;
            }
        }

        private class LineElement
        implements javax.swing.text.Element {
            private RecordElement iParent;
            private int iLineIndex;

            LineElement(RecordElement recordElement, int n) {
                this.iParent = recordElement;
                this.iLineIndex = n;
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public javax.swing.text.Element getParentElement() {
                return this.iParent;
            }

            @Override
            public String getName() {
                return "paragraph";
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public int getStartOffset() {
                int n = this.iLineIndex == 0 ? 0 : this.iParent.getRecord().getLineEnd(this.iLineIndex - 1) + 1;
                return this.iParent.getStartOffset() + n;
            }

            @Override
            public int getEndOffset() {
                Record record = this.iParent.getRecord();
                int n = this.iLineIndex >= record.getLineCount() - 1 ? record.iLength : record.getLineEnd(this.iLineIndex) + 1;
                return this.iParent.getStartOffset() + n;
            }

            @Override
            public AttributeSet getAttributes() {
                int n = this.iParent.iRecordIndex;
                int n2 = OutputDocument.this.iToggleSet.get(n) ? 1 : 0;
                AttributeSet attributeSet = OutputCollection.this.fToggleAttributes[n2];
                if (this.iLineIndex == 0) {
                    Record record = OutputDocument.this.iRecords[n];
                    int n3 = record.getSource();
                    if (OutputDocument.this.iRecordCount > 1 && n != OutputDocument.this.iFirstRecordIndex) {
                        Record record2;
                        int n4;
                        int n5 = n - 1;
                        if (n5 < 0) {
                            n5 = OutputDocument.this.iRecords.length - 1;
                        }
                        if (n3 == (n4 = (record2 = OutputDocument.this.iRecords[n5]).getSource())) {
                            n3 = -n3;
                        }
                    }
                    if (record instanceof CommandRecord) {
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(OutputCollection.PROMPT_ATTRIBUTE, ((CommandRecord)record).getPromptString());
                        simpleAttributeSet.addAttribute(OutputCollection.SOURCE_ATTRIBUTE, new Integer(0));
                        attributeSet = simpleAttributeSet;
                    } else if (n3 > 0) {
                        attributeSet = OutputCollection.this.fOutputAttributes[n2][n3];
                    }
                }
                return attributeSet;
            }

            @Override
            public int getElementIndex(int n) {
                int n2;
                Record record = this.iParent.getRecord();
                TextStyleInfo textStyleInfo = record.getLineStyleInfo(this.iLineIndex);
                if (textStyleInfo == null) {
                    return 0;
                }
                int n3 = n - this.getStartOffset();
                for (n2 = 0; n2 < textStyleInfo.getAttributesCount() && n3 >= textStyleInfo.getAttributesStart(n2) + textStyleInfo.getAttributesLength(n2); ++n2) {
                }
                return n2;
            }

            @Override
            public int getElementCount() {
                Record record = this.iParent.getRecord();
                TextStyleInfo textStyleInfo = record.getLineStyleInfo(this.iLineIndex);
                if (textStyleInfo == null) {
                    return 1;
                }
                int n = textStyleInfo.getAttributesCount();
                int n2 = textStyleInfo.getAttributesStart(n - 1) + textStyleInfo.getAttributesLength(n - 1);
                if (record.iLength > n2) {
                    ++n;
                }
                return n;
            }

            @Override
            public javax.swing.text.Element getElement(int n) {
                int n2;
                int n3;
                Record record = this.iParent.getRecord();
                TextStyleInfo textStyleInfo = record.getLineStyleInfo(this.iLineIndex);
                if (textStyleInfo == null) {
                    int n4 = this.getEndOffset() - this.getStartOffset();
                    return new LeafElement(this, 0, n4, null, -1);
                }
                if (n < textStyleInfo.getAttributesCount()) {
                    n3 = textStyleInfo.getAttributesStart(n);
                    n2 = textStyleInfo.getAttributesLength(n);
                } else {
                    n3 = textStyleInfo.getAttributesStart(n - 1) + textStyleInfo.getAttributesLength(n - 1);
                    n2 = record.iLength - n3;
                }
                return new LeafElement(this, n3, n2, textStyleInfo, n);
            }
        }

        private class RecordElement
        implements javax.swing.text.Element {
            int iRecordIndex;

            RecordElement(int n) {
                this.iRecordIndex = n;
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public javax.swing.text.Element getParentElement() {
                return OutputDocument.this.iRootElement;
            }

            @Override
            public String getName() {
                return "section";
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public int getStartOffset() {
                return (int)(OutputDocument.this.iRecordStarts[this.iRecordIndex] - OutputDocument.this.iRecordStarts[OutputDocument.this.iFirstRecordIndex]);
            }

            @Override
            public int getEndOffset() {
                return this.getStartOffset() + ((OutputDocument)OutputDocument.this).iRecords[this.iRecordIndex].iLength;
            }

            @Override
            public AttributeSet getAttributes() {
                return OutputDocument.this.iStyleContext.getStyle("default");
            }

            @Override
            public int getElementIndex(int n) {
                int n2;
                Record record = OutputDocument.this.iRecords[this.iRecordIndex];
                int n3 = record.getLineCount();
                if (n3 <= 1) {
                    return 0;
                }
                int n4 = n - this.getStartOffset();
                for (n2 = 0; n2 < n3 - 1 && n4 > record.getLineEnd(n2); ++n2) {
                }
                return n2;
            }

            @Override
            public int getElementCount() {
                return OutputDocument.this.iRecords[this.iRecordIndex].getLineCount();
            }

            @Override
            public javax.swing.text.Element getElement(int n) {
                return new LineElement(this, n);
            }

            private Record getRecord() {
                return OutputDocument.this.iRecords[this.iRecordIndex];
            }
        }

        private class RootElement
        implements javax.swing.text.Element {
            private RootElement() {
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public javax.swing.text.Element getParentElement() {
                return null;
            }

            @Override
            public String getName() {
                return "section";
            }

            @Override
            public int getStartOffset() {
                return 0;
            }

            @Override
            public int getEndOffset() {
                return OutputDocument.this.getLength();
            }

            @Override
            public AttributeSet getAttributes() {
                return OutputDocument.this.iStyleContext.getStyle("default");
            }

            @Override
            public int getElementCount() {
                return OutputDocument.this.iRecordCount == 0 ? 1 : OutputDocument.this.iRecordCount;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public int getElementIndex(int n) {
                int n2 = OutputDocument.this.getRecordIndex(n);
                if (n2 < 0) {
                    return 0;
                }
                if (n2 >= OutputDocument.this.iFirstRecordIndex) {
                    return n2 - OutputDocument.this.iFirstRecordIndex;
                }
                return n2 + OutputDocument.this.iRecords.length - OutputDocument.this.iFirstRecordIndex;
            }

            @Override
            public javax.swing.text.Element getElement(int n) {
                if (OutputDocument.this.iRecordCount == 0) {
                    return OutputDocument.this.iEmptyElement;
                }
                int n2 = OutputDocument.this.iFirstRecordIndex + n;
                if (n2 >= OutputDocument.this.iRecords.length) {
                    n2 -= OutputDocument.this.iRecords.length;
                }
                return OutputDocument.this.iElements[n2];
            }
        }

        private class CountBasedPosition
        implements Position {
            private long iCharCountAtPosition;

            CountBasedPosition(long l) {
                this.iCharCountAtPosition = l;
            }

            @Override
            public int getOffset() {
                if (OutputDocument.this.iRecordCount == 0) {
                    return 0;
                }
                long l = this.iCharCountAtPosition - OutputDocument.this.iRecordStarts[OutputDocument.this.iFirstRecordIndex];
                if (l < 0L) {
                    return 0;
                }
                return (int)l;
            }
        }
    }

    class CommandRecord
    extends Record {
        private IntSet iDestinations;
        private char[] iText;
        private int iPromptLength;
        private boolean iBelongsToBatch;
        private boolean iCausedError;
        private int iRepeatCount;
        private boolean iIsSessionHeader;
        private boolean iIsOutputAvailable;
        private int iAccumulatorOffset;

        private CommandRecord() {
            this.iRepeatCount = 1;
            this.iIsOutputAvailable = true;
        }

        private CommandRecord(IntSet intSet, TextStyleInfo textStyleInfo, char[] cArray, int n, boolean bl) {
            super(cArray.length - n, textStyleInfo);
            this.iRepeatCount = 1;
            this.iIsOutputAvailable = true;
            this.iDestinations = intSet == null ? null : new IntSet(intSet);
            this.iText = cArray;
            this.iPromptLength = n;
            this.iBelongsToBatch = bl;
        }

        public String toString() {
            return this.getCommandString();
        }

        String getCommandString() {
            return new String(this.iText, this.iPromptLength, this.iLength - 1);
        }

        String getPromptString() {
            return new String(this.iText, 0, this.iPromptLength);
        }

        boolean isComment() {
            int n;
            for (n = this.iPromptLength; n < this.iText.length && this.iText[n] == ' '; ++n) {
            }
            return n < this.iText.length && this.iText[n] == '%';
        }

        IntSet getDestinations() {
            return this.iDestinations;
        }

        int getRepeatCount() {
            return this.iRepeatCount;
        }

        synchronized boolean causedError() {
            return this.iCausedError;
        }

        synchronized void setCausedError(boolean bl) {
            this.iCausedError = bl;
        }

        boolean isOutputAvailable() {
            return this.iIsOutputAvailable;
        }

        Element toXML(org.w3c.dom.Document document) {
            Element element = document.createElement(OutputCollection.XML_COMMAND_TAG);
            if (this.iPromptLength > 0) {
                element.setAttribute(OutputCollection.XML_PROMPT_ATTRIBUTE, this.getPromptString());
            }
            if (this.iCausedError) {
                element.setAttribute(OutputCollection.XML_ERROR_ATTRIBUTE, OutputCollection.XML_YES_VALUE);
            }
            if (this.iRepeatCount > 1) {
                element.setAttribute(OutputCollection.XML_REPEAT_ATTRIBUTE, Integer.toString(this.iRepeatCount));
            }
            Text text = document.createTextNode(this.getCommandString());
            element.appendChild(text);
            return element;
        }

        private CommandRecord(SimpleElement simpleElement, boolean bl, String[] stringArray) {
            String string;
            String string2;
            this.iRepeatCount = 1;
            this.iIsOutputAvailable = true;
            this.iIsSessionHeader = bl;
            String string3 = simpleElement.getAttribute(OutputCollection.XML_PROMPT_ATTRIBUTE);
            String string4 = simpleElement.getText();
            this.iLength = string4.length() + 1;
            if (string3 == null) {
                string2 = stringArray[0];
                if (string2 == null || bl) {
                    this.iStyleInfo = new SyntaxTextStyleInfo(TextSyntax.M, string4);
                    string4 = string4 + "\n";
                    string2 = bl ? null : string4;
                } else {
                    this.iAccumulatorOffset = string2.length();
                    string4 = string4 + "\n";
                    string2 = string2 + string4;
                }
                stringArray[0] = string2;
                this.iText = string4.toCharArray();
            } else {
                this.iStyleInfo = new SyntaxTextStyleInfo(TextSyntax.M, string4);
                stringArray[0] = string4 = string4 + "\n";
                this.iPromptLength = string3.length();
                this.iText = new char[string4.length() + this.iPromptLength];
                string3.getChars(0, this.iPromptLength, this.iText, 0);
                string4.getChars(0, string4.length(), this.iText, this.iPromptLength);
            }
            string2 = simpleElement.getAttribute(OutputCollection.XML_ERROR_ATTRIBUTE);
            if (string2 != null && OutputCollection.XML_YES_VALUE.equals(string2)) {
                this.iCausedError = true;
            }
            if ((string = simpleElement.getAttribute(OutputCollection.XML_REPEAT_ATTRIBUTE)) != null) {
                this.iRepeatCount = Integer.parseInt(string);
            }
        }

        void setStyleInfo(SyntaxTextStyleInfo syntaxTextStyleInfo) {
            this.iStyleInfo = new SubRegionStyleInfo(syntaxTextStyleInfo, this.iAccumulatorOffset, this.iLength - 1);
        }

        static /* synthetic */ char[] access$302(CommandRecord commandRecord, char[] cArray) {
            commandRecord.iText = cArray;
            return cArray;
        }
    }

    class OutputRecord
    extends Record {
        int iSource;
        private int iBufferPosition;
        private int[] iLineEnds;
        private TextStyleInfo[] iLineStyleInfo;
        private BackspaceScanner iBackspaceScanner;

        private OutputRecord(int n, int n2, int[] nArray, TextStyleInfo textStyleInfo, int n3) {
            super(n2, textStyleInfo);
            this.iSource = n;
            this.iLineEnds = nArray;
            this.iBufferPosition = n3;
            if (textStyleInfo != null) {
                int n4 = this.getLineCount();
                this.iLineStyleInfo = new TextStyleInfo[n4];
                if (n4 == 1) {
                    this.iLineStyleInfo[0] = textStyleInfo;
                } else {
                    int n5 = 0;
                    for (int i = 0; i < n4; ++i) {
                        int n6 = this.iLineEnds[i] - n5 + 1;
                        this.iLineStyleInfo[i] = new SubRegionStyleInfo(textStyleInfo, n5, n6);
                        n5 = this.iLineEnds[i] + 1;
                    }
                }
            }
        }

        private OutputRecord(int n, BackspaceScanner backspaceScanner) {
            super(0, null);
            this.iSource = n;
            this.iBackspaceScanner = backspaceScanner;
        }

        @Override
        int getSource() {
            return this.iSource;
        }

        @Override
        int getLineCount() {
            return this.iLineEnds.length;
        }

        @Override
        int getLineEnd(int n) {
            return this.iLineEnds[n];
        }

        @Override
        TextStyleInfo getLineStyleInfo(int n) {
            return this.iLineStyleInfo == null ? null : this.iLineStyleInfo[n];
        }

        public String toString() {
            CharBuffer charBuffer = ((OutputCollection)OutputCollection.this).fOutputBuffers[this.iSource].iReadBuffer;
            int n = charBuffer.position();
            charBuffer.position(this.iBufferPosition);
            char[] cArray = new char[this.iLength];
            charBuffer.get(cArray, 0, cArray.length);
            charBuffer.position(n);
            return new String(cArray);
        }

        static /* synthetic */ int[] access$3002(OutputRecord outputRecord, int[] nArray) {
            outputRecord.iLineEnds = nArray;
            return nArray;
        }
    }

    private class Record {
        int iLength;
        TextStyleInfo iStyleInfo;

        private Record() {
        }

        private Record(int n, TextStyleInfo textStyleInfo) {
            this.iLength = n;
            this.iStyleInfo = textStyleInfo;
        }

        int getSource() {
            return 0;
        }

        int getLineCount() {
            return 1;
        }

        int getLineEnd(int n) {
            return this.iLength;
        }

        TextStyleInfo getStyleInfo() {
            return this.iStyleInfo;
        }

        TextStyleInfo getLineStyleInfo(int n) {
            return this.iStyleInfo;
        }

        boolean matches(String string) {
            return this.toString().startsWith(string);
        }
    }

    private class OutputEvent
    implements Runnable {
        boolean iIsPending;

        private OutputEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int n;
                Object object;
                Object object2;
                int n2;
                boolean bl;
                OutputRecord outputRecord;
                Object object3 = this;
                synchronized (object3) {
                    outputRecord = (OutputRecord)OutputCollection.this.fOutputQueue.poll();
                    if (outputRecord == null) {
                        this.iIsPending = false;
                        this.notifyAll();
                        break;
                    }
                }
                object3 = OutputCollection.this.fOutputBuffers[outputRecord.iSource];
                int n3 = ((OutputBuffer)object3).iReadStart;
                boolean bl2 = bl = outputRecord.iBackspaceScanner != null;
                if (bl) {
                    n2 = 0;
                    int n4 = outputRecord.iBackspaceScanner.getNetOverwriteCount();
                    int n5 = OutputCollection.this.fSessionRecords.size();
                    object2 = OutputCollection.this.fSessionRecords.listIterator(n5);
                    while (object2.hasPrevious() && (n4 > 0 || n2 == 0)) {
                        Object object42;
                        object = (Record)object2.previous();
                        if (((Record)object).getSource() != outputRecord.iSource) continue;
                        Object object5 = (OutputRecord)object;
                        n2 = 1;
                        if (n4 > ((OutputRecord)object5).iLength || n4 == ((OutputRecord)object5).iLength && outputRecord.iBackspaceScanner.getCondensedLength() == 0) {
                            n4 -= ((OutputRecord)object5).iLength;
                            object2.remove();
                            for (Object object42 : OutputCollection.this.fDocuments) {
                                if (!((OutputDocument)object42).iSources.contains(outputRecord.iSource)) continue;
                                ((OutputDocument)object42).removeRecent(object);
                            }
                            continue;
                        }
                        int n6 = ((OutputRecord)object5).iBufferPosition + ((OutputRecord)object5).iLength - n4;
                        ((OutputBuffer)object3).iWriteBuffer.position(n6);
                        ((OutputBuffer)object3).iWriteBuffer.put(outputRecord.iBackspaceScanner.getCondensedText(), outputRecord.iBackspaceScanner.getCondensedOffset(), outputRecord.iBackspaceScanner.getCondensedLength());
                        outputRecord.iBufferPosition = ((OutputRecord)object5).iBufferPosition;
                        outputRecord.iLength = ((OutputBuffer)object3).iWriteBuffer.position() - ((OutputRecord)object5).iBufferPosition;
                        OutputRecord.access$3002(outputRecord, OutputCollection.getLineEnds(((OutputBuffer)object3).iReadBuffer, outputRecord.iBufferPosition, outputRecord.iLength));
                        outputRecord.iBackspaceScanner = null;
                        object2.set(outputRecord);
                        object42 = OutputCollection.this.fDocuments.iterator();
                        while (object42.hasNext()) {
                            OutputDocument outputDocument = (OutputDocument)object42.next();
                            if (!outputDocument.iSources.contains(outputRecord.iSource)) continue;
                            outputDocument.replace(object, outputRecord);
                        }
                        n = outputRecord.iBufferPosition + outputRecord.iLength;
                        ((OutputBuffer)object3).setOccupiedRange(n3, n);
                        break;
                    }
                    if (n2 == 0) {
                        bl = false;
                        outputRecord.iBufferPosition = ((OutputBuffer)object3).iWriteBuffer.position();
                        outputRecord.iLength = outputRecord.iBackspaceScanner.getCondensedLength();
                        ((OutputBuffer)object3).iWriteBuffer.put(outputRecord.iBackspaceScanner.getCondensedText(), outputRecord.iBackspaceScanner.getCondensedOffset(), outputRecord.iLength);
                        OutputRecord.access$3002(outputRecord, OutputCollection.getLineEnds(((OutputBuffer)object3).iReadBuffer, outputRecord.iBufferPosition, outputRecord.iLength));
                        outputRecord.iBackspaceScanner = null;
                    }
                }
                n = outputRecord.iBufferPosition + outputRecord.iLength;
                n2 = 0;
                while (n2 < OutputCollection.this.fOutputHeadroom) {
                    n2 = n >= n3 ? Math.max(n3, ((OutputBuffer)object3).iReadBuffer.capacity() - n) : n3 - n;
                    if (n2 >= OutputCollection.this.fOutputHeadroom) continue;
                    Iterator iterator = OutputCollection.this.fSessionRecords.iterator();
                    Record record = null;
                    while (iterator.hasNext() && (record = (Record)iterator.next()).getSource() != outputRecord.iSource) {
                        if (!(record instanceof CommandRecord) || !((IntSet)(object2 = ((CommandRecord)record).getDestinations())).contains(outputRecord.iSource)) continue;
                        ((IntSet)object2).remove(outputRecord.iSource);
                        for (Object object5 : OutputCollection.this.fDocuments) {
                            if (!((OutputDocument)object5).iSources.contains(outputRecord.iSource) || ((OutputDocument)object5).iSources.containsAny((IntSet)object2)) continue;
                            ((OutputDocument)object5).remove(record);
                        }
                        if (!((IntSet)object2).isEmpty()) continue;
                        iterator.remove();
                        ((CommandRecord)record).iIsOutputAvailable = false;
                    }
                    if (!(record instanceof OutputRecord)) continue;
                    iterator.remove();
                    object2 = OutputCollection.this.fDocuments.iterator();
                    while (object2.hasNext()) {
                        object = (OutputDocument)object2.next();
                        if (!((OutputDocument)object).includeRecord(record)) continue;
                        ((OutputDocument)object).remove(record);
                    }
                    n3 = ((OutputRecord)record).iBufferPosition + record.iLength;
                }
                if (!bl) {
                    OutputCollection.this.addRecord(outputRecord);
                }
                ((OutputBuffer)object3).setOccupiedRange(n3, n);
            }
        }
    }

    private class OutputBuffer {
        CharBuffer iWriteBuffer;
        CharBuffer iReadBuffer;
        int iReadStart;
        int iReadEnd;
        volatile boolean iExpectingContinuation;

        private OutputBuffer() {
        }

        synchronized boolean hasRoomFor(int n) {
            int n2 = this.iWriteBuffer.position() + n;
            if (n2 > this.iWriteBuffer.capacity()) {
                n2 = n;
                this.iWriteBuffer.position(0);
            }
            if (this.iReadStart <= this.iReadEnd) {
                return n2 < this.iReadStart || n2 > this.iReadEnd;
            }
            return n2 > this.iReadEnd && n2 < this.iReadStart;
        }

        synchronized void setOccupiedRange(int n, int n2) {
            this.iReadStart = n;
            this.iReadEnd = n2;
        }
    }
}

