/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.LabsState;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Prompt {
    private Labs fLabs;
    private LabsState fLabsState;
    private IntSet fTargetLabs;
    private IntSet fAvailableTargets;
    private LabsState.State fAvailableState;
    private String fPromptString;
    private List<ChangeListener> fListeners;
    private ChangeEvent fChangeEvent;
    private static final String SERIAL_PROMPT = ">>";
    private static final String SERIAL_DEBUG_PROMPT = "K>>";
    private static final String ALL_PROMPT = "P>>";
    private static final String ALL_DEBUG_PROMPT = "PK>>";
    private static final String SOME_PROMPT = "*>>";
    private static final String SOME_DEBUG_PROMPT = "*K>>";

    Prompt(Labs labs, LabsState labsState) {
        this.fLabs = labs;
        this.fLabsState = labsState;
        this.fTargetLabs = Utilities.allLabs(labs);
        this.fLabsState.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Prompt.this.update();
            }
        });
        this.update();
    }

    IntSet getTargetLabs() {
        return new IntSet(this.fTargetLabs);
    }

    void setTargetLabs(IntSet intSet) {
        this.fTargetLabs = intSet;
        this.update();
    }

    IntSet getAvailableTargets() {
        return this.fAvailableTargets;
    }

    public String toString() {
        return this.fPromptString;
    }

    static String getLongestString(int n) {
        return n > 1 ? ALL_DEBUG_PROMPT : SERIAL_DEBUG_PROMPT;
    }

    void addChangeListener(ChangeListener changeListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<ChangeListener>();
            this.fChangeEvent = new ChangeEvent(this);
        }
        this.fListeners.add(changeListener);
    }

    void removeChangeListener(ChangeListener changeListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(changeListener);
        }
    }

    private void update() {
        if (this.fTargetLabs.size() == 1) {
            int n = this.fTargetLabs.first();
            this.fAvailableState = this.fLabsState.getState(n);
            this.fAvailableTargets = this.fAvailableState == LabsState.State.BUSY ? new IntSet() : new IntSet(n);
        } else {
            this.fAvailableTargets = new IntSet(this.fTargetLabs);
            this.fAvailableState = LabsState.State.BUSY;
            IntSet intSet = this.fLabsState.getLabsInState(LabsState.State.STOPPED);
            if (!intSet.isEmpty()) {
                this.fAvailableTargets.retainAll(intSet);
                if (!this.fAvailableTargets.isEmpty()) {
                    this.fAvailableState = LabsState.State.STOPPED;
                } else {
                    this.fAvailableTargets = new IntSet(this.fTargetLabs);
                }
            }
            if (this.fAvailableState == LabsState.State.BUSY) {
                IntSet intSet2 = this.fLabsState.getLabsInState(LabsState.State.BUSY);
                if (!intSet2.isEmpty()) {
                    this.fAvailableTargets.retainAll(intSet2);
                    if (!this.fAvailableTargets.isEmpty()) {
                        this.fAvailableTargets = new IntSet();
                    }
                }
                if (!this.fAvailableTargets.isEmpty()) {
                    this.fAvailableTargets = new IntSet(this.fTargetLabs);
                    this.fAvailableState = LabsState.State.IDLE;
                }
            }
        }
        String string = "";
        switch (this.fAvailableState) {
            case BUSY: {
                string = "";
                break;
            }
            case STOPPED: {
                if (this.fAvailableTargets.isEmpty()) {
                    string = "";
                    break;
                }
                if (this.fLabs.getNumLabs() == 1) {
                    string = SERIAL_DEBUG_PROMPT;
                    break;
                }
                if (this.fAvailableTargets.size() == 1) {
                    string = Integer.toString(this.fAvailableTargets.first()) + SERIAL_DEBUG_PROMPT;
                    break;
                }
                if (this.fAvailableTargets.size() < this.fLabs.getNumLabs()) {
                    string = SOME_DEBUG_PROMPT;
                    break;
                }
                string = ALL_DEBUG_PROMPT;
                break;
            }
            case IDLE: {
                string = this.fAvailableTargets.size() < this.fTargetLabs.size() ? "" : (this.fLabs.getNumLabs() == 1 ? SERIAL_PROMPT : (this.fAvailableTargets.size() == 1 ? Integer.toString(this.fAvailableTargets.first()) + SERIAL_PROMPT : (this.fAvailableTargets.size() < this.fLabs.getNumLabs() ? SOME_PROMPT : ALL_PROMPT)));
            }
        }
        if (!string.equals(this.fPromptString)) {
            this.fPromptString = string;
            if (this.fListeners != null) {
                for (ChangeListener changeListener : this.fListeners) {
                    changeListener.stateChanged(this.fChangeEvent);
                }
            }
        }
    }
}

