/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class BufferHelper
implements Serializable {
    private transient ByteBufferHandle[] fBufferHandles;
    private Object[] fAllData;
    private Integer[] fBufCount;
    private Boolean[] fBufIsArray;

    public BufferHelper(Object object) {
        this.fAllData = object == null ? null : (object instanceof Object[] ? (Object[])object : new Object[]{object});
        this.disentangleByteBuffers();
    }

    public ByteBufferHandle[] getByteBuffers() {
        return Arrays.copyOf(this.fBufferHandles, this.fBufferHandles.length);
    }

    public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
        assert (this.fBufferHandles == null) : "Appears we have already set the ByteBuffers for this helper";
        this.fBufferHandles = Arrays.copyOf(byteBufferHandleArray, byteBufferHandleArray.length);
    }

    public Object[] getAll() {
        if (this.fAllData == null) {
            return null;
        }
        return this.reentangleByteBuffers();
    }

    private void disentangleByteBuffers() {
        int n = this.fAllData == null ? 0 : this.fAllData.length;
        this.fBufCount = new Integer[n];
        this.fBufIsArray = new Boolean[n];
        LinkedList<ByteBufferHandle> linkedList = new LinkedList<ByteBufferHandle>();
        for (int i = 0; i < n; ++i) {
            Object object = this.fAllData[i];
            if (object instanceof ByteBufferHandle) {
                linkedList.add((ByteBufferHandle)object);
                this.fBufCount[i] = 1;
                this.fBufIsArray[i] = false;
                this.fAllData[i] = null;
                continue;
            }
            if (object instanceof ByteBufferHandle[]) {
                ByteBufferHandle[] byteBufferHandleArray = (ByteBufferHandle[])object;
                linkedList.addAll(Arrays.asList(byteBufferHandleArray));
                this.fBufCount[i] = byteBufferHandleArray.length;
                this.fBufIsArray[i] = true;
                this.fAllData[i] = null;
                continue;
            }
            this.fBufCount[i] = 0;
            this.fBufIsArray[i] = false;
        }
        this.fBufferHandles = linkedList.toArray(new ByteBufferHandle[linkedList.size()]);
    }

    private Object[] reentangleByteBuffers() {
        assert (this.fAllData != null);
        int n = this.fAllData.length;
        Object[] objectArray = Arrays.copyOf(this.fAllData, n);
        List<ByteBufferHandle> list = new LinkedList<ByteBufferHandle>(Arrays.asList(this.fBufferHandles));
        for (int i = 0; i < n; ++i) {
            if (this.fBufIsArray[i].booleanValue()) {
                int n2 = this.fBufCount[i];
                assert (list.size() >= n2);
                objectArray[i] = list.subList(0, n2).toArray(new ByteBufferHandle[n2]);
                list = list.subList(n2, list.size());
                continue;
            }
            if (this.fBufCount[i] <= 0) continue;
            assert (this.fBufCount[i] == 1) : "fBufCount for non-array should be 1";
            assert (list.size() >= 1);
            objectArray[i] = list.remove(0);
        }
        return objectArray;
    }
}

