/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.LabsStateListener;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTracker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RawMatlabStatusTracker;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsResponseVector;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class LabsStateTrackerImpl
implements LabsStateTracker {
    private long fSequenceNumber;
    private final LabsResponseVector fCommandResponses;
    private final RawMatlabStatusTracker fExecStatus;
    private LabsStateListener fIdleListener;
    private final ExecutorService fListenerExec;
    private final ErrorHandler fErrorHandler;
    private static final int NO_COMMAND_RUNNING = -1;

    public LabsStateTrackerImpl(SessionService sessionService, List<ProcessInstance> list) {
        this.fListenerExec = sessionService.getListenerExecutor();
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fSequenceNumber = -1L;
        this.fExecStatus = new RawMatlabStatusTracker(list);
        this.fIdleListener = null;
        this.fCommandResponses = new LabsResponseVector<ProcessInstance>(list);
    }

    @Override
    public synchronized void cmdStarting(long l) {
        assert (this.fSequenceNumber == -1L) : "Cannot execute two commands simultaneously on the labs.";
        this.fSequenceNumber = l;
        this.fCommandResponses.clearAll();
        this.fExecStatus.prepareForNewCommand();
    }

    @Override
    public synchronized void interruptStarting() {
        this.fExecStatus.setPossiblyInterrupted();
    }

    @Override
    public synchronized void outputArrived(long l, ProcessInstance processInstance) {
        assert (this.fSequenceNumber == l) : "Received command window output from lab " + processInstance + " for an unknown command " + l + ".\n";
    }

    private synchronized void updateIfComplete() {
        if (this.fCommandResponses.hasAllResponses()) {
            this.fSequenceNumber = -1L;
            this.fCommandResponses.clearAll();
            if (!this.fExecStatus.isOK()) {
                String string = "Command execution status for command is inconsistent across the labs:\n" + this.fExecStatus.toString();
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
                assert (false) : string;
            }
            if (this.fIdleListener != null) {
                this.runIdleListener();
            }
        }
    }

    @Override
    public synchronized void statusArrived(int n, long l, ProcessInstance processInstance) {
        assert (this.fSequenceNumber == l) : "Received command execution status from lab " + processInstance + " for an unknown command " + l + ".\n";
        this.fCommandResponses.receivedResponse(processInstance);
        this.fExecStatus.setStatus(n, processInstance);
        this.updateIfComplete();
    }

    @Override
    public synchronized void setIdleListener(LabsStateListener labsStateListener) {
        assert (this.fIdleListener == null) : "Setting the idle listener twice.";
        this.fIdleListener = labsStateListener;
    }

    @Override
    public synchronized void communicationLost(ProcessInstance processInstance) {
        this.fCommandResponses.communicationLost(processInstance);
        this.fExecStatus.communicationLost(processInstance);
        this.updateIfComplete();
    }

    @Override
    public synchronized void communicationEstablished(ProcessInstance processInstance) {
        this.fCommandResponses.communicationEstablished(processInstance);
        this.fExecStatus.communicationEstablished(processInstance);
    }

    private void runIdleListener() {
        try {
            this.fListenerExec.execute(new Runnable(){
                final LabsStateListener fListener;
                {
                    this.fListener = LabsStateTrackerImpl.this.fIdleListener;
                }

                @Override
                public void run() {
                    try {
                        this.fListener.labsAreIdle();
                    }
                    catch (Throwable throwable) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "LabsStateListener threw a Throwable.", throwable);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }
}

