/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.MFevalLargeDataCommand;
import com.mathworks.toolbox.distcomp.pmode.MInterrupt;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.io.ResponseTracker;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.DefaultFinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.RemoteMatlabException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ParforControllerImpl
implements ParforController {
    private final ResourceManager fResourceManager;
    private final RoleOutputGroup fOutGroup;
    private final SessionService fSessionService;
    private DrainableOutput fDrainableOutput;
    private int fNumLabsAcquired;
    private int fNumFinalIntervals;
    private AtomicInteger fNumMessagesInFlight;
    private boolean fLoopInterrupted;
    private LoopStateTracker fLoopStateTracker;
    private ByteBufferHandle[] fInitData;
    private final Deque<Interval> fPendingQueue;
    private final Deque<ProcessInstance> fAvailableLabs = new LinkedList<ProcessInstance>();
    private final List<ProcessInstance> fAcquiredLabs = new LinkedList<ProcessInstance>();
    private final LinkedBlockingQueue<ParforController.IntervalResult> fIntervalCompleteQueue = new LinkedBlockingQueue();
    private final CountDownLatch fCompletedLatch = new CountDownLatch(1);
    private int fNumLabsNotified;
    private final BroadcastPolicy fPolicy;

    public static ParforControllerImpl create(SessionService sessionService, BroadcastPolicy broadcastPolicy) throws SessionDestroyedException, CannotAcquireLabsException {
        Object object;
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating a new ParforControllerImpl");
        ResourceManager resourceManager = sessionService.getResourceManager();
        if (!sessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        try {
            object = resourceManager.acquireCurrentHolderToken(60000L);
        }
        catch (InterruptedException interruptedException) {
            object = null;
        }
        if (object == null) {
            throw new CannotAcquireLabsException(60000L);
        }
        ParforControllerImpl parforControllerImpl = new ParforControllerImpl(sessionService, broadcastPolicy);
        parforControllerImpl.init();
        resourceManager.setCurrentHolder(parforControllerImpl, object);
        PackageInfo.LOGGER.finest("Freshly created ParforControllerImpl notifying acquired.");
        parforControllerImpl.notifyAcquiredWorkers(sessionService.getPoolSize());
        return parforControllerImpl;
    }

    private ParforControllerImpl(SessionService sessionService, BroadcastPolicy broadcastPolicy) {
        this.fOutGroup = sessionService.getRoleCommGroup();
        this.fSessionService = sessionService;
        this.fPendingQueue = new LinkedList<Interval>();
        this.fLoopStateTracker = new LoopStateTracker(null);
        this.fNumFinalIntervals = 0;
        this.fLoopInterrupted = false;
        this.fNumMessagesInFlight = new AtomicInteger(0);
        this.fResourceManager = sessionService.getResourceManager();
        this.fPolicy = broadcastPolicy;
    }

    private void init() {
    }

    @Override
    public synchronized int acquireLabs(int n) throws SessionDestroyedException {
        assert (this.fLoopStateTracker.getState() == LoopState.Initialized) : "Invalid LoopState - should be Initialized but is " + (Object)((Object)this.fLoopStateTracker.getState());
        assert (n > 0) : "Number of labs requested in acquireLabs must be greater than zero";
        if (!this.fSessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        List<ProcessInstance> list = this.fOutGroup.getConnectedProcessInstances();
        assert (!list.isEmpty()) : "No possible labs to acquire";
        this.fNumLabsAcquired = Math.min(n, list.size());
        list = list.subList(0, this.fNumLabsAcquired);
        this.fAcquiredLabs.addAll(list);
        this.fLoopStateTracker = new LoopStateTracker(list);
        for (ProcessInstance processInstance : list) {
            this.makeLabAvailable(processInstance);
            this.fLoopStateTracker.setState(processInstance, LoopState.Acquired);
        }
        this.fDrainableOutput = new DrainableOutputImpl(list, false);
        PackageInfo.LOGGER.finest("About to notify release/acquire of " + this.fNumLabsAcquired);
        this.notifyReleaseWorkers();
        this.notifyAcquiredWorkers(this.fNumLabsAcquired);
        return this.fNumLabsAcquired;
    }

    @Override
    public synchronized BlockingQueue<ParforController.IntervalResult> getIntervalCompleteQueue() {
        return this.fIntervalCompleteQueue;
    }

    @Override
    public boolean awaitCompleted(int n, TimeUnit timeUnit) {
        try {
            return this.fCompletedLatch.await(n, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public synchronized int[] pGetIntervalNumbers() {
        return new int[]{this.fNumLabsAcquired, this.fNumFinalIntervals};
    }

    public synchronized boolean pGetLoopInterrupted() {
        return this.fLoopInterrupted;
    }

    public synchronized LoopStateTracker pGetLoopStateTracker() {
        return this.fLoopStateTracker;
    }

    public Queue<Interval> pGetPendingQueue() {
        return this.fPendingQueue;
    }

    @Override
    public synchronized void beginLoop(ByteBufferHandle[] byteBufferHandleArray) {
        assert (this.fLoopStateTracker.getState() == LoopState.Acquired) : "Invalid LoopState - should be Acquired but is " + (Object)((Object)this.fLoopStateTracker.getState());
        this.fLoopStateTracker.setState(LoopState.Started);
        if (this.fPolicy.useSendToAllForLoopInitData()) {
            PackageInfo.LOGGER.info("Sending broadcast data separately.");
            this.sendBroadcastData(Arrays.copyOf(byteBufferHandleArray, byteBufferHandleArray.length));
        } else {
            this.fInitData = Arrays.copyOf(byteBufferHandleArray, byteBufferHandleArray.length);
            PackageInfo.LOGGER.info("Not sending broadcast data separately.");
        }
    }

    private synchronized void sendBroadcastData(ByteBufferHandle[] byteBufferHandleArray) {
        Object[] objectArray = new Object[]{byteBufferHandleArray, ByteBufferHandle.allocate(0), false};
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand("remoteParallelFunction", objectArray, 2, MFevalCommand.ConsoleOutput.Discard);
        ResponseTracker responseTracker = new ResponseTracker();
        this.fOutGroup.sendTo(new ArrayList<ProcessInstance>(this.fAcquiredLabs), (ObservableMessage)mFevalLargeDataCommand, (RoleMessageObserver)new BroadcastDataObserver(responseTracker, byteBufferHandleArray));
    }

    @Override
    public synchronized boolean addInterval(int n, ByteBufferHandle[] byteBufferHandleArray) {
        return this.addInterval(n, byteBufferHandleArray, IntervalType.Normal);
    }

    @Override
    public synchronized boolean addFinalInterval(int n, ByteBufferHandle[] byteBufferHandleArray) {
        return this.addInterval(n, byteBufferHandleArray, IntervalType.Final);
    }

    @Override
    public synchronized void interruptOnError() {
        this.fDrainableOutput.closeForOutput();
        this.doInterrupt();
    }

    @Override
    public synchronized void interrupt() {
        this.doInterrupt();
    }

    @Override
    public synchronized DrainableOutput getDrainableOutput() {
        return this.fDrainableOutput;
    }

    private synchronized boolean addInterval(int n, ByteBufferHandle[] byteBufferHandleArray, IntervalType intervalType) {
        Interval interval;
        assert (this.fLoopStateTracker.getState().ordinal() >= LoopState.Started.ordinal()) : "Invalid LoopState - should be Started but is " + (Object)((Object)this.fLoopStateTracker.getState());
        assert (this.fNumFinalIntervals < this.fNumLabsAcquired) : "Number of final intervals cannot be more that the number of labs";
        if (this.fLoopInterrupted || !this.fSessionService.isSessionRunning()) {
            ByteBufferHandle.freeBuffers(byteBufferHandleArray);
            return false;
        }
        if (intervalType == IntervalType.Final) {
            ++this.fNumFinalIntervals;
        }
        if (!this.attemptToSendInterval(interval = new Interval(n, byteBufferHandleArray, intervalType))) {
            this.fPendingQueue.add(interval);
        }
        return true;
    }

    private synchronized boolean attemptToSendInterval(Interval interval) {
        assert (!this.fLoopInterrupted) : "Should not send an interval if the loop state is interrupted";
        assert (this.fLoopStateTracker.getNumStarted() <= this.fNumLabsAcquired) : "Number of start intervals cannot be more that the number of labs";
        final ProcessInstance processInstance = this.getNextAvailableLab();
        if (processInstance == null) {
            return false;
        }
        LoopState loopState = this.fLoopStateTracker.getState(processInstance);
        assert (loopState != LoopState.SendComplete) : "Invalid LoopState - should not be SendComplete";
        Object[] objectArray = new Object[3];
        final IntervalType intervalType = interval.getType();
        objectArray[0] = loopState == LoopState.Acquired && this.fInitData != null ? this.fInitData : ByteBufferHandle.allocate(0);
        objectArray[1] = interval.getData();
        objectArray[2] = intervalType == IntervalType.Final;
        final int n = interval.getTag();
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand("remoteParallelFunction", objectArray, 2, MFevalCommand.ConsoleOutput.Return);
        RoleMessageObserver roleMessageObserver = new RoleMessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, ProcessInstance processInstance2) {
                ParforControllerImpl.this.handleReturnMessage(processInstance, n, intervalType, returnMessage, processInstance2);
            }

            @Override
            public void aborted(long l, ProcessInstance processInstance2) {
                ParforControllerImpl.this.onWorkerAbortedWhileProcessing(n, l, processInstance2);
            }

            @Override
            public void expectReturnsFrom(long l, List<ProcessInstance> list) {
                if (list.isEmpty()) {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "ParforControllerImpl.attemptToSendInterval failed to send to " + processInstance);
                    ParforControllerImpl.this.onWorkerAbortedWhileProcessing(n, l, processInstance);
                } else assert (list.size() == 1 && list.get(0).equals(processInstance));
            }
        };
        this.fOutGroup.sendTo(processInstance, (ObservableMessage)mFevalLargeDataCommand, roleMessageObserver);
        int n2 = this.fNumMessagesInFlight.incrementAndGet();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ParforControllerImpl.attemptToSendInterval incremented numInFlight to: " + n2);
        ByteBufferHandle.freeBuffers(interval.getData());
        if (loopState == LoopState.Acquired) {
            this.fLoopStateTracker.setState(processInstance, LoopState.Started);
        }
        if (interval.getType() == IntervalType.Final) {
            this.fLoopStateTracker.setState(processInstance, LoopState.SendComplete);
        }
        if (this.fLoopStateTracker.getNumStarted() == this.fNumLabsAcquired && this.fInitData != null) {
            ByteBufferHandle.freeBuffers(this.fInitData);
            this.fInitData = null;
        }
        return true;
    }

    private synchronized void handleReturnMessage(ProcessInstance processInstance, int n, IntervalType intervalType, ReturnMessage returnMessage, ProcessInstance processInstance2) {
        if (returnMessage instanceof FinalReturnMessage) {
            this.onIntervalCompleted(processInstance, n, intervalType, (FinalReturnMessage)returnMessage, processInstance2);
        } else if (returnMessage instanceof CmdWinOutput) {
            String[] stringArray = ((CmdWinOutput)returnMessage).getStrings();
            this.fDrainableOutput.addOutput(processInstance, stringArray);
        }
    }

    private synchronized void onFinalReturnMessage(FinalReturnMessage finalReturnMessage, ProcessInstance processInstance) {
        int n = this.fNumMessagesInFlight.decrementAndGet();
        assert (n >= 0) : "Cannot have less than zero messages in flight";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Received a message: " + finalReturnMessage + " from " + processInstance + ", fLoopInterrupted: " + this.fLoopInterrupted + ", numInFlight: " + n);
        if (n == 0) {
            if (this.fLoopInterrupted || this.fNumFinalIntervals == this.fNumLabsAcquired) {
                this.fLoopStateTracker.setState(LoopState.ReceiveComplete);
                PackageInfo.LOGGER.fine("Loop complete: releasing holder, notifying.");
                this.fResourceManager.releaseCurrentHolder(this);
                this.notifyReleaseWorkers();
                this.fCompletedLatch.countDown();
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Messages in flight == 0");
        }
    }

    private synchronized void onWorkerAbortedWhileProcessing(int n, long l, ProcessInstance processInstance) {
        boolean bl = this.removeLab(processInstance);
        if (bl) {
            ParforController.IntervalResult intervalResult = IntervalResultImpl.buildWorkerAborted(n);
            boolean bl2 = this.fIntervalCompleteQueue.offer(intervalResult);
            assert (bl2) : "Unable to put return interval on the interval complete queue";
            this.abortLoop();
        }
        this.onFinalReturnMessage(new WorkerAbortedFinalReturnMessage(l), processInstance);
    }

    private synchronized void abortLoop() {
        if (!this.fLoopInterrupted) {
            this.fDrainableOutput.closeForOutput();
            this.doInterrupt();
        }
    }

    private synchronized void onIntervalCompleted(ProcessInstance processInstance, int n, IntervalType intervalType, FinalReturnMessage finalReturnMessage, ProcessInstance processInstance2) {
        if (!this.fLoopInterrupted) {
            ParforController.IntervalResult intervalResult = IntervalResultImpl.buildNormalCompletionResult(n, finalReturnMessage);
            boolean bl = this.fIntervalCompleteQueue.offer(intervalResult);
            assert (bl) : "Unable to put return interval on the interval complete queue";
            if (intervalResult.hasError()) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Error detected on rank " + processInstance + " - interrupting loop");
                this.abortLoop();
            } else if (intervalType == IntervalType.Normal) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Putting token for rank " + processInstance + " on the available labs queue");
                this.makeLabAvailable(processInstance);
                Interval interval = this.fPendingQueue.poll();
                if (interval != null) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Sending a pending interval.");
                    if (!this.attemptToSendInterval(interval)) {
                        this.fPendingQueue.push(interval);
                    }
                }
            } else if (intervalType == IntervalType.Final) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Rank : " + processInstance + " is now finished processing intervals");
                this.fLoopStateTracker.setState(processInstance, LoopState.ReceiveComplete);
            }
        } else if (finalReturnMessage instanceof FevalResult) {
            ((FevalResult)finalReturnMessage).dispose();
        }
        this.onFinalReturnMessage(finalReturnMessage, processInstance2);
    }

    private synchronized void doInterrupt() {
        if (this.fLoopInterrupted || !this.fSessionService.isSessionRunning()) {
            return;
        }
        if (this.fLoopStateTracker.getState() == LoopState.ReceiveComplete) {
            return;
        }
        this.fLoopInterrupted = true;
        MInterrupt mInterrupt = new MInterrupt();
        RoleMessageObserver roleMessageObserver = new RoleMessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                if (returnMessage instanceof FinalReturnMessage) {
                    ParforControllerImpl.this.onFinalReturnMessage((FinalReturnMessage)returnMessage, processInstance);
                }
            }

            @Override
            public void aborted(long l, ProcessInstance processInstance) {
                ParforControllerImpl.this.onWorkerAbortedWhileProcessing(-1, l, processInstance);
            }

            @Override
            public void expectReturnsFrom(long l, List<ProcessInstance> list) {
                int n = list.size();
                if (n == 0) {
                    int n2 = ParforControllerImpl.this.fNumMessagesInFlight.decrementAndGet();
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ParforControllerImpl.doInterrupt/expectReturnsFrom() decremented numInFlight to: " + n2);
                } else assert (n == 1);
            }
        };
        List<ProcessInstance> list = this.getAllLabs();
        for (ProcessInstance object : list) {
            this.fOutGroup.sendTo(object, (ObservableMessage)mInterrupt, roleMessageObserver);
            int n = this.fNumMessagesInFlight.incrementAndGet();
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ParforControllerImpl.doInterrupt() incremented numInFlight to: " + n);
        }
        for (Interval interval : this.fPendingQueue) {
            interval.freeBuffers();
        }
        this.fPendingQueue.clear();
        this.makeAllLabsBusy();
    }

    private synchronized void makeLabAvailable(ProcessInstance processInstance) {
        boolean bl = this.fAvailableLabs.offer(processInstance);
        assert (bl) : "Unable to put token on the available labs queue";
    }

    private synchronized void makeAllLabsBusy() {
        this.fAvailableLabs.clear();
    }

    private synchronized boolean removeLab(ProcessInstance processInstance) {
        boolean bl = this.fAcquiredLabs.remove(processInstance);
        boolean bl2 = this.fAvailableLabs.remove(processInstance);
        if (bl) {
            this.fLoopStateTracker.removeLab(processInstance);
            int n = this.fNumLabsNotified;
            this.notifyAcquiredWorkers(n - 1);
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "ParforControllerImpl.removeLab(" + processInstance + ") with wasKnown: " + bl + " and wasIdle: " + bl2);
        return bl;
    }

    private synchronized List<ProcessInstance> getAllLabs() {
        return Collections.unmodifiableList(this.fAcquiredLabs);
    }

    private synchronized ProcessInstance getNextAvailableLab() {
        return this.fAvailableLabs.poll();
    }

    private void notifyAcquiredWorkers(int n) {
        PackageInfo.LOGGER.finest("In ParforControllerImpl.notifyAcquiredWorkers with numWorkers: " + n + ", and fNumLabsNotified: " + this.fNumLabsNotified);
        if (n == 0 && this.fNumLabsNotified > 0) {
            this.notifyReleaseWorkers();
        } else {
            this.fNumLabsNotified = n;
            this.fSessionService.getSessionWorkerNotifier().notifyAcquiredWorkers(n);
        }
    }

    private void notifyReleaseWorkers() {
        PackageInfo.LOGGER.finest("In ParforControllerImpl.notifyReleaseWorkers with fNumLabsNotified: " + this.fNumLabsNotified);
        if (this.fNumLabsNotified > 0) {
            this.fSessionService.getSessionWorkerNotifier().notifyReleasedWorkers(this.fNumLabsNotified);
            this.fNumLabsNotified = 0;
        }
    }

    private static final class Interval {
        private final int fTag;
        private final IntervalType fType;
        private final ByteBufferHandle[] fData;

        Interval(int n, ByteBufferHandle[] byteBufferHandleArray, IntervalType intervalType) {
            this.fTag = n;
            this.fType = intervalType;
            this.fData = Arrays.copyOf(byteBufferHandleArray, byteBufferHandleArray.length);
        }

        ByteBufferHandle[] getData() {
            return Arrays.copyOf(this.fData, this.fData.length);
        }

        IntervalType getType() {
            return this.fType;
        }

        int getTag() {
            return this.fTag;
        }

        void freeBuffers() {
            ByteBufferHandle.freeBuffers(this.fData);
        }
    }

    private static final class LoopStateTracker {
        private LoopState fLoopState;
        private Map<ProcessInstance, LoopState> fInstanceToState = Collections.synchronizedMap(new HashMap());
        private int fNumStarted;
        private int fNumSendComplete;
        private int fNumReceiveComplete;

        LoopStateTracker(List<ProcessInstance> list) {
            if (list != null) {
                for (ProcessInstance processInstance : list) {
                    this.fInstanceToState.put(processInstance, LoopState.Initialized);
                }
            }
            this.fLoopState = LoopState.Initialized;
            this.fNumStarted = 0;
            this.fNumSendComplete = 0;
            this.fNumReceiveComplete = 0;
        }

        public synchronized LoopState getState() {
            return this.fLoopState;
        }

        public synchronized LoopState getState(ProcessInstance processInstance) {
            return this.fInstanceToState.get(processInstance);
        }

        public synchronized int getNumStarted() {
            return this.fNumStarted;
        }

        public synchronized int getNumSendComplete() {
            return this.fNumSendComplete;
        }

        public synchronized int getNumReceiveComplete() {
            return this.fNumReceiveComplete;
        }

        synchronized void setState(LoopState loopState) {
            assert (loopState.ordinal() >= this.fLoopState.ordinal()) : "LoopState must increase";
            this.fLoopState = loopState;
        }

        synchronized void removeLab(ProcessInstance processInstance) {
            this.fInstanceToState.remove(processInstance);
        }

        synchronized void setState(ProcessInstance processInstance, LoopState loopState) {
            assert (loopState.ordinal() > this.getState(processInstance).ordinal()) : "LoopState must increase";
            this.fInstanceToState.put(processInstance, loopState);
            boolean bl = false;
            switch (loopState) {
                case Acquired: {
                    bl = this.fLoopState != loopState;
                    break;
                }
                case Started: {
                    ++this.fNumStarted;
                    bl = this.fLoopState != loopState;
                    break;
                }
                case SendComplete: {
                    bl = ++this.fNumSendComplete == this.fInstanceToState.size();
                    break;
                }
                case ReceiveComplete: {
                    bl = ++this.fNumReceiveComplete == this.fInstanceToState.size();
                    break;
                }
                case Initialized: {
                    assert (false) : "Not allowed to set state to 'Initialized'";
                    break;
                }
            }
            if (bl) {
                this.fLoopState = loopState;
            }
        }
    }

    private static final class IntervalResultImpl
    implements ParforController.IntervalResult {
        private final int fTag;
        private Object fResult;
        private Object fError;
        private final boolean fIsWorkerAborted;

        static ParforController.IntervalResult buildWorkerAborted(int n) {
            return new IntervalResultImpl(n);
        }

        static ParforController.IntervalResult buildNormalCompletionResult(int n, FinalReturnMessage finalReturnMessage) {
            return new IntervalResultImpl(n, finalReturnMessage);
        }

        private IntervalResultImpl(int n) {
            this.fTag = n;
            this.fResult = null;
            this.fError = "Worker aborted.";
            this.fIsWorkerAborted = true;
        }

        private IntervalResultImpl(int n, FinalReturnMessage finalReturnMessage) {
            this.fTag = n;
            this.fResult = null;
            this.fError = null;
            this.initResultAndError((FevalResult)finalReturnMessage);
            this.fIsWorkerAborted = false;
        }

        private void initResultAndError(FevalResult fevalResult) {
            if (!fevalResult.isSuccess()) {
                Exception exception = fevalResult.getException();
                if (exception instanceof RemoteMatlabException) {
                    RemoteMatlabException.Type type = ((RemoteMatlabException)exception).getType();
                    switch (type) {
                        case COMPILE: {
                            this.fError = "Error in remote execution of remoteParallelFunction : COMPILE_ERROR";
                            break;
                        }
                        case RUNTIME: {
                            this.fError = "Error in remote execution of remoteParallelFunction : RUNTIME_ERROR";
                            break;
                        }
                        case INTERRUPT: {
                            this.fError = "Error in remote execution of remoteParallelFunction : EXECUTION_CTRLC";
                        }
                    }
                } else assert (false) : "Unknown Execution status encountered : exception = " + exception;
                return;
            }
            this.fResult = fevalResult.getResult();
            int n = fevalResult.getNlhs();
            switch (n) {
                case 0: {
                    if (this.fResult == null) break;
                    this.fError = "Error in remote execution of remoteParallelFunction : non-null output for NLHS 0";
                    break;
                }
                case 1: {
                    if (this.fResult == null) {
                        this.fError = "Error in remote execution of remoteParallelFunction : null output for NLHS 1";
                        break;
                    }
                    if (!this.outputSuggestsError(this.fResult)) break;
                    this.fError = "Error in remote execution of remoteParallelFunction : a single boolean output indicates an error occurred";
                    break;
                }
                default: {
                    if (this.fResult instanceof Object[] && ((Object[])this.fResult).length == n) {
                        Object[] objectArray = (Object[])this.fResult;
                        if (!this.outputSuggestsError(objectArray[0])) break;
                        this.fError = objectArray[1];
                        break;
                    }
                    this.fError = "Error in remote execution of remoteParallelFunction : Object[" + n + "] expected : " + this.fResult + "received";
                }
            }
        }

        private boolean outputSuggestsError(Object object) {
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                return blArray.length == 1 && blArray[0];
            }
            return false;
        }

        @Override
        public int getTag() {
            return this.fTag;
        }

        @Override
        public boolean hasError() {
            return this.fError != null;
        }

        @Override
        public Object getResult() {
            return this.fResult;
        }

        @Override
        public Object getError() {
            return this.fError;
        }

        @Override
        public boolean isWorkerAbortedError() {
            return this.fIsWorkerAborted;
        }
    }

    private static final class WorkerAbortedFinalReturnMessage
    extends DefaultFinalReturnMessage {
        private WorkerAbortedFinalReturnMessage(long l) {
            super(l);
        }
    }

    private static final class BroadcastDataObserver
    implements RoleMessageObserver {
        private final ResponseTracker<ProcessInstance> fTracker;
        private final long fStartTime;
        private final ByteBufferHandle[] fInitData;

        private BroadcastDataObserver(ResponseTracker<ProcessInstance> responseTracker, ByteBufferHandle[] byteBufferHandleArray) {
            this.fTracker = responseTracker;
            this.fInitData = byteBufferHandleArray;
            this.fStartTime = System.currentTimeMillis();
        }

        private void freeDataIfNowComplete(boolean bl) {
            if (bl) {
                ByteBufferHandle.freeBuffers(this.fInitData);
                long l = System.currentTimeMillis();
                PackageInfo.LOGGER.finer("Total time for broadcast: " + (l - this.fStartTime) + " millis.");
            }
        }

        @Override
        public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
            this.freeDataIfNowComplete(this.fTracker.addResponder(processInstance));
        }

        @Override
        public void aborted(long l, ProcessInstance processInstance) {
            this.freeDataIfNowComplete(this.fTracker.addResponder(processInstance));
        }

        @Override
        public void expectReturnsFrom(long l, List<ProcessInstance> list) {
            this.freeDataIfNowComplete(this.fTracker.setExpectedResponders(list));
        }
    }

    public static enum BroadcastPolicy {
        FOLD_WITH_FIRST_INTERVAL{

            @Override
            boolean useSendToAllForLoopInitData() {
                return false;
            }
        }
        ,
        SEND_TO_ALL{

            @Override
            boolean useSendToAllForLoopInitData() {
                return true;
            }
        };


        abstract boolean useSendToAllForLoopInitData();
    }

    private static enum IntervalType {
        Normal,
        Final;

    }

    private static enum LoopState {
        Initialized,
        Acquired,
        Started,
        SendComplete,
        ReceiveComplete;

    }
}

