/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.DefaultFinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class PathNotificationCommand
extends MDispatchableCommand {
    private PathNotificationType fNotificationType;
    private Collection<String> fArguments = new ArrayList<String>();

    public PathNotificationCommand(PathNotificationType pathNotificationType, String string) {
        this.fNotificationType = pathNotificationType;
        this.fArguments.add(string);
    }

    public PathNotificationCommand(PathNotificationType pathNotificationType, String[] stringArray) {
        this.fNotificationType = pathNotificationType;
        this.fArguments.addAll(Arrays.asList(stringArray));
    }

    public PathNotificationCommand(PathNotificationType pathNotificationType, String[] stringArray, String string) {
        assert (pathNotificationType == PathNotificationType.ADDPATH) : "Where field only applicable to ADDPATH";
        this.fNotificationType = pathNotificationType;
        this.fArguments.addAll(Arrays.asList(stringArray));
        this.fArguments.add(string);
    }

    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, SessionService sessionService) {
        PathNotificationCommandResult pathNotificationCommandResult = new PathNotificationCommandResult(this.getSequenceNumber());
        returnGroup.returnTo(this.getSourceProcess(), (ReturnMessage)pathNotificationCommandResult);
        if (this.fArguments == null || this.fArguments.isEmpty()) {
            return;
        }
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        Object[] objectArray = this.fArguments.toArray();
        switch (this.fNotificationType) {
            case ADDPATH: {
                matlabMCR.fevalNoOutput("addpath", objectArray);
                break;
            }
            case RMPATH: {
                matlabMCR.fevalNoOutput("rmpath", objectArray);
                break;
            }
            case CD: {
                matlabMCR.fevalNoOutput("cd", objectArray);
            }
        }
    }

    private static class PathNotificationCommandResult
    extends DefaultFinalReturnMessage {
        protected PathNotificationCommandResult(long l) {
            super(l);
        }
    }

    public static enum PathNotificationType {
        ADDPATH,
        RMPATH,
        CD;

    }
}

