/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingleRemoteEvaluationObserver
implements RoleMessageObserver {
    private FevalResult fResult = null;
    private final CountDownLatch fLatch = new CountDownLatch(1);
    private final AtomicBoolean fDisposed = new AtomicBoolean(false);
    private boolean fFreed = false;

    @Override
    public final synchronized void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
        if (returnMessage instanceof FevalResult) {
            this.fResult = (FevalResult)returnMessage;
            this.fLatch.countDown();
            this.disposeResultIfReceivedAndDisposed();
        }
    }

    @Override
    public synchronized void aborted(long l, ProcessInstance processInstance) {
        this.fLatch.countDown();
        this.fFreed = true;
    }

    @Override
    public synchronized void expectReturnsFrom(long l, List<ProcessInstance> list) {
        int n = list.size();
        assert (n == 0 || n == 1);
        if (n == 0) {
            this.fLatch.countDown();
            this.fFreed = true;
        }
    }

    private synchronized void disposeResultIfReceivedAndDisposed() {
        if (this.await(0L, TimeUnit.SECONDS) && this.fDisposed.get() && !this.fFreed) {
            assert (this.fResult != null) : "Didn't have result to dispose";
            this.fResult.dispose();
            this.fFreed = true;
        }
    }

    public final void dispose() {
        this.fDisposed.set(true);
        this.disposeResultIfReceivedAndDisposed();
    }

    public final boolean await(long l, TimeUnit timeUnit) {
        try {
            return this.fLatch.await(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public final synchronized FevalResult getResult() {
        assert (this.fResult != null) : "Null result!";
        return this.fResult;
    }
}

